/*
 * Decompiled with CFR 0.152.
 */
package factorization.client.render;

import factorization.api.VectorUV;
import factorization.client.render.FactorizationBlockRender;
import factorization.common.Core;
import factorization.common.FactoryType;
import factorization.common.RenderingCube;
import factorization.common.TileEntityGreenware;

public class BlockRenderGreenware
extends FactorizationBlockRender {
    static BlockRenderGreenware instance;
    private boolean texture_init = false;
    static RenderingCube woodStand;
    static RenderingCube genericLump;

    public BlockRenderGreenware() {
        instance = this;
        this.setup();
    }

    public void setup() {
        if (this.texture_init) {
            return;
        }
    }

    @Override
    void render(bbb rb) {
        TileEntityGreenware.ClayState state;
        if (!this.world_mode) {
            this.renderStand();
            this.renderGenericLump();
            return;
        }
        TileEntityGreenware gw = (TileEntityGreenware)this.getCoord().getTE(TileEntityGreenware.class);
        if (gw == null) {
            return;
        }
        if (this.world_mode) {
            baz.a.c(Core.registry.factory_block.e(this.w, this.x, this.y, this.z));
        }
        if ((state = gw.getState()) == TileEntityGreenware.ClayState.DRY || state == TileEntityGreenware.ClayState.WET) {
            this.renderStand();
        }
        if (!gw.canEdit()) {
            this.renderStatic(gw);
        }
        gw.renderedAsBlock = true;
    }

    void renderDynamic(TileEntityGreenware greenware) {
        for (RenderingCube rc : greenware.parts) {
            rc.setIcon(greenware.getIcon(rc));
            this.renderCube(rc);
        }
    }

    void renderStatic(TileEntityGreenware greenware) {
        for (RenderingCube rc : greenware.parts) {
            rc.setIcon(greenware.getIcon(rc));
            this.renderCube(rc);
        }
    }

    void renderStand() {
        this.renderCube(woodStand);
    }

    void renderGenericLump() {
        this.renderCube(genericLump);
    }

    @Override
    FactoryType getFactoryType() {
        return FactoryType.GREENWARE;
    }

    static {
        woodStand = new RenderingCube(194, new VectorUV(4.0f, 1.0f, 4.0f));
        genericLump = new RenderingCube(192, new VectorUV(3.0f, 5.0f, 3.0f));
        BlockRenderGreenware.woodStand.trans.translate(0.0f, -6.0f, 0.0f);
    }
}

