/*
 * Decompiled with CFR 0.152.
 */
package factorization.api.recipe;

import factorization.api.recipe.GenericRecipe;
import factorization.api.recipe.GenericRecipeOutput;
import factorization.api.recipe.IGenericRecipeInput;
import factorization.api.recipe.InputItemStack;
import factorization.api.recipe.InputOreDict;
import java.util.ArrayList;

public class GenericRecipeManager {
    public ArrayList recipes = new ArrayList();
    private Object[] inputs;

    public GenericRecipeManager input(Object ... inputs) {
        if (inputs != null) {
            throw new IllegalArgumentException("output() must be called to finish the recipe definition");
        }
        this.inputs = inputs;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericRecipe output(Object ... outputs) {
        if (this.inputs == null) {
            throw new IllegalArgumentException("input() must be called to begin the recipe definition");
        }
        try {
            GenericRecipe genericRecipe = new GenericRecipe(this.convertInput(this.inputs), this.convertOutput(outputs));
            return genericRecipe;
        }
        finally {
            this.inputs = null;
        }
    }

    private IGenericRecipeInput[] convertInput(Object[] inputs) {
        ArrayList<IGenericRecipeInput> ret = new ArrayList<IGenericRecipeInput>(inputs.length);
        for (int i = 0; i < inputs.length; ++i) {
            Object first = inputs[i];
            if (first instanceof IGenericRecipeInput) {
                ret.add((IGenericRecipeInput)first);
                continue;
            }
            if (first instanceof ur) {
                ret.add(new InputItemStack((ur)first));
                continue;
            }
            if (first instanceof String) {
                ret.add(new InputOreDict((String)first));
                continue;
            }
            if (first instanceof up) {
                ret.add(new InputItemStack(new ur((up)first, 1, 1)));
                continue;
            }
            if (first instanceof amq) {
                ret.add(new InputItemStack(new ur((amq)first, 1, 1)));
                continue;
            }
            throw new IllegalArgumentException("Must be ItemStack/Item/Block/String<OreDictionaryName>/IGenericRecipeInput: " + first);
        }
        return (IGenericRecipeInput[])ret.toArray();
    }

    private GenericRecipeOutput[] convertOutput(Object[] outputs) {
        ArrayList<GenericRecipeOutput> ret = new ArrayList<GenericRecipeOutput>(outputs.length);
        for (int i = 0; i < this.inputs.length; ++i) {
            Object first = this.inputs[i];
            if (first instanceof GenericRecipeOutput) {
                ret.add((GenericRecipeOutput)first);
                continue;
            }
            double bonus = 0.0;
            if (first instanceof Double || first instanceof Float) {
                bonus = (Double)first;
                first = this.inputs[++i];
            }
            ur is = null;
            if (first instanceof ur) {
                is = (ur)first;
            } else if (first instanceof up) {
                is = new ur((up)first, 1, 1);
            } else if (first instanceof amq) {
                is = new ur((amq)first, 1, 1);
            } else {
                throw new IllegalArgumentException("Must be [Float] ItemStack/Item/Block: " + first);
            }
            ret.add(new GenericRecipeOutput(is, bonus));
        }
        return (GenericRecipeOutput[])ret.toArray();
    }
}

