/*
 * Decompiled with CFR 0.152.
 */
package factorization.api;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;

public class VectorUV {
    public float x;
    public float y;
    public float z;
    public float u;
    public float v;

    public VectorUV() {
        this(0.0f, 0.0f, 0.0f);
    }

    public VectorUV(float x, float y2, float z) {
        this.x = x;
        this.y = y2;
        this.z = z;
        this.u = 0.0f;
        this.v = 0.0f;
    }

    public VectorUV(float x, float y2, float z, float u, float v) {
        this.x = x;
        this.y = y2;
        this.z = z;
        this.u = u;
        this.v = v;
    }

    public boolean equals(VectorUV other) {
        return this.x == other.x && this.y == other.y && this.z == other.z && this.u == other.u && this.v == other.v;
    }

    public void rotate(float a, float b, float c, float argtheta) {
        double theta = Math.toRadians(argtheta);
        float ox = this.x;
        float oy = this.y;
        float oz = this.z;
        float cos_theta = (float)Math.cos(theta);
        float sin_theta = (float)Math.sin(theta);
        float product = (a * ox + b * oy + c * oz) * (1.0f - cos_theta);
        this.x = a * product + ox * cos_theta + (-c * oy + b * oz) * sin_theta;
        this.y = b * product + oy * cos_theta + (c * ox - a * oz) * sin_theta;
        this.z = c * product + oz * cos_theta + (-b * ox + a * oy) * sin_theta;
    }

    public VectorUV add(int dx, int dy, int dz) {
        return new VectorUV(this.x + (float)dx, this.y + (float)dy, this.z + (float)dz, this.u, this.v);
    }

    public VectorUV add(VectorUV o) {
        return new VectorUV(this.x + o.x, this.y + o.y, this.z + o.z, this.u, this.v);
    }

    public VectorUV subtract(VectorUV o) {
        return new VectorUV(this.x - o.x, this.y - o.y, this.z - o.z, this.u, this.v);
    }

    public void scale(float d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
    }

    public void incr(VectorUV d) {
        this.x += d.x;
        this.y += d.y;
        this.z += d.z;
    }

    public VectorUV copy() {
        return new VectorUV(this.x, this.y, this.z, this.u, this.v);
    }

    public VectorUV negate() {
        return new VectorUV(-this.x, -this.y, -this.z, this.u, this.v);
    }

    public String toString() {
        return "<" + this.x + ", " + this.y + ", " + this.z + ">";
    }

    public void writeToTag(bq tag, String prefix) {
        tag.a(prefix + "x", this.x);
        tag.a(prefix + "y", this.y);
        tag.a(prefix + "z", this.z);
    }

    public static VectorUV readFromTag(bq tag, String prefix) {
        float x = tag.g(prefix + "x");
        float y2 = tag.g(prefix + "y");
        float z = tag.g(prefix + "z");
        return new VectorUV(x, y2, z);
    }

    public static VectorUV readFromDataInput(DataInput input) throws IOException {
        return new VectorUV(input.readFloat(), input.readFloat(), input.readFloat());
    }

    public void addInfoToArray(ArrayList args) {
        args.add(Float.valueOf(this.x));
        args.add(Float.valueOf(this.y));
        args.add(Float.valueOf(this.z));
    }

    public float get(int axis) {
        switch (axis) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new RuntimeException("Invalid argument");
    }
}

