/*
 * Decompiled with CFR 0.152.
 */
package factorization.api;

import com.google.common.io.ByteArrayDataOutput;
import java.io.DataInput;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;

public class Quaternion {
    public double w;
    public double x;
    public double y;
    public double z;
    private static ThreadLocal localStaticArray = new ThreadLocal(){

        protected double[] initialValue() {
            return new double[4];
        }
    };
    private static final double DOT_THRESHOLD = 0.9995;

    public Quaternion() {
        this(1.0, 0.0, 0.0, 0.0);
    }

    public Quaternion(double w2, double x, double y2, double z) {
        this.w = w2;
        this.x = x;
        this.y = y2;
        this.z = z;
    }

    public Quaternion(Quaternion orig) {
        this.w = orig.w;
        this.x = orig.x;
        this.y = orig.y;
        this.z = orig.z;
    }

    public Quaternion(double[] init) {
        this(init[0], init[1], init[2], init[3]);
        assert (init.length == 4);
    }

    public Quaternion(double w2, aoj v) {
        this(w2, v.c, v.d, v.e);
    }

    public boolean isEqual(Quaternion other) {
        return this.w == other.w && this.x == other.x && this.y == other.y && this.z == other.z;
    }

    public String toString() {
        return "Quaternion(" + this.w + ", " + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public void writeToTag(bq tag, String prefix) {
        tag.a(prefix + "w", this.w);
        tag.a(prefix + "x", this.x);
        tag.a(prefix + "y", this.y);
        tag.a(prefix + "z", this.z);
    }

    public static Quaternion loadFromTag(bq tag, String prefix) {
        return new Quaternion(tag.h(prefix + "w"), tag.h(prefix + "x"), tag.h(prefix + "y"), tag.h(prefix + "z"));
    }

    public void write(ByteArrayDataOutput out) {
        double[] d = this.toStaticArray();
        for (int i = 0; i < d.length; ++i) {
            out.writeDouble(d[i]);
        }
    }

    public static Quaternion read(DataInput in2) throws IOException {
        double[] d = (double[])localStaticArray.get();
        for (int i = 0; i < d.length; ++i) {
            d[i] = in2.readDouble();
        }
        return new Quaternion(d);
    }

    public double[] fillArray(double[] out) {
        out[0] = this.w;
        out[1] = this.x;
        out[2] = this.y;
        out[3] = this.z;
        return out;
    }

    public double[] toArray() {
        return this.fillArray(new double[4]);
    }

    public double[] toStaticArray() {
        return this.fillArray((double[])localStaticArray.get());
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public void update(double nw, double nx, double ny, double nz) {
        this.w = nw;
        this.x = nx;
        this.y = ny;
        this.z = nz;
    }

    public void update(Quaternion other) {
        this.update(other.w, other.x, other.y, other.z);
    }

    public void updateVector(aoj v) {
        v.c = this.x;
        v.d = this.y;
        v.e = this.z;
    }

    public aoj toVector() {
        return aoj.a((double)this.x, (double)this.y, (double)this.z);
    }

    public void incrNormalize() {
        double normSquared = this.magnitudeSquared();
        if (normSquared == 1.0 || normSquared == 0.0) {
            return;
        }
        double norm = Math.sqrt(normSquared);
        this.w /= norm;
        this.x /= norm;
        this.y /= norm;
        this.z /= norm;
    }

    public static Quaternion getRotationQuaternion(double angle, aoj axis) {
        double halfAngle = angle / 2.0;
        double sin = Math.sin(halfAngle);
        return new Quaternion(Math.cos(halfAngle), axis.c * sin, axis.d * sin, axis.e * sin);
    }

    public static Quaternion getRotationQuaternion(double angle, ForgeDirection axis) {
        double halfAngle = angle / 2.0;
        double sin = Math.sin(halfAngle);
        return new Quaternion(Math.cos(halfAngle), (double)axis.offsetX * sin, (double)axis.offsetY * sin, (double)axis.offsetZ * sin);
    }

    public static Quaternion getRotationQuaternion(double angle, double ax, double ay, double az) {
        double halfAngle = angle / 2.0;
        double sin = Math.sin(halfAngle);
        return new Quaternion(Math.cos(halfAngle), ax * sin, ay * sin, az * sin);
    }

    public double setVector(aoj axis) {
        double halfAngle = Math.acos(this.w);
        double sin = Math.sin(halfAngle);
        axis.c = this.x / sin;
        axis.d = this.y / sin;
        axis.e = this.z / sin;
        return halfAngle * 2.0;
    }

    public double dotProduct(Quaternion other) {
        return this.w * other.w + this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public Quaternion slerp(Quaternion other, double t) {
        double dot = this.dotProduct(other);
        if (dot > 0.9995) {
            Quaternion result = new Quaternion(this);
            Quaternion temp = other.add(this, -1.0);
            temp.incrScale(t);
            result.incrAdd(temp);
            result.incrNormalize();
            return result;
        }
        dot = Math.min(-1.0, Math.max(1.0, dot));
        double theta_0 = Math.acos(dot);
        double theta = theta_0 * t;
        Quaternion v2 = other.add(this, -dot);
        v2.incrNormalize();
        Quaternion ret = this.scale(Math.cos(theta));
        v2.incrScale(Math.sin(theta));
        ret.incrAdd(v2);
        return ret;
    }

    public double magnitude() {
        return Math.sqrt(this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double magnitudeSquared() {
        return this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double incrDistance(Quaternion other) {
        this.incrAdd(other);
        return this.magnitude();
    }

    public void incrConjugate() {
        this.x *= -1.0;
        this.y *= -1.0;
        this.z *= -1.0;
    }

    public void incrAdd(Quaternion other) {
        this.w += other.w;
        this.x += other.x;
        this.y += other.y;
        this.z += other.z;
    }

    public void incrAdd(Quaternion other, double scale) {
        this.w += other.w * scale;
        this.x += other.x * scale;
        this.y += other.y * scale;
        this.z += other.z * scale;
    }

    public void incrMultiply(Quaternion other) {
        double nw = this.w * other.w - this.x * other.x - this.y * other.y - this.z * other.z;
        double nx = this.w * other.x + this.x * other.w + this.y * other.z - this.z * other.y;
        double ny = this.w * other.y - this.x * other.z + this.y * other.w + this.z * other.x;
        double nz = this.w * other.z + this.x * other.y - this.y * other.x + this.z * other.w;
        this.update(nw, nx, ny, nz);
    }

    public void incrScale(double scaler) {
        this.w *= scaler;
        this.x *= scaler;
        this.y *= scaler;
        this.z *= scaler;
    }

    public void incrUnit() {
        this.incrScale(1.0 / this.magnitude());
    }

    public void incrReciprocal() {
        double m = this.magnitude();
        this.incrConjugate();
        this.incrScale(1.0 / (m * m));
    }

    public void applyRotation(aoj p) {
        Quaternion point = new Quaternion(0.0, p);
        Quaternion trans = this.multiply(point).multiply(this.conjugate());
        p.c = trans.x;
        p.d = trans.y;
        p.e = trans.z;
    }

    public double distance(Quaternion other) {
        return this.add(other).magnitude();
    }

    public Quaternion conjugate() {
        Quaternion ret = new Quaternion(this);
        ret.incrConjugate();
        return ret;
    }

    public Quaternion add(Quaternion other) {
        Quaternion ret = new Quaternion(this);
        ret.incrAdd(other);
        return ret;
    }

    public Quaternion add(Quaternion other, double scale) {
        Quaternion ret = new Quaternion(this);
        ret.incrAdd(other, scale);
        return ret;
    }

    public Quaternion multiply(Quaternion other) {
        Quaternion a = new Quaternion(this);
        a.incrMultiply(other);
        return a;
    }

    public Quaternion scale(double scaler) {
        Quaternion a = new Quaternion(this);
        a.incrScale(scaler);
        return a;
    }

    public Quaternion unit() {
        Quaternion r = new Quaternion(this);
        r.incrUnit();
        return r;
    }

    public Quaternion reciprocal() {
        Quaternion r = new Quaternion(this);
        r.incrReciprocal();
        return r;
    }
}

