/*
 * Decompiled with CFR 0.152.
 */
package factorization.api;

import factorization.api.VectorUV;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class MatrixTransform {
    float[][] M = new float[4][4];
    static float[][] multiplyTemp = new float[4][4];
    public static VectorUV tempApply = new VectorUV(0.0f, 0.0f, 0.0f);
    static MatrixTransform transTemp = new MatrixTransform();

    public MatrixTransform() {
        this.reset();
    }

    public MatrixTransform(float[][] matrix) {
        this.M = matrix;
    }

    public void reset() {
        for (float[] f : this.M) {
            Arrays.fill(f, 0.0f);
        }
        for (int i = 0; i < 4; ++i) {
            this.M[i][i] = 1.0f;
        }
    }

    public void multiply(MatrixTransform other) {
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 4; ++col) {
                float cellSum = 0.0f;
                for (int n = 0; n < 4; ++n) {
                    cellSum += this.M[row][n] * other.M[n][col];
                }
                MatrixTransform.multiplyTemp[row][col] = cellSum;
            }
        }
        float[][] swap = this.M;
        this.M = multiplyTemp;
        multiplyTemp = swap;
    }

    public VectorUV apply(VectorUV orig) {
        tempApply = new VectorUV(0.0f, 0.0f, 0.0f, orig.u, orig.v);
        int row = 0;
        MatrixTransform.tempApply.x = this.M[row][0] * orig.x + this.M[row][1] * orig.y + this.M[row][2] * orig.z + this.M[row][3];
        row = 1;
        MatrixTransform.tempApply.y = this.M[row][0] * orig.x + this.M[row][1] * orig.y + this.M[row][2] * orig.z + this.M[row][3];
        row = 2;
        MatrixTransform.tempApply.z = this.M[row][0] * orig.x + this.M[row][1] * orig.y + this.M[row][2] * orig.z + this.M[row][3];
        return tempApply;
    }

    public void applyRotationOnly(VectorUV orig) {
        tempApply = new VectorUV(0.0f, 0.0f, 0.0f, orig.u, orig.v);
        int row = 0;
        MatrixTransform.tempApply.x = this.M[row][0] * orig.x + this.M[row][1] * orig.y + this.M[row][2] * orig.z;
        row = 1;
        MatrixTransform.tempApply.y = this.M[row][0] * orig.x + this.M[row][1] * orig.y + this.M[row][2] * orig.z;
        row = 2;
        MatrixTransform.tempApply.z = this.M[row][0] * orig.x + this.M[row][1] * orig.y + this.M[row][2] * orig.z;
    }

    public void rotate(float x, float y2, float z, float theta) {
        float c = (float)Math.cos(theta);
        float s2 = (float)Math.sin(theta);
        float t = 1.0f - c;
        float[][] R = MatrixTransform.transTemp.M;
        R[0][0] = t * x * x + c;
        R[1][0] = t * x * y2 - s2 * z;
        R[2][0] = t * x * z + s2 * y2;
        R[0][1] = t * x * y2 + s2 * z;
        R[1][1] = t * y2 * y2 + c;
        R[2][1] = t * y2 * z - s2 * x;
        R[0][2] = t * x * z - s2 * y2;
        R[1][2] = t * y2 * z + s2 * x;
        R[2][2] = t * z * z + c;
        R[3][3] = 1.0f;
        for (int i = 0; i < 3; ++i) {
            R[3][i] = 0.0f;
            R[i][3] = 0.0f;
        }
        this.multiply(transTemp);
    }

    public void translate(float x, float y2, float z) {
        transTemp.reset();
        MatrixTransform.transTemp.M[0][3] = x;
        MatrixTransform.transTemp.M[1][3] = y2;
        MatrixTransform.transTemp.M[2][3] = z;
        this.multiply(transTemp);
    }

    private byte[] toByteArray() {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(outStream);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                try {
                    out.writeFloat(this.M[i][j]);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        return outStream.toByteArray();
    }

    private static MatrixTransform fromByteArray(byte[] inputByte) {
        MatrixTransform ret = new MatrixTransform();
        if (inputByte == null || inputByte.length == 0) {
            return ret;
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(inputByte);
        DataInputStream in2 = new DataInputStream(inStream);
        block2: for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                try {
                    ret.M[i][j] = in2.readFloat();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue block2;
                }
            }
        }
        return ret;
    }

    public static MatrixTransform fromDataInput(DataInput input) throws IOException {
        MatrixTransform ret = new MatrixTransform();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                ret.M[i][j] = input.readFloat();
            }
        }
        return ret;
    }

    public void addToList(ArrayList list) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                list.add(Float.valueOf(this.M[i][j]));
            }
        }
    }

    public void writeToTag(bq tag, String name2) {
        tag.a(name2, this.toByteArray());
    }

    public static MatrixTransform readFromTag(bq tag, String name2) {
        return MatrixTransform.fromByteArray(tag.j(name2));
    }

    public boolean equals(MatrixTransform other) {
        return Arrays.equals((Object[])this.M, (Object[])other.M);
    }

    public MatrixTransform copy() {
        float[][] m = new float[4][];
        for (int i = 0; i < 4; ++i) {
            m[i] = (float[])this.M[i].clone();
        }
        return new MatrixTransform(m);
    }

    public String toString() {
        String ret = "\n";
        float[][] arr$ = this.M;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            float[] F;
            for (float f : F = arr$[i$]) {
                ret = ret + f + " ";
            }
            ret = ret + "\n";
        }
        return ret;
    }
}

