/*
 * Decompiled with CFR 0.152.
 */
package factorization.api;

import factorization.api.ExoArmorRestriction;
import factorization.api.ExoStateShader;
import factorization.common.Core;

public enum ExoStateType {
    NEVER,
    BUTTON1(1),
    BUTTON2(2),
    BUTTON3(3),
    HURT(ExoArmorRestriction.HEAD),
    WOUNDED(ExoArmorRestriction.HEAD),
    MOVING(ExoArmorRestriction.CHEST),
    ONFIRE(ExoArmorRestriction.CHEST),
    SNEAKING(ExoArmorRestriction.PANTS),
    RIDING(ExoArmorRestriction.PANTS),
    SPRINTING(ExoArmorRestriction.FEET),
    ONGROUND(ExoArmorRestriction.FEET),
    INWATER(ExoArmorRestriction.FEET);

    public final ExoArmorRestriction armorRestriction;
    public final int key;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private ExoStateType() {
        this.armorRestriction = ExoArmorRestriction.NONE;
        this.key = 0;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private ExoStateType() {
        void key;
        this.armorRestriction = ExoArmorRestriction.NONE;
        this.key = key;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private ExoStateType() {
        void ar;
        this.armorRestriction = ar;
        this.key = 0;
    }

    public String when(ExoStateShader shader) {
        return "exo." + (Object)((Object)this) + "." + (Object)((Object)shader);
    }

    private static void en(String local, String en) {
        Core.proxy.addName(local, en);
    }

    public String brief() {
        if (this.key > 0) {
            return Core.proxy.getExoKeyBrief(this.key);
        }
        return this.name();
    }

    static {
        ExoStateType.en(NEVER.when(ExoStateShader.NORMAL), "Never");
        ExoStateType.en(NEVER.when(ExoStateShader.INVERSE), "Always");
        ExoStateType.en(NEVER.when(ExoStateShader.RISINGEDGE), "Never (rising edge)");
        for (ExoStateType button : new ExoStateType[]{BUTTON1, BUTTON2, BUTTON3}) {
            ExoStateType.en(button.when(ExoStateShader.NORMAL), "While %s is held");
            ExoStateType.en(button.when(ExoStateShader.INVERSE), "While %s is not held");
            ExoStateType.en(button.when(ExoStateShader.RISINGEDGE), "When %s is tapped");
        }
        ExoStateType.en(HURT.when(ExoStateShader.NORMAL), "While being hurt");
        ExoStateType.en(HURT.when(ExoStateShader.INVERSE), "While not being hurt");
        ExoStateType.en(HURT.when(ExoStateShader.RISINGEDGE), "When first hurt");
        ExoStateType.en(WOUNDED.when(ExoStateShader.NORMAL), "While injurred");
        ExoStateType.en(WOUNDED.when(ExoStateShader.INVERSE), "While healthy");
        ExoStateType.en(WOUNDED.when(ExoStateShader.RISINGEDGE), "When first injurred");
        ExoStateType.en(MOVING.when(ExoStateShader.NORMAL), "While moving");
        ExoStateType.en(MOVING.when(ExoStateShader.INVERSE), "While still");
        ExoStateType.en(MOVING.when(ExoStateShader.RISINGEDGE), "When starting to move");
        ExoStateType.en(ONFIRE.when(ExoStateShader.NORMAL), "While on fire");
        ExoStateType.en(ONFIRE.when(ExoStateShader.INVERSE), "While not on fire");
        ExoStateType.en(ONFIRE.when(ExoStateShader.RISINGEDGE), "When lit on fire");
        ExoStateType.en(SNEAKING.when(ExoStateShader.NORMAL), "While sneaking");
        ExoStateType.en(SNEAKING.when(ExoStateShader.INVERSE), "While not sneaking");
        ExoStateType.en(SNEAKING.when(ExoStateShader.RISINGEDGE), "When starting to sneak");
        ExoStateType.en(RIDING.when(ExoStateShader.NORMAL), "While riding");
        ExoStateType.en(RIDING.when(ExoStateShader.INVERSE), "While not riding");
        ExoStateType.en(RIDING.when(ExoStateShader.RISINGEDGE), "When mounting");
        ExoStateType.en(SPRINTING.when(ExoStateShader.NORMAL), "While running");
        ExoStateType.en(SPRINTING.when(ExoStateShader.INVERSE), "While not running");
        ExoStateType.en(SPRINTING.when(ExoStateShader.RISINGEDGE), "When starting to run");
        ExoStateType.en(ONGROUND.when(ExoStateShader.NORMAL), "While on the ground");
        ExoStateType.en(ONGROUND.when(ExoStateShader.INVERSE), "While not on the ground");
        ExoStateType.en(ONGROUND.when(ExoStateShader.RISINGEDGE), "When first touching the ground");
        ExoStateType.en(INWATER.when(ExoStateShader.NORMAL), "While in water");
        ExoStateType.en(INWATER.when(ExoStateShader.INVERSE), "While not in water");
        ExoStateType.en(INWATER.when(ExoStateShader.RISINGEDGE), "When entering water");
    }
}

