/*
 * Decompiled with CFR 0.152.
 */
package factorization.api;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import factorization.api.DeltaCoord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraftforge.common.ForgeDirection;

public class Coord {
    public yc w;
    public int x;
    public int y;
    public int z;
    private static Random rand = new Random();
    private static ThreadLocal staticCoord = new ThreadLocal();

    public Coord(yc w2, int x, int y2, int z) {
        this.w = w2;
        this.x = x;
        this.y = y2;
        this.z = z;
    }

    public Coord(any te) {
        this(te.k, te.l, te.m, te.n);
    }

    public Coord(lq ent) {
        this(ent.p, ent.t, ent.u + (double)ent.M, ent.v);
    }

    public Coord(yc w2, double x, double y2, double z) {
        this(w2, (int)x, (int)y2, (int)z);
    }

    public static Coord of(int x, int y2, int z) {
        return Coord.of(null, x, y2, z);
    }

    public static Coord of(double x, double y2, double z) {
        return Coord.of(null, (int)x, (int)y2, (int)z);
    }

    public static Coord of(yc w2, int x, int y2, int z) {
        Coord ret = (Coord)staticCoord.get();
        if (ret == null) {
            ret = new Coord(w2, x, y2, z);
            staticCoord.set(ret);
            return ret;
        }
        ret.set(w2, x, y2, z);
        return ret;
    }

    public String toString() {
        String ret = "(" + this.x + ", " + this.y + ", " + this.z + ")";
        if (!this.blockExists()) {
            ret = ret + " not loaded";
        } else if (this.w != null) {
            ret = ret + " a " + this.getBlock();
            any te = this.getTE();
            if (te != null) {
                ret = ret + " with TE " + te;
            }
        }
        return ret;
    }

    public void set(yc w2, int x, int y2, int z) {
        this.w = w2;
        this.x = x;
        this.y = y2;
        this.z = z;
    }

    public void set(s cc) {
        this.set(this.w, cc.a, cc.b, cc.c);
    }

    public void set(Coord c) {
        this.set(c.w, c.x, c.y, c.z);
    }

    public void set(aoj v) {
        this.set(this.w, (int)v.c, (int)v.d, (int)v.e);
    }

    public int hashCode() {
        return (this.x * 11 % 71 << 7) + this.z * 7 % 479 + this.y;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Coord) {
            Coord other = (Coord)obj;
            return this.x == other.x && this.y == other.y && this.z == other.z && this.w == other.w;
        }
        return false;
    }

    public Coord copy() {
        return new Coord(this.w, this.x, this.y, this.z);
    }

    public int get(int axis) {
        switch (axis) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new RuntimeException("Invalid argument");
    }

    public void set(int axis, int value) {
        switch (axis) {
            case 0: {
                this.x = value;
                return;
            }
            case 1: {
                this.y = value;
                return;
            }
            case 2: {
                this.z = value;
                return;
            }
        }
        throw new RuntimeException("Invalid argument");
    }

    public aoj createVector() {
        return aoj.a((double)this.x, (double)this.y, (double)this.z);
    }

    public boolean parity() {
        return (this.x + this.y + this.z & 1) == 0;
    }

    public int seed() {
        return (this.x << 4 + this.z << 8) + this.y;
    }

    public DeltaCoord difference(Coord b) {
        return new DeltaCoord(this.x - b.x, this.y - b.y, this.z - b.z);
    }

    public double distance(Coord o) {
        return Math.sqrt(this.distanceSq(o));
    }

    public int distanceSq(Coord o) {
        if (o == null) {
            return 0;
        }
        int dx = this.x - o.x;
        int dy = this.y - o.y;
        int dz = this.z - o.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public int distanceManhatten(Coord o) {
        if (o == null) {
            return 0;
        }
        int dx = this.x - o.x;
        int dy = this.y - o.y;
        int dz = this.z - o.z;
        return Math.abs(dx) + Math.abs(dy) + Math.abs(dz);
    }

    public ArrayList getNeighborsAdjacent() {
        ArrayList<Coord> ret = new ArrayList<Coord>(6);
        for (DeltaCoord d : DeltaCoord.directNeighbors) {
            ret.add(this.add(d));
        }
        return ret;
    }

    public Iterable getAdjacentTEs(Class clazz) {
        ArrayList<Object> ret = new ArrayList<Object>(6);
        for (Coord n : this.getNeighborsAdjacent()) {
            Object toAdd = n.getTE(clazz);
            if (toAdd == null) continue;
            ret.add(toAdd);
        }
        return ret;
    }

    public ArrayList getNeighborsDiagonal() {
        ArrayList<Coord> ret = new ArrayList<Coord>(26);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    ret.add(this.add(dx, dy, dz));
                }
            }
        }
        return ret;
    }

    public ArrayList getRandomNeighborsAdjacent() {
        ArrayList ret = this.getNeighborsAdjacent();
        Collections.shuffle(ret);
        return ret;
    }

    public ArrayList getRandomNeighborsDiagonal() {
        ArrayList ret = this.getNeighborsDiagonal();
        Collections.shuffle(ret);
        return ret;
    }

    public Coord getSingleRandomNeighborAdjacent() {
        int r = rand.nextInt(DeltaCoord.directNeighbors.length);
        return this.add(DeltaCoord.directNeighbors[r]);
    }

    public Coord[] getNeighborsInPlane(int side) {
        switch (side) {
            case 0: 
            case 1: {
                return new Coord[]{this.add(-1, 0, 0), this.add(1, 0, 0), this.add(0, 0, -1), this.add(0, 0, 1)};
            }
            case 2: 
            case 3: {
                return new Coord[]{this.add(-1, 0, 0), this.add(1, 0, 0), this.add(0, -1, 0), this.add(0, 1, 0)};
            }
            case 4: 
            case 5: {
                return new Coord[]{this.add(0, 0, -1), this.add(0, 0, 1), this.add(0, -1, 0), this.add(0, 1, 0)};
            }
        }
        return null;
    }

    public Coord[] getNeighborsOutOfPlane(int side) {
        switch (side) {
            case 0: 
            case 1: {
                return new Coord[]{this.add(0, -1, 0), this.add(0, 1, 0)};
            }
            case 2: 
            case 3: {
                return new Coord[]{this.add(0, 0, -1), this.add(0, 0, 1)};
            }
            case 4: 
            case 5: {
                return new Coord[]{this.add(-1, 0, 0), this.add(1, 0, 0)};
            }
        }
        return null;
    }

    public boolean isSubmissiveTo(Coord o) {
        return this.y < o.y || this.x < o.x || this.z < o.z;
    }

    public boolean isCompletelySubmissiveTo(Coord o) {
        return this.x < o.x && this.y < o.y && this.z < o.z;
    }

    public boolean inside(Coord lower, Coord upper) {
        return lower.lesserOrEqual(this) && this.lesserOrEqual(upper);
    }

    public boolean lesserOrEqual(Coord o) {
        return this.x <= o.x && this.y <= o.y && this.z <= o.z;
    }

    public void setWorld(yc newWorld) {
        this.w = newWorld;
    }

    public Coord add(DeltaCoord d) {
        return this.add(d.x, d.y, d.z);
    }

    public Coord add(ForgeDirection d) {
        return this.add(d.offsetX, d.offsetY, d.offsetZ);
    }

    public Coord add(int x, int y2, int z) {
        return new Coord(this.w, this.x + x, this.y + y2, this.z + z);
    }

    public Coord center(Coord o) {
        return new Coord(this.w, (this.x + o.x) / 2, (this.y + o.y) / 2, (this.z + o.z) / 2);
    }

    public aoj centerVec(Coord o) {
        return aoj.a((double)((double)(this.x + o.x) / 2.0), (double)((double)(this.y + o.y) / 2.0), (double)((double)(this.z + o.z) / 2.0));
    }

    public Coord towardSide(int side) {
        switch (side) {
            case 0: {
                --this.y;
                break;
            }
            case 1: {
                ++this.y;
                break;
            }
            case 2: {
                --this.z;
                break;
            }
            case 3: {
                ++this.z;
                break;
            }
            case 4: {
                --this.x;
                break;
            }
            case 5: {
                ++this.x;
            }
        }
        return this;
    }

    public void adjust(DeltaCoord dc) {
        this.x += dc.x;
        this.y += dc.y;
        this.z += dc.z;
    }

    public void markBlockForUpdate() {
        this.w.i(this.x, this.y, this.z);
    }

    public void redraw() {
        this.w.o(this.x, this.y, this.z);
    }

    public void notifyNeighbors() {
        this.w.h(this.x, this.y, this.z, this.getId());
    }

    public void updateLight() {
        this.w.z(this.x, this.y, this.z);
    }

    public void setTE(any te) {
        this.w.a(this.x, this.y, this.z, te);
    }

    public any getTE() {
        if (this.w == null) {
            return null;
        }
        return this.w.q(this.x, this.y, this.z);
    }

    public Object getTE(Class clazz) {
        any te = this.getTE();
        if (clazz.isInstance(te)) {
            return te;
        }
        return null;
    }

    public void rmTE() {
        this.w.r(this.x, this.y, this.z);
    }

    public zz getChunk() {
        return this.w.d(this.x, this.z);
    }

    public amq getBlock() {
        return amq.p[this.getId()];
    }

    public int getId() {
        return this.w.a(this.x, this.y, this.z);
    }

    public int getMd() {
        return this.w.h(this.x, this.y, this.z);
    }

    public boolean isAir() {
        return this.w.c(this.x, this.y, this.z);
    }

    public boolean isSolid() {
        amq b = this.getBlock();
        if (b == null) {
            return false;
        }
        return b.isBlockNormalCube(this.w, this.x, this.y, this.z);
    }

    public float getHardness() {
        amq b = this.getBlock();
        if (b == null) {
            return 0.0f;
        }
        return b.m(this.w, this.x, this.y, this.z);
    }

    @Deprecated
    public boolean isSolidOnSide(int side) {
        return this.w.isBlockSolidOnSide(this.x, this.y, this.z, ForgeDirection.getOrientation((int)side));
    }

    public boolean isSolidOnSide(ForgeDirection side) {
        return this.w.isBlockSolidOnSide(this.x, this.y, this.z, side);
    }

    public boolean isBlockBurning() {
        amq b = this.getBlock();
        if (b == null) {
            return false;
        }
        return b == amq.au || b.isBlockBurning(this.w, this.x, this.y, this.z);
    }

    public boolean blockExists() {
        return this.w.f(this.x, this.y, this.z);
    }

    public boolean isReplacable() {
        amq b = this.getBlock();
        if (b == null) {
            return true;
        }
        if (b.cB.j()) {
            return true;
        }
        return b.isBlockReplaceable(this.w, this.x, this.y, this.z);
    }

    public boolean isTop() {
        return this.w.f(this.x, this.z) == this.y;
    }

    public boolean canBeSeenThrough() {
        if (this.w.c(this.x, this.y, this.z)) {
            return true;
        }
        return amq.r[this.getId()] == 0;
    }

    public boolean canSeeSky() {
        Coord skyLook = this.copy();
        int i = this.y + 1;
        while (i < this.w.O()) {
            skyLook.y = i++;
            if (skyLook.canBeSeenThrough()) continue;
            return false;
        }
        return true;
    }

    public boolean is(amq b) {
        return this.getId() == b.cm;
    }

    public boolean is(amq b, int md2) {
        return this.getId() == b.cm && this.getMd() == md2;
    }

    public boolean setId(int id, boolean notify) {
        if (notify) {
            return this.w.e(this.x, this.y, this.z, id);
        }
        return this.w.b(this.x, this.y, this.z, id);
    }

    public boolean setMd(int md2, boolean notify) {
        if (notify) {
            this.w.c(this.x, this.y, this.z, md2);
            return true;
        }
        return this.w.d(this.x, this.y, this.z, md2);
    }

    public boolean setIdMd(int id, int md2, boolean notify) {
        if (notify) {
            return this.w.d(this.x, this.y, this.z, id, md2);
        }
        return this.w.c(this.x, this.y, this.z, id, md2);
    }

    public boolean setId(int id) {
        return this.setId(id, true);
    }

    public boolean setMd(int md2) {
        return this.setMd(md2, true);
    }

    public boolean setIdMd(int id, int md2) {
        return this.setIdMd(id, md2, true);
    }

    public boolean setId(amq block2) {
        return this.setId(block2.cm);
    }

    public void notifyBlockChange() {
        this.w.f(this.x, this.y, this.z, this.getId());
    }

    public void writeToNBT(String prefix, bq tag) {
        tag.a(prefix + "x", this.x);
        tag.a(prefix + "y", this.y);
        tag.a(prefix + "z", this.z);
    }

    public void readFromNBT(String prefix, bq tag) {
        this.x = tag.e(prefix + "x");
        this.y = tag.e(prefix + "y");
        this.z = tag.e(prefix + "z");
    }

    public void writeToStream(ByteArrayDataOutput dos) {
        dos.writeInt(this.x);
        dos.writeInt(this.y);
        dos.writeInt(this.z);
    }

    public void readFromStream(ByteArrayDataInput dis) {
        this.x = dis.readInt();
        this.y = dis.readInt();
        this.z = dis.readInt();
    }

    public void mark() {
        yc use_world = this.w;
        use_world.a("reddust", (double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, 0.0, 0.0, 0.0);
    }

    public boolean remote() {
        return this.w.I;
    }

    public boolean local() {
        return !this.w.I;
    }

    public void spawnItem(ur is) {
        this.w.d((lq)new px(this.w, (double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, is));
    }

    public aoe getCollisionBoundingBoxFromPool() {
        amq b = this.getBlock();
        if (b == null) {
            return null;
        }
        return b.e(this.w, this.x, this.y, this.z);
    }

    public void notifyOfNeighborChange(int neighborId) {
        this.w.h(this.x, this.y, this.z, neighborId);
    }

    public void scheduleUpdate(int delay) {
        this.w.a(this.x, this.y, this.z, this.getId(), delay);
    }

    public void setAsEntityLocation(lq ent) {
        ent.t = (double)this.x + 0.5;
        ent.u = this.y;
        ent.v = (double)this.z + 0.5;
    }

    public void setAsTileEntityLocation(any te) {
        te.k = this.w;
        te.l = this.x;
        te.m = this.y;
        te.n = this.z;
    }

    public void setAsVector(aoj vec) {
        vec.c = this.x;
        vec.d = this.y;
        vec.e = this.z;
    }

    public static void sort(Coord lower, Coord upper) {
        Coord a = lower.copy();
        Coord b = upper.copy();
        lower.x = Math.min(a.x, b.x);
        lower.y = Math.min(a.y, b.y);
        lower.z = Math.min(a.z, b.z);
        upper.x = Math.max(a.x, b.x);
        upper.y = Math.max(a.y, b.y);
        upper.z = Math.max(a.z, b.z);
    }

    public void moveToTopBlock() {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                this.y = Math.max(this.y, this.w.i(this.x + dx, this.z + dz));
            }
        }
    }

    public void removeTE() {
        this.w.r(this.x, this.y, this.z);
    }

    public boolean isPowered() {
        return this.w.A(this.x, this.y, this.z);
    }
}

