/*
 * Decompiled with CFR 0.152.
 */
package factorization.api;

import factorization.api.ConductorSet;
import factorization.api.Coord;
import factorization.api.IChargeConductor;

public class Charge {
    ConductorSet conductorSet = null;
    IChargeConductor conductor = null;
    boolean isConductorSetLeader = false;
    boolean justCreated = true;

    public Charge(IChargeConductor conductor) {
        this.conductor = conductor;
    }

    public int getValue() {
        if (this.conductorSet == null || this.conductorSet.memberCount == 0) {
            return 0;
        }
        int chargeShare = this.conductorSet.totalCharge / this.conductorSet.memberCount;
        if (this.isConductorSetLeader) {
            chargeShare += this.conductorSet.totalCharge % this.conductorSet.memberCount;
        }
        return chargeShare;
    }

    public void setValue(int newCharge) {
        this.createOrJoinConductorSet();
        this.conductorSet.totalCharge += newCharge - this.getValue();
    }

    public int addValue(int chargeToAdd) {
        this.createOrJoinConductorSet();
        return this.conductorSet.totalCharge += chargeToAdd;
    }

    public int deplete() {
        int ret = this.getValue();
        this.setValue(0);
        return ret;
    }

    public int deplete(int toTake) {
        int c = this.getValue();
        toTake = Math.min(toTake, c);
        this.setValue(c - toTake);
        return toTake;
    }

    public int tryTake(int toTake) {
        int c = this.getValue();
        if (c < toTake) {
            return 0;
        }
        this.setValue(c - toTake);
        return toTake;
    }

    public void writeToNBT(bq tag, String name2) {
        tag.a(name2, this.getValue());
    }

    public void writeToNBT(bq tag) {
        this.writeToNBT(tag, "charge");
    }

    public void readFromNBT(bq tag, String name2) {
        this.setValue(tag.e(name2));
    }

    public void readFromNBT(bq tag) {
        this.readFromNBT(tag, "charge");
    }

    void createOrJoinConductorSet() {
        if (this.conductorSet != null) {
            return;
        }
        Coord here = this.conductor.getCoord();
        if (here.w == null) {
            new ConductorSet(this.conductor);
            return;
        }
        Iterable neighbors = this.conductor.getCoord().getAdjacentTEs(IChargeConductor.class);
        for (IChargeConductor neighbor : neighbors) {
            Charge n = neighbor.getCharge();
            if (n.conductorSet == null || !n.conductorSet.addConductor(this.conductor)) continue;
            for (IChargeConductor otherNeighbor : neighbors) {
                this.conductorSet.addNeighbor(otherNeighbor.getCharge().conductorSet);
            }
            return;
        }
        new ConductorSet(this.conductor);
    }

    public void update() {
        Coord here = this.conductor.getCoord();
        if (here.w.I) {
            return;
        }
        this.createOrJoinConductorSet();
        if (this.isConductorSetLeader) {
            this.conductorSet.update();
        }
        if (this.justCreated || (here.w.G() + (long)here.seed()) % 600L == 0L) {
            this.justCreated = false;
            if (this.conductorSet.leader == null) {
                this.conductorSet.leader = this.conductor;
            }
            for (IChargeConductor neighbor : here.getAdjacentTEs(IChargeConductor.class)) {
                this.justCreated |= this.conductorSet.addNeighbor(neighbor.getCharge().conductorSet);
            }
        }
    }

    public void remove() {
        if (this.conductorSet == null) {
            return;
        }
        for (IChargeConductor hereConductor : this.conductorSet.getMembers(this.conductor)) {
            Charge hereCharge = hereConductor.getCharge();
            int saveCharge = hereCharge.getValue();
            new ConductorSet(hereCharge.conductor);
            hereCharge.setValue(saveCharge);
        }
    }

    public static ChargeDensityReading getChargeDensity(IChargeConductor start) {
        ConductorSet cs = start.getCharge().conductorSet;
        if (cs == null) {
            return new ChargeDensityReading();
        }
        ChargeDensityReading ret = new ChargeDensityReading();
        ret.totalCharge = cs.totalCharge;
        ret.conductorCount = cs.memberCount;
        return ret;
    }

    public void invalidate() {
        if (this.conductorSet == null) {
            return;
        }
        this.remove();
    }

    public static class ChargeDensityReading {
        public int totalCharge;
        public int conductorCount;
    }
}

