/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader;

import codechicken.chunkloader.TileChunkLoader;
import codechicken.chunkloader.TileChunkLoaderBase;
import codechicken.chunkloader.TileSpotLoader;
import codechicken.core.ClientUtils;
import codechicken.core.render.CCRenderState;
import codechicken.core.vec.Quat;
import codechicken.core.vec.Vector3;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import org.lwjgl.opengl.GL11;

public class TileChunkLoaderRenderer
extends bdx {
    public static final double phi = 1.618034;

    public void a(any tile, double d, double d1, double d2, float f) {
        double size;
        double height;
        CCRenderState.reset();
        CCRenderState.setBrightness((ym)tile.k, (int)tile.l, (int)tile.m, (int)tile.n);
        double rot = ClientUtils.getRenderTime() * 2.0;
        double updown = ClientUtils.getRenderTime() % 50.0 / 25.0;
        updown = (float)Math.sin(updown * 3.141593);
        updown *= 0.2;
        TileChunkLoaderBase chunkLoader = (TileChunkLoaderBase)tile;
        if (chunkLoader instanceof TileChunkLoader) {
            TileChunkLoader ctile = (TileChunkLoader)chunkLoader;
            rot /= Math.pow(ctile.radius, 0.2);
            height = 0.9;
            size = 0.08;
        } else if (chunkLoader instanceof TileSpotLoader) {
            height = 0.5;
            size = 0.05;
        } else {
            return;
        }
        RenderInfo renderInfo = chunkLoader.renderInfo;
        double active = (double)renderInfo.activationCounter / 20.0;
        if (chunkLoader.active && renderInfo.activationCounter < 20) {
            active += (double)f / 20.0;
        } else if (!chunkLoader.active && renderInfo.activationCounter > 0) {
            active -= (double)f / 20.0;
        }
        if (renderInfo.showLasers) {
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2912);
            this.drawRays(d, d1, d2, rot, updown, tile.l, tile.m, tile.n, chunkLoader.getChunks());
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2912);
        }
        rot = ClientUtils.getRenderTime() * active / 3.0;
        Quat pearlrot = Quat.aroundAxis((double)0.0, (double)0.0, (double)1.0, (double)Math.atan(0.618033984452737)).multiply(Quat.aroundAxis((double)0.0, (double)1.0, (double)0.0, (double)rot));
        this.renderIcosahedron(new Vector3(d, d1, d2), 1.0f, new Vector3(0.5, height + (updown + 0.3) * active, 0.5), pearlrot, size, 0);
    }

    public Point2D.Double findIntersection(Line2D line1, Line2D line2) {
        double xD1 = line1.getX2() - line1.getX1();
        double yD1 = line1.getY2() - line1.getY1();
        double xD2 = line2.getX2() - line2.getX1();
        double yD2 = line2.getY2() - line2.getY1();
        double xD3 = line1.getX1() - line2.getX1();
        double yD3 = line1.getY1() - line2.getY1();
        Point2D.Double pt = new Point2D.Double(0.0, 0.0);
        double div = yD2 * xD1 - xD2 * yD1;
        if (div == 0.0) {
            return null;
        }
        double ua = (xD2 * yD3 - yD2 * xD3) / div;
        pt.x = line1.getX1() + ua * xD1;
        pt.y = line1.getY1() + ua * yD1;
        if (this.ptOnLineInSegment(pt, line1) && this.ptOnLineInSegment(pt, line2)) {
            return pt;
        }
        return null;
    }

    public boolean ptOnLineInSegment(Point2D point, Line2D line) {
        return point.getX() >= Math.min(line.getX1(), line.getX2()) && point.getX() <= Math.max(line.getX1(), line.getX2()) && point.getY() >= Math.min(line.getY1(), line.getY2()) && point.getY() <= Math.max(line.getY1(), line.getY2());
    }

    public void drawRays(double d, double d1, double d2, double rotationAngle, double updown, int x2, int y2, int z2, Collection chunkSet) {
        int cx = x2 >> 4 << 4;
        int cz = z2 >> 4 << 4;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(d + (double)cx - (double)x2 + 8.0), (double)(d1 + updown + 2.0), (double)(d2 + (double)cz - (double)z2 + 8.0));
        GL11.glRotatef((float)((float)rotationAngle), (float)0.0f, (float)1.0f, (float)0.0f);
        double[] distances = new double[4];
        Point2D.Double center = new Point2D.Double(cx + 8, cz + 8);
        int[][] nArrayArray = new int[4][];
        nArrayArray[0] = new int[2];
        int[] nArray = new int[2];
        nArray[0] = 16;
        nArrayArray[1] = nArray;
        nArrayArray[2] = new int[]{16, 16};
        int[] nArray2 = new int[2];
        nArray2[1] = 16;
        nArrayArray[3] = nArray2;
        int[][] coords = nArrayArray;
        Point2D.Double[] absRays = new Point2D.Double[4];
        int ray = 0;
        while (ray < 4) {
            double rayAngle = Math.toRadians(rotationAngle + (double)(90 * ray));
            absRays[ray] = new Point2D.Double(Math.sin(rayAngle), Math.cos(rayAngle));
            ++ray;
        }
        Line2D.Double[] rays = new Line2D.Double[]{new Line2D.Double(center.x, center.y, center.x + 1600.0 * absRays[0].x, center.y + 1600.0 * absRays[0].y), new Line2D.Double(center.x, center.y, center.x + 1600.0 * absRays[1].x, center.y + 1600.0 * absRays[1].y), new Line2D.Double(center.x, center.y, center.x + 1600.0 * absRays[2].x, center.y + 1600.0 * absRays[2].y), new Line2D.Double(center.x, center.y, center.x + 1600.0 * absRays[3].x, center.y + 1600.0 * absRays[3].y)};
        for (xv pair : chunkSet) {
            int chunkBlockX = pair.a << 4;
            int chunkBlockZ = pair.b << 4;
            int side = 0;
            while (side < 4) {
                int[] offset1 = coords[side];
                int[] offset2 = coords[(side + 1) % 4];
                Line2D.Double line1 = new Line2D.Double(chunkBlockX + offset1[0], chunkBlockZ + offset1[1], chunkBlockX + offset2[0], chunkBlockZ + offset2[1]);
                int ray2 = 0;
                while (ray2 < 4) {
                    Point2D.Double isct = this.findIntersection(line1, rays[ray2]);
                    if (isct != null) {
                        isct.setLocation(isct.x - center.x, isct.y - center.y);
                        double lenPow2 = isct.x * isct.x + isct.y * isct.y;
                        if (lenPow2 > distances[ray2]) {
                            distances[ray2] = lenPow2;
                        }
                    }
                    ++ray2;
                }
                ++side;
            }
        }
        GL11.glColor4d((double)0.9, (double)0.0, (double)0.0, (double)1.0);
        int ray3 = 0;
        while (ray3 < 4) {
            distances[ray3] = Math.sqrt(distances[ray3]);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            bbv.a((aoe)aoe.a((double)0.0, (double)-0.05, (double)-0.05, (double)distances[ray3], (double)0.05, (double)0.05));
            ++ray3;
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)(d + (double)cx - (double)x2 + 8.0), (double)(d1 - (double)y2), (double)(d2 + (double)cz - (double)z2 + 8.0));
        ray3 = 0;
        while (ray3 < 4) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(absRays[ray3].x * distances[ray3]), (double)0.0, (double)(absRays[ray3].y * distances[ray3]));
            bbv.a((aoe)aoe.a((double)-0.05, (double)0.0, (double)-0.05, (double)0.05, (double)256.0, (double)0.05));
            GL11.glPopMatrix();
            ++ray3;
        }
        GL11.glPopMatrix();
        double toCenter = Math.sqrt(((double)cx + 7.5 - (double)x2) * ((double)cx + 7.5 - (double)x2) + 0.6400000000000001 + ((double)cz + 7.5 - (double)z2) * ((double)cz + 7.5 - (double)z2));
        GL11.glPushMatrix();
        GL11.glColor4d((double)0.0, (double)0.9, (double)0.0, (double)1.0);
        GL11.glTranslated((double)(d + 0.5), (double)(d1 + 1.2 + updown), (double)(d2 + 0.5));
        GL11.glRotatef((float)((float)(Math.atan2((double)cx + 7.5 - (double)x2, (double)cz + 7.5 - (double)z2) * 180.0 / 3.1415) + 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)(-Math.asin(0.8 / toCenter) * 180.0 / 3.1415)), (float)0.0f, (float)0.0f, (float)1.0f);
        bbv.a((aoe)aoe.a((double)(-toCenter), (double)-0.03, (double)-0.03, (double)0.0, (double)0.03, (double)0.03));
        GL11.glPopMatrix();
    }

    public void renderIcosahedron(Vector3 tilepos, float light, Vector3 relpos, Quat rotation, double scale, int colour) {
        baz tessellator = baz.a;
        Vector3[] verts = new Vector3[]{new Vector3(-1.0, 1.618034, 0.0), new Vector3(1.0, 1.618034, 0.0), new Vector3(1.0, -1.618034, 0.0), new Vector3(-1.0, -1.618034, 0.0), new Vector3(0.0, -1.0, 1.618034), new Vector3(0.0, 1.0, 1.618034), new Vector3(0.0, 1.0, -1.618034), new Vector3(0.0, -1.0, -1.618034), new Vector3(1.618034, 0.0, -1.0), new Vector3(1.618034, 0.0, 1.0), new Vector3(-1.618034, 0.0, 1.0), new Vector3(-1.618034, 0.0, -1.0)};
        int i = 0;
        while (i < 12) {
            verts[i].multiply(scale);
            rotation.rotate(verts[i]);
            verts[i].add(relpos);
            verts[i].add(tilepos);
            ++i;
        }
        tessellator.b();
        this.a("/codechicken/chunkloader/hedronmap.png");
        tessellator.a(light, light, light);
        TileChunkLoaderRenderer.drawTriangle(verts[1], 0.5f, 0.0f, verts[0], 0.0f, 0.25f, verts[5], 1.0f, 0.25f);
        TileChunkLoaderRenderer.drawTriangle(verts[1], 0.5f, 0.0f, verts[5], 0.0f, 0.25f, verts[9], 1.0f, 0.25f);
        TileChunkLoaderRenderer.drawTriangle(verts[1], 0.5f, 0.0f, verts[9], 0.0f, 0.25f, verts[8], 1.0f, 0.25f);
        TileChunkLoaderRenderer.drawTriangle(verts[1], 0.5f, 0.0f, verts[8], 0.0f, 0.25f, verts[6], 1.0f, 0.25f);
        TileChunkLoaderRenderer.drawTriangle(verts[1], 0.5f, 0.0f, verts[6], 0.0f, 0.25f, verts[0], 1.0f, 0.25f);
        TileChunkLoaderRenderer.drawTriangle(verts[0], 0.5f, 0.25f, verts[11], 0.0f, 0.75f, verts[10], 1.0f, 0.75f);
        TileChunkLoaderRenderer.drawTriangle(verts[5], 0.5f, 0.25f, verts[10], 0.0f, 0.75f, verts[4], 1.0f, 0.75f);
        TileChunkLoaderRenderer.drawTriangle(verts[9], 0.5f, 0.25f, verts[4], 0.0f, 0.75f, verts[2], 1.0f, 0.75f);
        TileChunkLoaderRenderer.drawTriangle(verts[8], 0.5f, 0.25f, verts[2], 0.0f, 0.75f, verts[7], 1.0f, 0.75f);
        TileChunkLoaderRenderer.drawTriangle(verts[6], 0.5f, 0.25f, verts[7], 0.0f, 0.75f, verts[11], 1.0f, 0.75f);
        TileChunkLoaderRenderer.drawTriangle(verts[2], 0.5f, 0.75f, verts[8], 0.0f, 0.25f, verts[9], 1.0f, 0.25f);
        TileChunkLoaderRenderer.drawTriangle(verts[7], 0.5f, 0.75f, verts[6], 0.0f, 0.25f, verts[8], 1.0f, 0.25f);
        TileChunkLoaderRenderer.drawTriangle(verts[11], 0.5f, 0.75f, verts[0], 0.0f, 0.25f, verts[6], 1.0f, 0.25f);
        TileChunkLoaderRenderer.drawTriangle(verts[10], 0.5f, 0.75f, verts[5], 0.0f, 0.25f, verts[0], 1.0f, 0.25f);
        TileChunkLoaderRenderer.drawTriangle(verts[4], 0.5f, 0.75f, verts[9], 0.0f, 0.25f, verts[5], 1.0f, 0.25f);
        TileChunkLoaderRenderer.drawTriangle(verts[3], 0.5f, 1.0f, verts[2], 0.0f, 0.75f, verts[4], 1.0f, 0.75f);
        TileChunkLoaderRenderer.drawTriangle(verts[3], 0.5f, 1.0f, verts[7], 0.0f, 0.75f, verts[2], 1.0f, 0.75f);
        TileChunkLoaderRenderer.drawTriangle(verts[3], 0.5f, 1.0f, verts[11], 0.0f, 0.75f, verts[7], 1.0f, 0.75f);
        TileChunkLoaderRenderer.drawTriangle(verts[3], 0.5f, 1.0f, verts[10], 0.0f, 0.75f, verts[11], 1.0f, 0.75f);
        TileChunkLoaderRenderer.drawTriangle(verts[3], 0.5f, 1.0f, verts[4], 0.0f, 0.75f, verts[10], 1.0f, 0.75f);
        tessellator.a();
    }

    public static void drawTriangle(Vector3 vec1, float texx1, float texy1, Vector3 vec2, float texx2, float texy2, Vector3 vec3, float texx3, float texy3) {
        baz.a.a(vec1.x, vec1.y, vec1.z, (double)texx1, (double)texy1);
        baz.a.a(vec2.x, vec2.y, vec2.z, (double)texx2, (double)texy2);
        baz.a.a(vec3.x, vec3.y, vec3.z, (double)texx3, (double)texy3);
        baz.a.a(vec3.x, vec3.y, vec3.z, (double)texx3, (double)texy3);
    }

    public static class RenderInfo {
        int activationCounter;
        boolean showLasers;

        public void update(TileChunkLoaderBase chunkLoader) {
            if (this.activationCounter < 20 && chunkLoader.active) {
                ++this.activationCounter;
            } else if (this.activationCounter > 0 && !chunkLoader.active) {
                --this.activationCounter;
            }
        }
    }
}

