/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader;

import codechicken.chunkloader.ChunkLoaderManager;
import codechicken.chunkloader.ChunkLoaderServerPacketHandler;
import codechicken.chunkloader.ChunkLoaderShape;
import codechicken.chunkloader.IChickenChunkLoader;
import codechicken.chunkloader.TileChunkLoaderBase;
import codechicken.core.packet.PacketCustom;
import java.util.HashSet;

public class TileChunkLoader
extends TileChunkLoaderBase
implements IChickenChunkLoader {
    public int radius;
    public ChunkLoaderShape shape;

    public static void handleDescriptionPacket(PacketCustom packet, yc world) {
        any tile = world.q(packet.readInt(), packet.readInt(), packet.readInt());
        if (tile instanceof TileChunkLoader) {
            TileChunkLoader ctile = (TileChunkLoader)tile;
            ctile.setShapeAndRadius(ChunkLoaderShape.values()[packet.readUnsignedByte()], packet.readUnsignedByte());
            ctile.active = packet.readBoolean();
            if (packet.readBoolean()) {
                ctile.owner = packet.readString();
            }
        }
    }

    public boolean setShapeAndRadius(ChunkLoaderShape newShape, int newRadius) {
        if (this.k.I) {
            this.radius = newRadius;
            this.shape = newShape;
            return true;
        }
        HashSet chunks = TileChunkLoader.getContainedChunks(newShape, this.l, this.n, newRadius);
        if (chunks.size() > ChunkLoaderManager.maxChunksPerLoader()) {
            return false;
        }
        if (this.powered) {
            this.radius = newRadius;
            this.shape = newShape;
            this.k.i(this.l, this.m, this.n);
            return true;
        }
        if (ChunkLoaderManager.canLoaderAdd(this, chunks)) {
            this.radius = newRadius;
            this.shape = newShape;
            ChunkLoaderManager.updateLoader(this);
            this.k.i(this.l, this.m, this.n);
            return true;
        }
        return false;
    }

    public ef l() {
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderServerPacketHandler.channel, 10);
        packet.setChunkDataPacket();
        packet.writeCoord(this.l, this.m, this.n);
        packet.writeByte(this.shape.ordinal());
        packet.writeByte(this.radius);
        packet.writeBoolean(this.active);
        packet.writeBoolean(this.owner != null);
        if (this.owner != null) {
            packet.writeString(this.owner);
        }
        return packet.toPacket();
    }

    @Override
    public void b(bq tag) {
        super.b(tag);
        tag.a("radius", (byte)this.radius);
        tag.a("shape", (byte)this.shape.ordinal());
    }

    @Override
    public void a(bq tag) {
        super.a(tag);
        this.radius = tag.c("radius");
        this.shape = ChunkLoaderShape.values()[tag.c("shape")];
    }

    @Override
    public HashSet getChunks() {
        return TileChunkLoader.getContainedChunks(this.shape, this.l, this.n, this.radius);
    }

    public static HashSet getContainedChunks(ChunkLoaderShape shape, int xCoord, int zCoord, int radius) {
        return shape.getLoadedChunks(xCoord >> 4, zCoord >> 4, radius - 1);
    }

    public int countLoadedChunks() {
        return this.getChunks().size();
    }

    @Override
    public void activate() {
        if (this.radius == 0) {
            this.radius = 1;
            this.shape = ChunkLoaderShape.Square;
            this.setShapeAndRadius(ChunkLoaderShape.Square, 2);
        }
        super.activate();
    }
}

