/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader;

import codechicken.chunkloader.ChunkLoaderServerPacketHandler;
import codechicken.chunkloader.PlayerChunkViewerManager;
import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import codechicken.core.packet.PacketCustom;
import codechicken.core.vec.Vector3;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;

public class PlayerChunkViewerTracker {
    private final PlayerChunkViewerManager manager;
    public final qx owner;
    private HashSet knownTickets = new HashSet();

    public PlayerChunkViewerTracker(qx player, PlayerChunkViewerManager manager) {
        this.owner = player;
        this.manager = manager;
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderServerPacketHandler.channel, 1);
        ServerUtils.sendPacketTo((qx)player, (ef)packet.toPacket());
        in[] inArray = DimensionManager.getWorlds();
        int n = inArray.length;
        int n2 = 0;
        while (n2 < n) {
            in world = inArray[n2];
            this.loadDimension(world);
            ++n2;
        }
    }

    public void writeTicketToPacket(PacketCustom packet, ForgeChunkManager.Ticket ticket, Collection chunkSet) {
        packet.writeInt(((Integer)this.manager.ticketIDs.get(ticket)).intValue());
        packet.writeString(ticket.getModId());
        String player = ticket.getPlayerName();
        packet.writeBoolean(player != null);
        if (player != null) {
            packet.writeString(player);
        }
        packet.writeByte(ticket.getType().ordinal());
        lq entity = ticket.getEntity();
        if (entity != null) {
            packet.writeInt(entity.k);
        }
        packet.writeShort(chunkSet.size());
        for (xv chunk : chunkSet) {
            packet.writeInt(chunk.a);
            packet.writeInt(chunk.b);
        }
        this.knownTickets.add((Integer)this.manager.ticketIDs.get(ticket));
    }

    public void loadDimension(in world) {
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderServerPacketHandler.channel, 2);
        int dim = CommonUtils.getDimension((yc)world);
        packet.writeInt(dim);
        List allchunks = world.b.g;
        packet.writeShort(allchunks.size());
        for (zz chunk : allchunks) {
            packet.writeInt(chunk.g);
            packet.writeInt(chunk.h);
        }
        ImmutableMap tickets = ForgeChunkManager.getPersistentChunksFor((yc)world).inverse().asMap();
        packet.writeShort(tickets.size());
        for (Map.Entry entry : tickets.entrySet()) {
            this.writeTicketToPacket(packet, (ForgeChunkManager.Ticket)entry.getKey(), (Collection)entry.getValue());
        }
        ServerUtils.sendPacketTo((qx)this.owner, (ef)packet.toPacket());
    }

    public void unloadDimension(int dim) {
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderServerPacketHandler.channel, 3);
        packet.writeInt(dim);
        ServerUtils.sendPacketTo((qx)this.owner, (ef)packet.toPacket());
    }

    public void sendChunkChange(PlayerChunkViewerManager.ChunkChange change) {
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderServerPacketHandler.channel, 4);
        packet.writeInt(change.dimension);
        packet.writeInt(change.chunk.a);
        packet.writeInt(change.chunk.b);
        packet.writeBoolean(change.add);
        ServerUtils.sendPacketTo((qx)this.owner, (ef)packet.toPacket());
    }

    public void sendTicketChange(PlayerChunkViewerManager.TicketChange change) {
        int ticketID = (Integer)this.manager.ticketIDs.get(change.ticket);
        if (!this.knownTickets.contains(ticketID)) {
            this.addTicket(change.dimension, change.ticket);
        }
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderServerPacketHandler.channel, 5);
        packet.writeInt(change.dimension);
        packet.writeInt(ticketID);
        packet.writeInt(change.chunk.a);
        packet.writeInt(change.chunk.b);
        packet.writeBoolean(change.force);
        ServerUtils.sendPacketTo((qx)this.owner, (ef)packet.toPacket());
    }

    public void updatePlayer(qx player) {
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderServerPacketHandler.channel, 6);
        packet.writeString(player.bR);
        packet.writeInt(player.aq);
        Vector3 pos = Vector3.fromEntity((lq)player);
        packet.writeFloat((float)pos.x);
        packet.writeFloat((float)pos.y);
        packet.writeFloat((float)pos.z);
        ServerUtils.sendPacketTo((qx)this.owner, (ef)packet.toPacket());
    }

    public void removePlayer(String username) {
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderServerPacketHandler.channel, 7);
        packet.writeString(username);
        ServerUtils.sendPacketTo((qx)this.owner, (ef)packet.toPacket());
    }

    public void addTicket(int dimension, ForgeChunkManager.Ticket ticket) {
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderServerPacketHandler.channel, 8);
        packet.writeInt(dimension);
        this.writeTicketToPacket(packet, ticket, (Collection)ticket.getChunkList());
        ServerUtils.sendPacketTo((qx)this.owner, (ef)packet.toPacket());
    }
}

