/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader;

import codechicken.chunkloader.PlayerChunkViewerTracker;
import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeChunkManager;

public class PlayerChunkViewerManager {
    public LinkedList playerViewers = new LinkedList();
    public HashMap ticketIDs = new HashMap();
    private int ticketID = 0;
    private int time = 0;
    private HashMap lastLoadedChunkMap = new HashMap();
    public LinkedList chunkChanges = new LinkedList();
    public LinkedList ticketChanges = new LinkedList();
    public LinkedList dimChanges = new LinkedList();
    public LinkedList logouts = new LinkedList();
    public LinkedList addViewers = new LinkedList();
    private static PlayerChunkViewerManager instance;

    public static PlayerChunkViewerManager instance() {
        if (instance == null) {
            instance = new PlayerChunkViewerManager();
        }
        return instance;
    }

    public void update() {
        ++this.time;
        for (String username : this.logouts) {
            Iterator iterator = this.playerViewers.iterator();
            while (iterator.hasNext()) {
                if (!((PlayerChunkViewerTracker)iterator.next()).owner.bR.equals(username)) continue;
                iterator.remove();
            }
        }
        for (String username : this.logouts) {
            for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                tracker.removePlayer(username);
            }
        }
        for (Object change : this.dimChanges) {
            if (!((DimensionChange)change).add) continue;
            for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                tracker.loadDimension(((DimensionChange)change).world);
            }
        }
        for (Object change : this.chunkChanges) {
            for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                tracker.sendChunkChange((ChunkChange)change);
            }
        }
        for (Object change : this.ticketChanges) {
            if (this.ticketIDs.containsKey(((TicketChange)change).ticket)) {
                for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                    tracker.sendTicketChange((TicketChange)change);
                }
                continue;
            }
            this.ticketIDs.put(((TicketChange)change).ticket, this.ticketID++);
            for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                tracker.addTicket(CommonUtils.getDimension((yc)((TicketChange)change).ticket.world), ((TicketChange)change).ticket);
            }
        }
        for (Object change : this.dimChanges) {
            if (((DimensionChange)change).add) continue;
            for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                tracker.unloadDimension(CommonUtils.getDimension((yc)((DimensionChange)change).world));
            }
        }
        if (this.time % 10 == 0) {
            for (qx player : ServerUtils.getAllPlayers()) {
                for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                    tracker.updatePlayer(player);
                }
            }
        }
        for (String username : this.addViewers) {
            iq player = ServerUtils.getPlayer((String)username);
            if (player == null) continue;
            this.playerViewers.add(new PlayerChunkViewerTracker((qx)player, this));
        }
        this.addViewers.clear();
        this.dimChanges.clear();
        this.logouts.clear();
        this.chunkChanges.clear();
        this.ticketChanges.clear();
    }

    public void calculateChunkChanges(in world) {
        int dimension = CommonUtils.getDimension((yc)world);
        HashSet wasLoadedChunks = (HashSet)this.lastLoadedChunkMap.get(dimension);
        if (wasLoadedChunks == null) {
            wasLoadedChunks = new HashSet();
        }
        HashSet<xv> allChunks = new HashSet<xv>();
        ArrayList loadedChunkCopy = new ArrayList(world.b.g);
        for (zz chunk : loadedChunkCopy) {
            xv coord = chunk.l();
            allChunks.add(coord);
            if (wasLoadedChunks.remove(coord)) continue;
            this.chunkChanges.add(new ChunkChange(dimension, coord, true));
        }
        for (xv coord : wasLoadedChunks) {
            this.chunkChanges.add(new ChunkChange(dimension, coord, false));
        }
        this.lastLoadedChunkMap.put(dimension, allChunks);
    }

    public boolean isViewerOpen(String username) {
        for (PlayerChunkViewerTracker tracker : this.playerViewers) {
            if (!tracker.owner.bR.equals(username)) continue;
            return true;
        }
        return false;
    }

    public static void serverShutdown() {
        instance = null;
    }

    public void closeViewer(String username) {
        Iterator iterator = this.playerViewers.iterator();
        while (iterator.hasNext()) {
            if (!((PlayerChunkViewerTracker)iterator.next()).owner.bR.equals(username)) continue;
            iterator.remove();
        }
    }

    public static class ChunkChange {
        public final xv chunk;
        public final boolean add;
        public final int dimension;

        public ChunkChange(int dimension, xv chunk, boolean add) {
            this.dimension = dimension;
            this.chunk = chunk;
            this.add = add;
        }
    }

    public static class DimensionChange {
        public final in world;
        public final boolean add;

        public DimensionChange(in world, boolean add) {
            this.world = world;
            this.add = add;
        }
    }

    public static class TicketChange {
        public final ForgeChunkManager.Ticket ticket;
        public final xv chunk;
        public final boolean force;
        public final int dimension;

        public TicketChange(ForgeChunkManager.Ticket ticket, xv chunk, boolean force) {
            this.ticket = ticket;
            this.dimension = CommonUtils.getDimension((yc)ticket.world);
            this.chunk = chunk;
            this.force = force;
        }
    }
}

