/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader;

import java.util.HashSet;

public enum ChunkLoaderShape {
    Square("Square"),
    Circle("Circle"),
    LineX("Line X"),
    LineZ("Line Z");

    String name;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private ChunkLoaderShape() {
        void s;
        this.name = s;
    }

    public HashSet getChunks(int radius, xv center) {
        HashSet<xv> chunkset = new HashSet<xv>();
        --radius;
        switch (this) {
            case Square: {
                int x2 = center.a - radius;
                while (x2 <= center.a + radius) {
                    int z2 = center.b - radius;
                    while (z2 <= center.b + radius) {
                        chunkset.add(new xv(x2, z2));
                        ++z2;
                    }
                    ++x2;
                }
                break;
            }
            case LineX: {
                int x3 = center.a - radius;
                while (x3 <= center.a + radius) {
                    chunkset.add(new xv(x3, center.b));
                    ++x3;
                }
                break;
            }
            case LineZ: {
                int z3 = center.b - radius;
                while (z3 <= center.b + radius) {
                    chunkset.add(new xv(center.a, z3));
                    ++z3;
                }
                break;
            }
            case Circle: {
                int x4 = center.a - radius;
                while (x4 <= center.a + radius) {
                    int z4 = center.b - radius;
                    while (z4 <= center.b + radius) {
                        int relx = x4 - center.a;
                        int relz = z4 - center.b;
                        double dist = Math.sqrt(relx * relx + relz * relz);
                        if (dist <= (double)radius) {
                            chunkset.add(new xv(x4, z4));
                        }
                        ++z4;
                    }
                    ++x4;
                }
                break;
            }
        }
        return chunkset;
    }

    public ChunkLoaderShape next() {
        int index = this.ordinal();
        if (++index == ChunkLoaderShape.values().length) {
            index = 0;
        }
        return ChunkLoaderShape.values()[index];
    }

    public ChunkLoaderShape prev() {
        int index = this.ordinal();
        if (--index == -1) {
            index = ChunkLoaderShape.values().length - 1;
        }
        return ChunkLoaderShape.values()[index];
    }

    public HashSet getLoadedChunks(int chunkx, int chunkz, int radius) {
        HashSet<xv> chunkSet = new HashSet<xv>();
        switch (this) {
            case Square: {
                int cx = chunkx - radius;
                while (cx <= chunkx + radius) {
                    int cz = chunkz - radius;
                    while (cz <= chunkz + radius) {
                        chunkSet.add(new xv(cx, cz));
                        ++cz;
                    }
                    ++cx;
                }
                break;
            }
            case LineX: {
                int cx = chunkx - radius;
                while (cx <= chunkx + radius) {
                    chunkSet.add(new xv(cx, chunkz));
                    ++cx;
                }
                break;
            }
            case LineZ: {
                int cz = chunkz - radius;
                while (cz <= chunkz + radius) {
                    chunkSet.add(new xv(chunkx, cz));
                    ++cz;
                }
                break;
            }
            case Circle: {
                int cx = chunkx - radius;
                while (cx <= chunkx + radius) {
                    int cz = chunkz - radius;
                    while (cz <= chunkz + radius) {
                        double distSquared = (cx - chunkx) * (cx - chunkx) + (cz - chunkz) * (cz - chunkz);
                        if (distSquared <= (double)(radius * radius)) {
                            chunkSet.add(new xv(cx, cz));
                        }
                        ++cz;
                    }
                    ++cx;
                }
                break;
            }
        }
        return chunkSet;
    }
}

