/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader;

import codechicken.chunkloader.ChickenChunks;
import codechicken.chunkloader.IChickenChunkLoader;
import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import codechicken.core.config.ConfigFile;
import codechicken.core.config.ConfigTag;
import codechicken.core.vec.BlockCoord;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;

public class ChunkLoaderManager {
    private static boolean reloadDimensions = false;
    private static int cleanupTicks;
    private static int maxChunks;
    private static int awayTimeout;
    private static HashMap mods;
    private static boolean loaded;
    private static HashMap playerOrganisers;
    private static HashMap modOrganisers;
    private static HashMap loginTimes;
    private static File saveDir;

    static {
        mods = new HashMap();
        loaded = false;
    }

    public static void registerMod(Object mod) {
        ModContainer container = (ModContainer)Loader.instance().getModObjectList().inverse().get(mod);
        if (container == null) {
            throw new NullPointerException("Mod container not found for: " + mod);
        }
        mods.put(mod, container);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)mod, (ForgeChunkManager.LoadingCallback)new DummyLoadingCallback());
    }

    public static void loadWorld(in world) {
        ReviveChange.DimensionRevive.list.add(world);
    }

    public static yc getWorld(int dim, boolean create) {
        if (create) {
            return MinecraftServer.D().a(dim);
        }
        return DimensionManager.getWorld((int)dim);
    }

    public static void load(in world) {
        if (loaded) {
            return;
        }
        loaded = true;
        playerOrganisers = new HashMap();
        modOrganisers = new HashMap();
        loginTimes = new HashMap();
        ReviveChange.load();
        try {
            saveDir = new File(CommonUtils.getWorldBaseSaveLocation((yc)world), "chickenchunks");
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            ChunkLoaderManager.loadPlayerChunks();
            ChunkLoaderManager.loadModChunks();
            ChunkLoaderManager.loadLoginTimes();
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Error while loading chunk info", true);
        }
    }

    private static void loadLoginTimes() throws IOException {
        File saveFile = new File(saveDir, "loginTimes.dat");
        if (!saveFile.exists()) {
            return;
        }
        DataInputStream datain = new DataInputStream(new FileInputStream(saveFile));
        int entries = datain.readInt();
        int i = 0;
        while (i < entries) {
            loginTimes.put(datain.readUTF(), datain.readLong());
            ++i;
        }
        datain.close();
    }

    private static void loadModChunks() throws IOException {
        for (Map.Entry entry : mods.entrySet()) {
            File saveFile = new File(saveDir, String.valueOf(((ModContainer)entry.getValue()).getModId()) + ".dat");
            if (!saveFile.exists()) {
                return;
            }
            DataInputStream datain = new DataInputStream(new FileInputStream(saveFile));
            ModOrganiser organiser = ChunkLoaderManager.getModOrganiser(entry.getKey());
            ReviveChange.ModRevive.list.add(organiser);
            organiser.load(datain);
            datain.close();
        }
    }

    private static void loadPlayerChunks() throws IOException {
        File saveFile = new File(saveDir, "players.dat");
        if (!saveFile.exists()) {
            return;
        }
        DataInputStream datain = new DataInputStream(new FileInputStream(saveFile));
        int organisers = datain.readInt();
        int i = 0;
        while (i < organisers) {
            String username = datain.readUTF();
            PlayerOrganiser organiser = ChunkLoaderManager.getPlayerOrganiser(username);
            organiser.setDormant();
            if (ChunkLoaderManager.allowOffline(username) && ChunkLoaderManager.loggedInRecently(username)) {
                ReviveChange.PlayerRevive.list.add(organiser);
            }
            organiser.load(datain);
            ++i;
        }
        datain.close();
    }

    private static boolean loggedInRecently(String username) {
        if (awayTimeout == 0) {
            return true;
        }
        Long lastLogin = (Long)loginTimes.get(username);
        if (lastLogin == null) {
            return false;
        }
        return (System.currentTimeMillis() - lastLogin) / 60000L < (long)awayTimeout;
    }

    public static int getPlayerChunkLimit(String username) {
        int ret;
        ConfigTag config = ChickenChunks.config.getTag("players");
        if (config.containsTag(username) && (ret = config.getTag(username).getIntValue(0)) != 0) {
            return ret;
        }
        if (ServerUtils.isPlayerOP((String)username) && (ret = config.getTag("OP").getIntValue(0)) != 0) {
            return ret;
        }
        return config.getTag("DEFAULT").getIntValue(5000);
    }

    public static boolean allowOffline(String username) {
        ConfigTag config = ChickenChunks.config.getTag("allowoffline");
        if (config.containsTag(username)) {
            return config.getTag(username).getBooleanValue(true);
        }
        if (ServerUtils.isPlayerOP((String)username)) {
            return config.getTag("OP").getBooleanValue(true);
        }
        return config.getTag("DEFAULT").getBooleanValue(true);
    }

    public static boolean allowChunkViewer(String username) {
        ConfigTag config = ChickenChunks.config.getTag("allowchunkviewer");
        if (config.containsTag(username)) {
            return config.getTag(username).getBooleanValue(true);
        }
        if (ServerUtils.isPlayerOP((String)username)) {
            return config.getTag("OP").getBooleanValue(true);
        }
        return config.getTag("DEFAULT").getBooleanValue(true);
    }

    public static void initConfig(ConfigFile config) {
        config.getTag("players").setPosition(0).useBraces().setComment("Per player chunk limiting. Values ignored if 0.:Simply add <username>=<value>");
        config.getTag("players.DEFAULT").setComment("Forge gives everyone 12500 by default").getIntValue(5000);
        config.getTag("players.OP").setComment("For server op's only.").getIntValue(5000);
        config.getTag("allowoffline").setPosition(1).useBraces().setComment("If set to false, players will have to be logged in for their chunkloaders to work.:Simply add <username>=<true|false>");
        config.getTag("allowoffline.DEFAULT").getBooleanValue(true);
        config.getTag("allowoffline.OP").getBooleanValue(true);
        config.getTag("allowchunkviewer").setPosition(2).useBraces().setComment("Set to false to deny a player access to the chunk viewer");
        config.getTag("allowchunkviewer.DEFAULT").getBooleanValue(true);
        config.getTag("allowchunkviewer.OP").getBooleanValue(true);
        cleanupTicks = config.getTag("cleanuptime").setComment("The number of ticks to wait between attempting to unload orphaned chunks").getIntValue(1200);
        reloadDimensions = config.getTag("reload-dimensions").setComment("Set to false to disable the automatic reloading of mystcraft dimensions on server restart").getBooleanValue(true);
        maxChunks = config.getTag("maxchunks").setComment("The maximum number of chunks per chunkloader").getIntValue(400);
        awayTimeout = config.getTag("awayTimeout").setComment("The number of minutes since last login within which chunks from a player will remain active, 0 for infinite.").getIntValue(0);
    }

    public static void addChunkLoader(IChickenChunkLoader loader) {
        int dim = CommonUtils.getDimension((yc)loader.getWorld());
        ChunkLoaderOrganiser organiser = ChunkLoaderManager.getOrganiser(loader);
        if (organiser.canForceNewChunks(dim, loader.getChunks())) {
            organiser.addChunkLoader(loader);
        } else {
            loader.deactivate();
        }
    }

    private static ChunkLoaderOrganiser getOrganiser(IChickenChunkLoader loader) {
        String owner = loader.getOwner();
        return owner == null ? ChunkLoaderManager.getModOrganiser(loader.getMod()) : ChunkLoaderManager.getPlayerOrganiser(owner);
    }

    public static void remChunkLoader(IChickenChunkLoader loader) {
        ChunkLoaderManager.getOrganiser(loader).remChunkLoader(loader);
    }

    public static void updateLoader(IChickenChunkLoader loader) {
        ChunkLoaderManager.getOrganiser(loader).updateChunkLoader(loader);
    }

    public static boolean canLoaderAdd(IChickenChunkLoader loader, Collection chunks) {
        String owner = loader.getOwner();
        int dim = CommonUtils.getDimension((yc)loader.getWorld());
        if (owner != null) {
            return ChunkLoaderManager.getPlayerOrganiser(owner).canForceNewChunks(dim, chunks);
        }
        return false;
    }

    private static PlayerOrganiser getPlayerOrganiser(String username) {
        PlayerOrganiser organiser = (PlayerOrganiser)playerOrganisers.get(username);
        if (organiser == null) {
            organiser = new PlayerOrganiser(username);
            playerOrganisers.put(username, organiser);
        }
        return organiser;
    }

    private static ModOrganiser getModOrganiser(Object mod) {
        ModOrganiser organiser = (ModOrganiser)modOrganisers.get(mod);
        if (organiser == null) {
            ModContainer container = (ModContainer)mods.get(mod);
            if (container == null) {
                throw new NullPointerException("Mod not registered with chickenchunks: " + mod);
            }
            organiser = new ModOrganiser(mod, container);
            modOrganisers.put(mod, organiser);
        }
        return organiser;
    }

    public static void serverShutdown() {
        loaded = false;
    }

    public static void save(in world) {
        try {
            if (PlayerOrganiser.dirty) {
                File saveFile = new File(saveDir, "players.dat");
                if (!saveFile.exists()) {
                    saveFile.createNewFile();
                }
                DataOutputStream dataout = new DataOutputStream(new FileOutputStream(saveFile));
                dataout.writeInt(playerOrganisers.size());
                for (PlayerOrganiser organiser : playerOrganisers.values()) {
                    dataout.writeUTF(organiser.username);
                    organiser.save(dataout);
                }
                dataout.close();
                PlayerOrganiser.dirty = false;
            }
            for (ModOrganiser organiser : modOrganisers.values()) {
                if (!organiser.dirty) continue;
                File saveFile = new File(saveDir, String.valueOf(organiser.container.getModId()) + ".dat");
                if (!saveFile.exists()) {
                    saveFile.createNewFile();
                }
                DataOutputStream dataout = new DataOutputStream(new FileOutputStream(saveFile));
                organiser.save(dataout);
                dataout.close();
                organiser.dirty = false;
            }
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Error while saving chunk info", true);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void cleanChunks(in world) {
        dim = CommonUtils.getDimension((yc)world);
        viewdist = ServerUtils.mc().ad().o();
        loadedChunks = new HashSet<xv>();
        for (qx player : ServerUtils.getPlayersInDimension((int)dim)) {
            playerChunkX = (int)player.t >> 4;
            playerChunkZ = (int)player.v >> 4;
            cx = playerChunkX - viewdist;
            while (cx <= playerChunkX + viewdist) {
                cz = playerChunkZ - viewdist;
                while (cz <= playerChunkZ + viewdist) {
                    loadedChunks.add(new xv(cx, cz));
                    ++cz;
                }
                ++cx;
            }
        }
        persistantChunks = world.getPersistentChunks();
        manager = world.r();
        for (zz chunk : world.b.g) {
            coord = chunk.l();
            if (loadedChunks.contains(coord) || persistantChunks.containsKey((Object)coord) || !world.b.a(coord.a, coord.b)) continue;
            instance = manager.a(coord.a, coord.b, false);
            if (instance != null) ** GOTO lbl28
            world.b.b(coord.a, coord.b);
            continue;
lbl-1000:
            // 1 sources

            {
                instance.b((iq)instance.b.get(0));
lbl28:
                // 2 sources

                ** while (instance.b.size() > 0)
            }
lbl29:
            // 1 sources

        }
        if (ServerUtils.getPlayersInDimension((int)dim).isEmpty() && world.getPersistentChunks().isEmpty() && !DimensionManager.shouldLoadSpawn((int)dim)) {
            DimensionManager.unloadWorld((int)dim);
        }
    }

    public static void tickEnd(in world) {
        if (world.G() % 1200L == 0L) {
            ChunkLoaderManager.updateLoginTimes();
        }
        if (cleanupTicks > 0 && world.G() % (long)cleanupTicks == 0L) {
            ChunkLoaderManager.cleanChunks(world);
        }
        ChunkLoaderManager.tickDownUnloads();
        ChunkLoaderManager.revivePlayerLoaders();
    }

    private static void updateLoginTimes() {
        long time = System.currentTimeMillis();
        for (qx player : ServerUtils.getAllPlayers()) {
            loginTimes.put(player.bR, time);
        }
        try {
            File saveFile = new File(saveDir, "loginTimes.dat");
            if (!saveFile.exists()) {
                saveFile.createNewFile();
            }
            DataOutputStream dataout = new DataOutputStream(new FileOutputStream(saveFile));
            dataout.writeInt(loginTimes.size());
            for (Map.Entry entry : loginTimes.entrySet()) {
                dataout.writeUTF((String)entry.getKey());
                dataout.writeLong((Long)entry.getValue());
            }
            dataout.close();
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Error while saving login times", true);
        }
        for (PlayerOrganiser organiser : playerOrganisers.values()) {
            if (organiser.isDormant() || ChunkLoaderManager.loggedInRecently(organiser.username)) continue;
            ReviveChange.PlayerDevive.list.add(organiser);
        }
    }

    private static void tickDownUnloads() {
        for (Map.Entry entry : playerOrganisers.entrySet()) {
            ((PlayerOrganiser)entry.getValue()).tickDownUnloads();
        }
        for (Map.Entry entry : modOrganisers.entrySet()) {
            ((ModOrganiser)entry.getValue()).tickDownUnloads();
        }
    }

    private static void revivePlayerLoaders() {
        for (Object organiser : ReviveChange.PlayerRevive.list) {
            ((PlayerOrganiser)organiser).revive();
        }
        ReviveChange.PlayerRevive.list.clear();
        for (Object organiser : ReviveChange.ModRevive.list) {
            ((ModOrganiser)organiser).revive();
        }
        ReviveChange.ModRevive.list.clear();
        for (Object world : ReviveChange.DimensionRevive.list) {
            for (PlayerOrganiser organiser : playerOrganisers.values()) {
                organiser.revive((yc)world);
            }
        }
        ReviveChange.DimensionRevive.list.clear();
        for (Object organiser : ReviveChange.PlayerDevive.list) {
            ((PlayerOrganiser)organiser).devive();
        }
        ReviveChange.PlayerDevive.list.clear();
    }

    public static void playerLogin(String username) {
        loginTimes.put(username, System.currentTimeMillis());
        ReviveChange.PlayerRevive.list.add(ChunkLoaderManager.getPlayerOrganiser(username));
    }

    public static void playerLogout(String username) {
        if (!ChunkLoaderManager.allowOffline(username)) {
            ReviveChange.PlayerDevive.list.add(ChunkLoaderManager.getPlayerOrganiser(username));
        }
    }

    public static int maxChunksPerLoader() {
        return maxChunks;
    }

    private static abstract class ChunkLoaderOrganiser
    extends TicketManager {
        private HashMap dormantLoaders = new HashMap();
        private HashMap forcedChunksByChunk = new HashMap();
        private HashMap forcedChunksByLoader = new HashMap();
        private HashMap timedUnloadQueue = new HashMap();
        private boolean reviving;
        private boolean dormant = false;

        private ChunkLoaderOrganiser() {
        }

        public boolean canForceNewChunks(int dimension, Collection chunks) {
            if (this.dormant) {
                return true;
            }
            int required = 0;
            for (xv coord : chunks) {
                LinkedList loaders = (LinkedList)this.forcedChunksByChunk.get(new DimChunkCoord(dimension, coord));
                if (loaders != null && !loaders.isEmpty()) continue;
                ++required;
            }
            return this.canForceNewChunks(required, dimension);
        }

        public final int numLoadedChunks() {
            return this.forcedChunksByChunk.size();
        }

        public void addChunkLoader(IChickenChunkLoader loader) {
            if (this.reviving) {
                return;
            }
            int dim = CommonUtils.getDimension((yc)loader.getWorld());
            if (this.dormant) {
                HashSet<BlockCoord> coords = (HashSet<BlockCoord>)this.dormantLoaders.get(dim);
                if (coords == null) {
                    coords = new HashSet<BlockCoord>();
                    this.dormantLoaders.put(dim, coords);
                }
                coords.add(loader.getPosition());
            } else {
                this.forcedChunksByLoader.put(loader, new HashSet());
                this.forceChunks(loader, dim, loader.getChunks());
            }
            this.setDirty();
        }

        public void remChunkLoader(IChickenChunkLoader loader) {
            if (this.dormant) {
                this.dormantLoaders.remove(loader.getPosition());
            } else {
                HashSet chunks = (HashSet)this.forcedChunksByLoader.remove(loader);
                if (chunks == null) {
                    return;
                }
                this.unforceChunks(loader, CommonUtils.getDimension((yc)loader.getWorld()), chunks, true);
            }
            this.setDirty();
        }

        private void unforceChunks(IChickenChunkLoader loader, int dim, Collection chunks, boolean remLoader) {
            for (xv coord : chunks) {
                DimChunkCoord dimCoord = new DimChunkCoord(dim, coord);
                LinkedList loaders = (LinkedList)this.forcedChunksByChunk.get(dimCoord);
                if (loaders == null || !loaders.remove(loader) || !loaders.isEmpty()) continue;
                this.forcedChunksByChunk.remove(dimCoord);
                this.timedUnloadQueue.put(dimCoord, 100);
            }
            if (!remLoader) {
                ((HashSet)this.forcedChunksByLoader.get(loader)).removeAll(chunks);
            }
            this.setDirty();
        }

        private void forceChunks(IChickenChunkLoader loader, int dim, Collection chunks) {
            for (xv coord : chunks) {
                DimChunkCoord dimCoord = new DimChunkCoord(dim, coord);
                LinkedList<IChickenChunkLoader> loaders = (LinkedList<IChickenChunkLoader>)this.forcedChunksByChunk.get(dimCoord);
                if (loaders == null) {
                    loaders = new LinkedList<IChickenChunkLoader>();
                    this.forcedChunksByChunk.put(dimCoord, loaders);
                }
                if (loaders.isEmpty()) {
                    this.timedUnloadQueue.remove(dimCoord);
                    this.addChunk(dimCoord);
                }
                if (loaders.contains(loader)) continue;
                loaders.add(loader);
            }
            ((HashSet)this.forcedChunksByLoader.get(loader)).addAll(chunks);
            this.setDirty();
        }

        public abstract boolean canForceNewChunks(int var1, int var2);

        public abstract void setDirty();

        public void updateChunkLoader(IChickenChunkLoader loader) {
            HashSet loaderChunks = (HashSet)this.forcedChunksByLoader.get(loader);
            if (loaderChunks == null) {
                this.addChunkLoader(loader);
                return;
            }
            HashSet oldChunks = new HashSet(loaderChunks);
            HashSet<xv> newChunks = new HashSet<xv>();
            for (xv chunk : loader.getChunks()) {
                if (oldChunks.remove(chunk)) continue;
                newChunks.add(chunk);
            }
            int dim = CommonUtils.getDimension((yc)loader.getWorld());
            if (!oldChunks.isEmpty()) {
                this.unforceChunks(loader, dim, oldChunks, false);
            }
            if (!newChunks.isEmpty()) {
                this.forceChunks(loader, dim, newChunks);
            }
        }

        public void save(DataOutput dataout) throws IOException {
            dataout.writeInt(this.dormantLoaders.size());
            for (Map.Entry entry : this.dormantLoaders.entrySet()) {
                dataout.writeInt((Integer)entry.getKey());
                HashSet coords = (HashSet)entry.getValue();
                dataout.writeInt(coords.size());
                for (BlockCoord coord : coords) {
                    dataout.writeInt(coord.x);
                    dataout.writeInt(coord.y);
                    dataout.writeInt(coord.z);
                }
            }
            dataout.writeInt(this.forcedChunksByLoader.size());
            for (IChickenChunkLoader loader : this.forcedChunksByLoader.keySet()) {
                BlockCoord coord = loader.getPosition();
                dataout.writeInt(CommonUtils.getDimension((yc)loader.getWorld()));
                dataout.writeInt(coord.x);
                dataout.writeInt(coord.y);
                dataout.writeInt(coord.z);
            }
        }

        public void load(DataInputStream datain) throws IOException {
            int dimensions = datain.readInt();
            int i = 0;
            while (i < dimensions) {
                int dim = datain.readInt();
                HashSet<BlockCoord> coords = new HashSet<BlockCoord>();
                this.dormantLoaders.put(dim, coords);
                int numCoords = datain.readInt();
                int j = 0;
                while (j < numCoords) {
                    coords.add(new BlockCoord(datain.readInt(), datain.readInt(), datain.readInt()));
                    ++j;
                }
                ++i;
            }
            int numLoaders = datain.readInt();
            int i2 = 0;
            while (i2 < numLoaders) {
                int dim = datain.readInt();
                HashSet<BlockCoord> coords = (HashSet<BlockCoord>)this.dormantLoaders.get(dim);
                if (coords == null) {
                    coords = new HashSet<BlockCoord>();
                    this.dormantLoaders.put(dim, coords);
                }
                coords.add(new BlockCoord(datain.readInt(), datain.readInt(), datain.readInt()));
                ++i2;
            }
        }

        public void revive() {
            if (!this.dormant) {
                return;
            }
            this.dormant = false;
            Iterator iterator = this.dormantLoaders.keySet().iterator();
            while (iterator.hasNext()) {
                int dim = (Integer)iterator.next();
                yc world = ChunkLoaderManager.getWorld(dim, reloadDimensions);
                if (world == null) continue;
                this.revive(world);
            }
        }

        public void devive() {
            if (this.dormant) {
                return;
            }
            for (IChickenChunkLoader loader : new ArrayList(this.forcedChunksByLoader.keySet())) {
                int dim = CommonUtils.getDimension((yc)loader.getWorld());
                HashSet<BlockCoord> coords = (HashSet<BlockCoord>)this.dormantLoaders.get(dim);
                if (coords == null) {
                    coords = new HashSet<BlockCoord>();
                    this.dormantLoaders.put(dim, coords);
                }
                coords.add(loader.getPosition());
                this.remChunkLoader(loader);
            }
            this.dormant = true;
        }

        public void revive(yc world) {
            HashSet coords = (HashSet)this.dormantLoaders.get(CommonUtils.getDimension((yc)world));
            if (coords == null) {
                return;
            }
            ArrayList verifyCoords = new ArrayList(coords);
            coords.clear();
            for (BlockCoord coord : verifyCoords) {
                this.reviving = true;
                any tile = world.q(coord.x, coord.y, coord.z);
                this.reviving = false;
                if (!(tile instanceof IChickenChunkLoader)) continue;
                ChunkLoaderManager.addChunkLoader((IChickenChunkLoader)tile);
            }
        }

        public void setDormant() {
            this.dormant = true;
        }

        public boolean isDormant() {
            return this.dormant;
        }

        public void tickDownUnloads() {
            Iterator iterator = this.timedUnloadQueue.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                int ticks = (Integer)entry.getValue();
                if (ticks <= 1) {
                    this.remChunk((DimChunkCoord)entry.getKey());
                    iterator.remove();
                    continue;
                }
                entry.setValue(ticks - 1);
            }
        }
    }

    private static class DimChunkCoord {
        public final int dimension;
        public final int chunkX;
        public final int chunkZ;

        public DimChunkCoord(int dim, xv coord) {
            this(dim, coord.a, coord.b);
        }

        public DimChunkCoord(int dim, int x, int z) {
            this.dimension = dim;
            this.chunkX = x;
            this.chunkZ = z;
        }

        public int hashCode() {
            return (this.chunkX * 31 + this.chunkZ) * 31 + this.dimension;
        }

        public boolean equals(Object o) {
            if (o instanceof DimChunkCoord) {
                DimChunkCoord o2 = (DimChunkCoord)o;
                return this.dimension == o2.dimension && this.chunkX == o2.chunkX && this.chunkZ == o2.chunkZ;
            }
            return false;
        }

        public xv getChunkCoord() {
            return new xv(this.chunkX, this.chunkZ);
        }
    }

    private static class DummyLoadingCallback
    implements ForgeChunkManager.OrderedLoadingCallback,
    ForgeChunkManager.PlayerOrderedLoadingCallback {
        private DummyLoadingCallback() {
        }

        public void ticketsLoaded(List tickets, yc world) {
        }

        public List ticketsLoaded(List tickets, yc world, int maxTicketCount) {
            return new LinkedList();
        }

        public ListMultimap playerTicketsLoaded(ListMultimap tickets, yc world) {
            return LinkedListMultimap.create();
        }
    }

    private static class ModOrganiser
    extends ChunkLoaderOrganiser {
        public final Object mod;
        public final ModContainer container;
        private boolean dirty;

        public ModOrganiser(Object mod, ModContainer container) {
            this.mod = mod;
            this.container = container;
        }

        @Override
        public boolean canForceNewChunks(int required, int dim) {
            return required < ForgeChunkManager.ticketCountAvailableFor((Object)this.mod, (yc)DimensionManager.getWorld((int)dim)) * ForgeChunkManager.getMaxChunkDepthFor((String)this.container.getModId());
        }

        @Override
        public void setDirty() {
            this.dirty = false;
        }

        @Override
        protected ForgeChunkManager.Ticket createTicket(int dimension) {
            return ForgeChunkManager.requestTicket((Object)this.mod, (yc)DimensionManager.getWorld((int)dimension), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        }
    }

    private static class PlayerOrganiser
    extends ChunkLoaderOrganiser {
        private static boolean dirty;
        public final String username;

        public PlayerOrganiser(String username) {
            this.username = username;
        }

        @Override
        public boolean canForceNewChunks(int required, int dim) {
            return required + this.numLoadedChunks() < ChunkLoaderManager.getPlayerChunkLimit(this.username) && required < ForgeChunkManager.ticketCountAvailableFor((String)this.username) * ForgeChunkManager.getMaxChunkDepthFor((String)"ChickenChunks");
        }

        @Override
        public ForgeChunkManager.Ticket createTicket(int dimension) {
            return ForgeChunkManager.requestPlayerTicket((Object)ChickenChunks.instance, (String)this.username, (yc)DimensionManager.getWorld((int)dimension), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        }

        @Override
        public void setDirty() {
            dirty = true;
        }
    }

    private static enum ReviveChange {
        PlayerRevive,
        PlayerDevive,
        ModRevive,
        DimensionRevive;

        public LinkedList list;

        public static void load() {
            ReviveChange[] reviveChangeArray = ReviveChange.values();
            int n = reviveChangeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReviveChange change = reviveChangeArray[n2];
                change.list = new LinkedList();
                ++n2;
            }
        }
    }

    private static abstract class TicketManager {
        public HashMap ticketsWithSpace = new HashMap();
        public HashMap heldChunks = new HashMap();

        private TicketManager() {
        }

        protected void addChunk(DimChunkCoord coord) {
            ForgeChunkManager.Ticket ticket;
            if (this.heldChunks.containsKey(coord)) {
                return;
            }
            Stack<ForgeChunkManager.Ticket> freeTickets = (Stack<ForgeChunkManager.Ticket>)this.ticketsWithSpace.get(coord.dimension);
            if (freeTickets == null) {
                freeTickets = new Stack<ForgeChunkManager.Ticket>();
                this.ticketsWithSpace.put(coord.dimension, freeTickets);
            }
            if (freeTickets.isEmpty()) {
                ticket = this.createTicket(coord.dimension);
                freeTickets.push(ticket);
            } else {
                ticket = (ForgeChunkManager.Ticket)freeTickets.peek();
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (xv)coord.getChunkCoord());
            this.heldChunks.put(coord, ticket);
            if (ticket.getChunkList().size() == ticket.getChunkListDepth() && !freeTickets.isEmpty()) {
                freeTickets.pop();
            }
        }

        protected abstract ForgeChunkManager.Ticket createTicket(int var1);

        protected void remChunk(DimChunkCoord coord) {
            ForgeChunkManager.Ticket ticket = (ForgeChunkManager.Ticket)this.heldChunks.remove(coord);
            if (ticket == null) {
                return;
            }
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (xv)coord.getChunkCoord());
            if (ticket.getChunkList().size() == ticket.getChunkListDepth() - 1) {
                Stack<ForgeChunkManager.Ticket> freeTickets = (Stack<ForgeChunkManager.Ticket>)this.ticketsWithSpace.get(coord.dimension);
                if (freeTickets == null) {
                    freeTickets = new Stack<ForgeChunkManager.Ticket>();
                    this.ticketsWithSpace.put(coord.dimension, freeTickets);
                }
                freeTickets.push(ticket);
            }
        }
    }
}

