/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader;

import codechicken.chunkloader.ChunkLoaderManager;
import codechicken.chunkloader.PlayerChunkViewerManager;
import codechicken.core.ServerUtils;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;

public class ChunkLoaderEventHandler
implements ITickHandler,
IPlayerTracker {
    public void tickStart(EnumSet type, Object ... tickData) {
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
        if (type.contains(TickType.SERVER)) {
            PlayerChunkViewerManager.instance().update();
        }
        if (type.contains(TickType.WORLD)) {
            ChunkLoaderManager.tickEnd((in)tickData[0]);
            PlayerChunkViewerManager.instance().calculateChunkChanges((in)tickData[0]);
        }
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.PLAYER, TickType.SERVER, TickType.WORLD);
    }

    public String getLabel() {
        return "ChickenChunks";
    }

    public void onPlayerLogin(qx player) {
        ChunkLoaderManager.playerLogin(player.bR);
    }

    public void onPlayerLogout(qx player) {
        PlayerChunkViewerManager.instance().logouts.add(player.bR);
        ChunkLoaderManager.playerLogout(player.bR);
    }

    public void onPlayerChangedDimension(qx player) {
    }

    public void onPlayerRespawn(qx player) {
    }

    @ForgeSubscribe
    public void onChunkDataLoad(ChunkDataEvent.Load event) {
        ChunkLoaderManager.load((in)event.world);
    }

    @ForgeSubscribe
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.world.I) {
            ChunkLoaderManager.load((in)event.world);
            ChunkLoaderManager.loadWorld((in)event.world);
            PlayerChunkViewerManager.instance().dimChanges.add(new PlayerChunkViewerManager.DimensionChange((in)event.world, true));
        }
    }

    @ForgeSubscribe
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.world.I) {
            if (ServerUtils.mc().m()) {
                PlayerChunkViewerManager.instance().dimChanges.add(new PlayerChunkViewerManager.DimensionChange((in)event.world, false));
            } else {
                PlayerChunkViewerManager.serverShutdown();
                ChunkLoaderManager.serverShutdown();
            }
        }
    }

    @ForgeSubscribe
    public void onWorldSave(WorldEvent.Save event) {
        ChunkLoaderManager.save((in)event.world);
    }

    @ForgeSubscribe
    public void onChunkForce(ForgeChunkManager.ForceChunkEvent event) {
        PlayerChunkViewerManager.instance().ticketChanges.add(new PlayerChunkViewerManager.TicketChange(event.ticket, event.location, true));
    }

    @ForgeSubscribe
    public void onChunkUnForce(ForgeChunkManager.UnforceChunkEvent event) {
        PlayerChunkViewerManager.instance().ticketChanges.add(new PlayerChunkViewerManager.TicketChange(event.ticket, event.location, false));
    }
}

