/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.core.IOreDictionaryHandler;
import forestry.api.core.IPacketHandler;
import forestry.api.core.IPickupHandler;
import forestry.api.core.IPlugin;
import forestry.api.core.IResupplyHandler;
import forestry.api.core.ISaveEventHandler;
import forestry.core.ForestryCore;
import forestry.core.proxy.Proxies;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class PluginManager {
    public static ArrayList plugins = new ArrayList();
    public static ArrayList guiHandlers = new ArrayList();
    public static ArrayList packetHandlers = new ArrayList();
    public static ArrayList pickupHandlers = new ArrayList();
    public static ArrayList saveEventHandlers = new ArrayList();
    public static ArrayList resupplyHandlers = new ArrayList();
    public static ArrayList dictionaryHandlers = new ArrayList();

    public static void loadPlugins(File modLocation) {
        PluginManager.loadIncludedPlugins(modLocation);
        PluginManager.loadExternalPlugins(modLocation);
    }

    private static void loadIncludedPlugins(File modLocation) {
        ClassLoader classLoader = ForestryCore.class.getClassLoader();
        if (modLocation.isFile() && (modLocation.getName().endsWith(".jar") || modLocation.getName().endsWith(".zip"))) {
            PluginManager.loadPluginsFromFile(modLocation, classLoader);
        } else if (modLocation.isDirectory()) {
            PluginManager.loadPluginsFromBin(modLocation, classLoader);
        }
    }

    private static void loadExternalPlugins(File modLocation) {
        try {
            File pluginDir = new File(Proxies.common.getForestryRoot() + "/mods");
            ClassLoader classLoader = ForestryCore.class.getClassLoader();
            if (!pluginDir.isDirectory()) {
                return;
            }
            File[] fileList = pluginDir.listFiles();
            if (fileList == null) {
                return;
            }
            for (File file : fileList) {
                if (!file.isFile() || !file.getName().endsWith(".jar") && !file.getName().endsWith(".zip") || file.getName().equals(modLocation.getName())) continue;
                PluginManager.loadPluginsFromFile(file, classLoader);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void loadPluginsFromFile(File file, ClassLoader classLoader) {
        try {
            ZipEntry entry = null;
            FileInputStream fileIO = new FileInputStream(file);
            ZipInputStream zipIO = new ZipInputStream(fileIO);
            while (true) {
                if ((entry = zipIO.getNextEntry()) == null) {
                    fileIO.close();
                    break;
                }
                String entryName = entry.getName();
                File entryFile = new File(entryName);
                String pluginName = entryFile.getName();
                if (entry.isDirectory() || !pluginName.startsWith("Plugin") || !pluginName.endsWith(".class")) continue;
                PluginManager.addPlugin(classLoader, pluginName, entryFile.getPath().replace(File.separatorChar, '.'));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String parseClassName(String binpath) {
        String[] tokens = binpath.split("\\\\");
        String packageName = "";
        for (int i = 0; i < tokens.length && tokens[i] != null; ++i) {
            if (!tokens[i].equals("bin")) continue;
            for (int j = i + 1; j < tokens.length; ++j) {
                if (packageName.length() > 0) {
                    packageName = packageName + ".";
                }
                packageName = packageName + tokens[j];
            }
            break;
        }
        return packageName;
    }

    private static void loadPluginsFromBin(File bin, ClassLoader classLoader) {
        File[] fileList = bin.listFiles();
        if (fileList != null) {
            for (File file : fileList) {
                String pluginName = file.getName();
                if (file.isFile() && pluginName.startsWith("Plugin") && pluginName.endsWith(".class")) {
                    PluginManager.addPlugin(classLoader, pluginName, PluginManager.parseClassName(file.getPath()));
                    continue;
                }
                if (!file.isDirectory()) continue;
                PluginManager.loadPluginsFromBin(file, classLoader);
            }
        }
    }

    public static void addPlugin(ClassLoader classLoader, String pluginName, String packageName) {
        if (pluginName.equals("PluginManager.class") || pluginName.equals("PluginInfo.class")) {
            return;
        }
        String pluginClassName = packageName.replace(".class", "");
        try {
            Class<?> pluginClass = classLoader.loadClass(pluginClassName);
            if (pluginClass != null) {
                Class<?> clz = pluginClass;
                boolean isPlugin = false;
                block2: do {
                    for (Class<?> i : clz.getInterfaces()) {
                        if (i != IPlugin.class) continue;
                        isPlugin = true;
                        continue block2;
                    }
                } while ((clz = clz.getSuperclass()) != null && !isPlugin);
                if (!isPlugin) {
                    return;
                }
                IPlugin plugin = (IPlugin)pluginClass.newInstance();
                if (plugin != null) {
                    IOreDictionaryHandler dictionaryHandler;
                    IResupplyHandler resupplyHandler;
                    ISaveEventHandler saveHandler;
                    IPickupHandler pickupHandler;
                    IPacketHandler packetHandler;
                    Proxies.log.fine("Found plugin for " + plugin.getDescription());
                    plugins.add(plugin);
                    IGuiHandler guiHandler = plugin.getGuiHandler();
                    if (guiHandler != null) {
                        guiHandlers.add(guiHandler);
                    }
                    if ((packetHandler = plugin.getPacketHandler()) != null) {
                        packetHandlers.add(packetHandler);
                    }
                    if ((pickupHandler = plugin.getPickupHandler()) != null) {
                        pickupHandlers.add(pickupHandler);
                    }
                    if ((saveHandler = plugin.getSaveEventHandler()) != null) {
                        saveEventHandlers.add(saveHandler);
                    }
                    if ((resupplyHandler = plugin.getResupplyHandler()) != null) {
                        resupplyHandlers.add(resupplyHandler);
                    }
                    if ((dictionaryHandler = plugin.getDictionaryHandler()) != null) {
                        dictionaryHandlers.add(dictionaryHandler);
                    }
                    if (plugin instanceof IFuelHandler) {
                        GameRegistry.registerFuelHandler((IFuelHandler)((IFuelHandler)plugin));
                    }
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }
}

