/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.circuits.ChipsetManager;
import forestry.api.core.IOreDictionaryHandler;
import forestry.api.core.ISaveEventHandler;
import forestry.api.core.PluginInfo;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.core.CommandForestry;
import forestry.core.CreativeTabForestry;
import forestry.core.GameMode;
import forestry.core.SaveEventHandlerCore;
import forestry.core.circuits.CircuitRegistry;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.circuits.ItemSolderingIron;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.GadgetManager;
import forestry.core.gadgets.MachineAnalyzer;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.MachinePackage;
import forestry.core.genetics.Allele;
import forestry.core.genetics.AlleleRegistry;
import forestry.core.items.ItemAssemblyKit;
import forestry.core.items.ItemCrated;
import forestry.core.items.ItemForestry;
import forestry.core.items.ItemForestryPickaxe;
import forestry.core.items.ItemForestryShovel;
import forestry.core.items.ItemFruit;
import forestry.core.items.ItemLiquidContainer;
import forestry.core.items.ItemLiquids;
import forestry.core.items.ItemMisc;
import forestry.core.items.ItemOverlay;
import forestry.core.items.ItemPipette;
import forestry.core.items.ItemWrench;
import forestry.core.proxy.Proxies;
import forestry.core.utils.CraftingIngredients;
import forestry.core.utils.EnergyConfiguration;
import forestry.plugins.NativePlugin;
import forestry.plugins.PluginBuildCraft;
import forestry.plugins.PluginForestryApiculture;
import forestry.plugins.PluginForestryCore;
import java.util.ArrayList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;

@PluginInfo(pluginID="Core", name="Core", author="SirSengir", url="http://forestry.sengir.net/", description="Core mechanics for Forestry. Required by all other plugins.")
public class PluginForestryCore
extends NativePlugin
implements IFuelHandler {
    @Override
    public void preInit() {
        super.preInit();
        if (Proxies.render.hasRendering()) {
            this.verify$Others();
        }
        ChipsetManager.solderManager = new ItemSolderingIron.SolderManager();
        CircuitRegistry circuitRegistry = new CircuitRegistry();
        ChipsetManager.circuitRegistry = circuitRegistry;
        circuitRegistry.initialize();
        AlleleRegistry alleleRegistry = new AlleleRegistry();
        AlleleManager.alleleRegistry = alleleRegistry;
        alleleRegistry.initialize();
        Allele.initialize();
        GameRegistry.registerFuelHandler((IFuelHandler)this);
    }

    @Override
    public void postInit() {
        super.postInit();
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Core";
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return null;
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return new SaveEventHandlerCore();
    }

    @Override
    protected void registerPackages() {
        MachinePackage pack = PluginForestryCore.getAnalyzerPackage();
        if (pack != null) {
            GadgetManager.registerMillPackage(4, pack);
        }
    }

    @Override
    protected void registerItems() {
        ForestryItem.fertilizerBio = new ItemForestry(Config.getOrCreateItemIdProperty("fertilizerBio", 5000)).b("fertilizerBio").c(19);
        ForestryItem.fertilizerCompound = new ItemForestry(Config.getOrCreateItemIdProperty("fertilizerCompound", 5001)).b("fertilizerCompound").c(1);
        ForestryItem.apatite = new ItemForestry(Config.getOrCreateItemIdProperty("apatite", 5002)).b("apatite").c(0);
        OreDictionary.registerOre((String)"gemApatite", (ur)new ur(ForestryItem.apatite));
        up copper = new ItemForestry(Config.getOrCreateItemIdProperty("ingotCopper", 5003)).b("ingotCopper").c(3);
        ForestryItem.ingotCopper = new ur(copper);
        wj.a().addSmelting(ForestryBlock.resources.cm, 1, ForestryItem.ingotCopper, 0.5f);
        up tin = new ItemForestry(Config.getOrCreateItemIdProperty("ingotTin", 5004)).b("ingotTin").c(2);
        ForestryItem.ingotTin = new ur(tin);
        wj.a().addSmelting(ForestryBlock.resources.cm, 2, ForestryItem.ingotTin, 0.5f);
        up bronze = new ItemForestry(Config.getOrCreateItemIdProperty("ingotBronze", 5005)).b("ingotBronze").c(4);
        ForestryItem.ingotBronze = new ur(bronze);
        OreDictionary.registerOre((String)"ingotCopper", (ur)ForestryItem.ingotCopper);
        OreDictionary.registerOre((String)"ingotTin", (ur)ForestryItem.ingotTin);
        OreDictionary.registerOre((String)"ingotBronze", (ur)ForestryItem.ingotBronze);
        ForestryItem.wrench = new ItemWrench(Config.getOrCreateItemIdProperty("wrench", 5007)).b("wrench").c(6);
        ForestryItem.pipette = new ItemPipette(Config.getOrCreateItemIdProperty("pipette", 13111)).b("pipette").c(20).o();
        ForestryItem.sturdyCasing = new ItemForestry(Config.getOrCreateItemIdProperty("sturdyMachine", 5010)).b("sturdyMachine").c(9);
        ForestryItem.hardenedCasing = new ItemForestry(Config.getOrCreateItemIdProperty("hardenedMachine", 5025)).b("hardenedMachine").c(39);
        ForestryItem.impregnatedCasing = new ItemForestry(Config.getOrCreateItemIdProperty("impregnatedCasing", 13124)).b("impregnatedCasing").c(61);
        ForestryItem.craftingMaterial = new ItemMisc(Config.getOrCreateItemIdProperty("craftingMaterial", 13098)).b("craftingMaterial");
        ForestryItem.vialCatalyst = new ItemForestry(Config.getOrCreateItemIdProperty("vialCatalyst", 5012)).b("vialCatalyst").c(58);
        ForestryItem.peat = new ItemForestry(Config.getOrCreateItemIdProperty("peat", 5017)).b("peat").c(16);
        OreDictionary.registerOre((String)"brickPeat", (ur)new ur(ForestryItem.peat));
        ForestryItem.ash = new ItemForestry(Config.getOrCreateItemIdProperty("ash", 5018)).b("ash").c(17);
        OreDictionary.registerOre((String)"dustAsh", (ur)new ur(ForestryItem.ash));
        Proxies.common.addSmelting(new ur(ForestryItem.peat), new ur(ForestryItem.ash));
        ForestryItem.bituminousPeat = new ItemForestry(Config.getOrCreateItemIdProperty("bituminousPeat", 13041)).b("bituminousPeat").c(59);
        ForestryItem.gearBronze = new ItemForestry(Config.getOrCreateItemIdProperty("gearBronze", 5008)).b("gearBronze").c(7);
        OreDictionary.registerOre((String)"gearBronze", (ur)new ur(ForestryItem.gearBronze));
        ForestryItem.gearCopper = new ItemForestry(Config.getOrCreateItemIdProperty("gearCopper", 5019)).b("gearCopper").c(18);
        OreDictionary.registerOre((String)"gearCopper", (ur)new ur(ForestryItem.gearCopper));
        ForestryItem.gearTin = new ItemForestry(Config.getOrCreateItemIdProperty("gearTin", 5024)).b("gearTin").c(38);
        OreDictionary.registerOre((String)"gearTin", (ur)new ur(ForestryItem.gearTin));
        ForestryItem.circuitboards = new ItemCircuitBoard(Config.getOrCreateItemIdProperty("chipsets", 13112)).b("chipsets");
        ForestryItem.solderingIron = new ItemSolderingIron(Config.getOrCreateItemIdProperty("solderingIron", 13113)).c(11).b("solderingIron");
        ForestryItem.tubes = new ItemOverlay(Config.getOrCreateItemIdProperty("thermionicTubes", 13114), CreativeTabForestry.tabForestry, new ItemOverlay.OverlayInfo[]{new ItemOverlay.OverlayInfo("ex-0", 0xFFFFFF, 14923662), new ItemOverlay.OverlayInfo("ex-1", 0xFFFFFF, 14806772), new ItemOverlay.OverlayInfo("ex-2", 0xFFFFFF, 14533238), new ItemOverlay.OverlayInfo("ex-3", 0xFFFFFF, 0xD8D8D8), new ItemOverlay.OverlayInfo("ex-4", 0xFFFFFF, 0xFFFF8B), new ItemOverlay.OverlayInfo("ex-5", 0xFFFFFF, 8114616), new ItemOverlay.OverlayInfo("ex-6", 0xFFFFFF, 8809408), new ItemOverlay.OverlayInfo("ex-7", 16775294, 14247424), new ItemOverlay.OverlayInfo("ex-8", 0xFFFFFF, 0x444444), new ItemOverlay.OverlayInfo("ex-9", 0xFFFFFF, 0xBFFFDD), new ItemOverlay.OverlayInfo("ex-10", 0xFFFFFF, 6868206), new ItemOverlay.OverlayInfo("ex-11", 0xFFFFFF, 1857478)}).setIcons(41, 42).b("thermionicTubes");
        ForestryItem.carton = new ItemForestry(Config.getOrCreateItemIdProperty("carton", 13000)).b("carton").c(24);
        ForestryItem.crate = new ItemForestry(Config.getOrCreateItemIdProperty("crate", 13001)).b("crate").c(32);
        ForestryItem.stickImpregnated = new ItemForestry(Config.getOrCreateItemIdProperty("oakStick", 13002)).b("oakStick").c(25);
        ForestryItem.woodPulp = new ItemForestry(Config.getOrCreateItemIdProperty("woodPulp", 13003)).b("woodPulp").c(33);
        OreDictionary.registerOre((String)"pulpWood", (ur)new ur(ForestryItem.woodPulp));
        ForestryItem.brokenBronzePickaxe = new ItemForestry(Config.getOrCreateItemIdProperty("brokenBronzePickaxe", 13006)).b("brokenBronzePickaxe").c(28);
        ForestryItem.brokenBronzeShovel = new ItemForestry(Config.getOrCreateItemIdProperty("brokenBronzeShovel", 13009)).b("brokenBronzeShovel").c(31);
        ForestryItem.bronzePickaxe = new ItemForestryPickaxe(Config.getOrCreateItemIdProperty("bronzePickaxe", 13005), new ur(ForestryItem.brokenBronzePickaxe)).b("bronzePickaxe").c(27);
        MinecraftForge.setToolClass((up)ForestryItem.bronzePickaxe, (String)"pickaxe", (int)3);
        MinecraftForge.EVENT_BUS.register((Object)ForestryItem.bronzePickaxe);
        ForestryItem.bronzeShovel = new ItemForestryShovel(Config.getOrCreateItemIdProperty("bronzeShovel", 13008), new ur(ForestryItem.brokenBronzeShovel)).b("bronzeShovel").c(30);
        MinecraftForge.setToolClass((up)ForestryItem.bronzeShovel, (String)"shovel", (int)3);
        MinecraftForge.EVENT_BUS.register((Object)ForestryItem.bronzeShovel);
        ForestryItem.kitShovel = new ItemAssemblyKit(Config.getOrCreateItemIdProperty("kitShovel", 13007), new ur(ForestryItem.bronzeShovel)).b("kitShovel").c(29);
        ForestryItem.kitPickaxe = new ItemAssemblyKit(Config.getOrCreateItemIdProperty("kitPickaxe", 13004), new ur(ForestryItem.bronzePickaxe)).b("kitPickaxe").c(26);
        ForestryItem.mouldyWheat = new ItemForestry(Config.getOrCreateItemIdProperty("mouldyWheat", 13020)).b("mouldyWheat").c(35);
        ForestryItem.decayingWheat = new ItemForestry(Config.getOrCreateItemIdProperty("decayingWheat", 13021)).b("decayingWheat").c(36);
        ForestryItem.mulch = new ItemForestry(Config.getOrCreateItemIdProperty("mulch", 13022)).b("mulch").c(34);
        ForestryItem.iodineCharge = new ItemForestry(Config.getOrCreateItemIdProperty("iodineCapsule", 5026)).b("iodineCapsule").c(40);
        ForestryItem.phosphor = new ItemForestry(Config.getOrCreateItemIdProperty("phosphor", 13068)).b("phosphor").c(78);
        ForestryItem.beeswax = new ItemForestry(Config.getOrCreateItemIdProperty("beeswax", 13029)).b("beeswax").c(44).a(Tabs.tabApiculture);
        OreDictionary.registerOre((String)"itemBeeswax", (ur)new ur(ForestryItem.beeswax));
        ForestryItem.refractoryWax = new ItemForestry(Config.getOrCreateItemIdProperty("refractoryWax", 13069)).b("refractoryWax").c(79);
        ForestryItem.fruits = new ItemFruit(Config.getOrCreateItemIdProperty("fruits", 13130)).b("fruits");
        ForestryItem.waxCapsule = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsule", 13034), 1).b("waxCapsule");
        ForestryItem.canEmpty = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canEmpty", 5021), 0).b("canEmpty");
        ForestryItem.refractoryEmpty = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryEmpty", 13070), 7).b("refractoryEmpty");
        ForestryItem.bucketBiomass = new ItemForestry(Config.getOrCreateItemIdProperty("bucketBiomass", 5009)).b("bucketBiomass").c(8).a(up.aw).d(1);
        ForestryItem.bucketBiofuel = new ItemForestry(Config.getOrCreateItemIdProperty("bucketBiofuel", 5015)).b("bucketBiofuel").c(14).a(up.aw).d(1);
        ForestryItem.waxCapsuleWater = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleWater", 13038), 17).b("waxCapsuleWater");
        ForestryItem.waxCapsuleBiomass = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleBiomass", 13039), 33).b("waxCapsuleBiomass");
        ForestryItem.waxCapsuleBiofuel = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleBiofuel", 13040), 49).b("waxCapsuleBiofuel");
        ForestryItem.waxCapsuleOil = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleOil", 13042), 97).b("waxCapsuleOil");
        ForestryItem.waxCapsuleFuel = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleFuel", 13043), 113).b("waxCapsuleFuel");
        ForestryItem.waxCapsuleSeedOil = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleSeedOil", 13065), 145).b("waxCapsuleSeedOil");
        ForestryItem.waxCapsuleHoney = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleHoney", 13066), 161).setDrink(2, 0.2f).b("waxCapsuleHoney");
        ForestryItem.waxCapsuleJuice = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleJuice", 13067), 177).setDrink(2, 0.2f).b("waxCapsuleJuice");
        ForestryItem.waxCapsuleIce = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleIce", 13121), 193).b("waxCapsuleIce");
        ForestryItem.canWater = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waterCan", 5020), 16).b("waterCan");
        ForestryItem.canBiomass = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("biomassCan", 5022), 32).b("biomassCan");
        ForestryItem.canBiofuel = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("biofuelCan", 5023), 48).b("biofuelCan");
        ForestryItem.canOil = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canOil", 13044), 96).b("canOil");
        ForestryItem.canFuel = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canFuel", 13045), 112).b("canFuel");
        ForestryItem.canLava = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canLava", 13046), 128).b("canLava");
        ForestryItem.canSeedOil = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canSeedOil", 13062), 144).b("canSeedOil");
        ForestryItem.canHoney = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canHoney", 13063), 160).setDrink(2, 0.2f).b("canHoney");
        ForestryItem.canJuice = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canJuice", 13064), 176).setDrink(2, 0.2f).b("canJuice");
        ForestryItem.canIce = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canIce", 13120), 192).b("canIce");
        ForestryItem.refractoryWater = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryWater", 13075), 23).b("refractoryWater");
        ForestryItem.refractoryBiomass = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryBiomass", 13076), 39).b("refractoryBiomass");
        ForestryItem.refractoryBiofuel = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryBiofuel", 13077), 55).b("refractoryBiofuel");
        ForestryItem.refractoryOil = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryOil", 13078), 103).b("refractoryOil");
        ForestryItem.refractoryFuel = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryFuel", 13079), 119).b("refractoryFuel");
        ForestryItem.refractoryLava = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryLava", 13071), 135).b("refractoryLava");
        ForestryItem.refractorySeedOil = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractorySeedOil", 13080), 151).b("refractorySeedOil");
        ForestryItem.refractoryHoney = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryHoney", 13081), 167).setDrink(2, 0.2f).b("refractoryHoney");
        ForestryItem.refractoryJuice = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryJuice", 13082), 183).setDrink(2, 0.2f).b("refractoryJuice");
        ForestryItem.refractoryIce = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryIce", 13122), 199).b("refractoryIce");
        ForestryItem.liquidMilk = new ItemLiquids(Config.getOrCreateItemIdProperty("liquidMilk", 5016)).b("liquidMilk").c(15);
        ForestryItem.liquidBiofuel = new ItemLiquids(Config.getOrCreateItemIdProperty("bioFuel", 5013)).b("bioFuel").c(12);
        ForestryItem.liquidBiomass = new ItemLiquids(Config.getOrCreateItemIdProperty("bioMass", 5014)).b("bioMass").c(13);
        ForestryItem.liquidSeedOil = new ItemLiquids(Config.getOrCreateItemIdProperty("liquidSeedOil", 13057)).b("liquidSeedOil").c(74);
        ForestryItem.liquidJuice = new ItemLiquids(Config.getOrCreateItemIdProperty("appleJuice", 13058)).b("appleJuice").c(75);
        ForestryItem.liquidHoney = new ItemLiquids(Config.getOrCreateItemIdProperty("liquidHoney", 13059)).b("liquidHoney").c(76);
        ForestryItem.liquidMead = new ItemLiquids(Config.getOrCreateItemIdProperty("liquidMead", 13109)).b("liquidMead").c(77);
        ForestryItem.liquidGlass = new ItemLiquids(Config.getOrCreateItemIdProperty("liquidGlass", 13115)).b("liquidGlass").c(49);
        ForestryItem.liquidIce = new ItemLiquids(Config.getOrCreateItemIdProperty("liquidIce", 13119)).b("liquidIce").c(73);
        ForestryItem.cratedWood = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedWood", 13500), new ur(amq.M)).b("cratedWood").c(1);
        ForestryItem.cratedCobblestone = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedCobblestone", 13501), new ur(amq.z)).b("cratedCobblestone").c(2);
        ForestryItem.cratedDirt = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedDirt", 13502), new ur(amq.y)).b("cratedDirt").c(3);
        ForestryItem.cratedStone = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedStone", 13503), new ur(amq.w)).b("cratedStone").c(4);
        ForestryItem.cratedBrick = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedBrick", 13504), new ur(amq.ao)).b("cratedBrick").c(5);
        ForestryItem.cratedCacti = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedCacti", 13505), new ur(amq.aY)).b("cratedCacti").c(6);
        ForestryItem.cratedSand = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedSand", 13506), new ur(amq.H)).b("cratedSand").c(7);
        ForestryItem.cratedObsidian = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedObsidian", 13507), new ur(amq.as)).b("cratedObsidian").c(8);
        ForestryItem.cratedNetherrack = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedNetherrack", 13508), new ur(amq.be)).b("cratedNetherrack").c(9);
        ForestryItem.cratedSoulsand = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedSoulsand", 13509), new ur(amq.bf)).b("cratedSoulsand").c(10);
        ForestryItem.cratedSandstone = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedSandstone", 13510), new ur(amq.T)).b("cratedSandstone").c(11);
        ForestryItem.cratedBogearth = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedBogearth", 13511), new ur(ForestryBlock.soil, 1, 1)).b("cratedBogearth").c(12);
        ForestryItem.cratedHumus = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedHumus", 13512), new ur(ForestryBlock.soil, 1, 0)).b("cratedHumus").c(13);
        ForestryItem.cratedNetherbrick = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedNetherbrick", 13513), new ur(amq.bD)).b("cratedNetherbrick").c(14);
        ForestryItem.cratedPeat = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedPeat", 13514), new ur(ForestryItem.peat)).b("cratedPeat").c(17);
        ForestryItem.cratedApatite = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedApatite", 13515), new ur(ForestryItem.apatite)).b("cratedApatite").c(18);
        ForestryItem.cratedFertilizer = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedFertilizer", 13516), new ur(ForestryItem.fertilizerCompound)).b("cratedFertilizer").c(19);
        ForestryItem.cratedTin = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedTin", 13517), ForestryItem.ingotTin).b("cratedTin").c(20);
        ForestryItem.cratedCopper = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedCopper", 13518), ForestryItem.ingotCopper).b("cratedCopper").c(21);
        ForestryItem.cratedBronze = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedBronze", 13519), ForestryItem.ingotBronze).b("cratedBronze").c(22);
        ForestryItem.cratedWheat = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedWheat", 13520), new ur(up.T)).b("cratedWheat").c(23);
        ForestryItem.cratedMycelium = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedMycelium", 13521), new ur((amq)amq.bB)).b("cratedMycelium").c(15);
        ForestryItem.cratedMulch = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedMulch", 13522), new ur(ForestryItem.mulch)).b("cratedMulch").c(24);
        ForestryItem.cratedSilver = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedSilver", 13523)).b("cratedSilver").c(25);
        ForestryItem.cratedBrass = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedBrass", 13524)).b("cratedBrass").c(26);
        ForestryItem.cratedNikolite = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedNikolite", 13525)).b("cratedNikolite").c(27);
        ForestryItem.cratedCookies = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedCookies", 13526), new ur(up.bc)).b("cratedCookies").c(28);
        ForestryItem.cratedRedstone = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedRedstone", 13534), new ur(up.aC)).b("cratedRedstone").c(36);
        ForestryItem.cratedLapis = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedLapis", 13535), new ur(up.aW, 1, 4)).b("cratedLapis").c(37);
        ForestryItem.cratedReeds = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedReeds", 13536), new ur(up.aJ)).b("cratedReeds").c(38);
        ForestryItem.cratedClay = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedClay", 13537), new ur(up.aI)).b("cratedClay").c(39);
        ForestryItem.cratedGlowstone = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedGlowstone", 13538), new ur(up.aT)).b("cratedGlowstone").c(40);
        ForestryItem.cratedApples = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedApples", 13539), new ur(up.j)).b("cratedApples").c(41);
        ForestryItem.cratedNetherwart = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedNetherwart", 13540), new ur(up.br)).b("cratedNetherwart").c(42);
        ForestryItem.cratedResin = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedResin", 13541)).b("cratedResin").c(43);
        ForestryItem.cratedRubber = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedRubber", 13542)).b("cratedRubber").c(44);
        ForestryItem.cratedScrap = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedScrap", 13543)).b("cratedScrap").c(45);
        ForestryItem.cratedUUM = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedUUM", 13544)).b("cratedUUM").c(46);
        ForestryItem.cratedPhosphor = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedPhosphor", 13550), new ur(ForestryItem.phosphor)).b("cratedPhosphor").c(52);
        ForestryItem.cratedAsh = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedAsh", 13551), new ur(ForestryItem.ash)).b("cratedAsh").c(53);
        ForestryItem.cratedCharcoal = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedCharcoal", 13552), new ur(up.m, 1, 1)).b("cratedCharcoal").c(54);
        ForestryItem.cratedGravel = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedGravel", 13553), new ur(amq.I)).b("cratedGravel").c(55);
        ForestryItem.cratedCoal = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedCoal", 13554), new ur(up.m, 1, 0)).b("cratedCoal").c(54);
        ForestryItem.cratedSeeds = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedSeeds", 13555), new ur(up.S)).b("cratedSeeds").c(56);
        ForestryItem.cratedSaplings = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedSaplings", 13556), new ur(amq.B)).b("cratedSaplings").c(57);
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerCrates() {
    }

    @Override
    protected void registerRecipes() {
        if (Config.craftingBronzeEnabled) {
            Proxies.common.addRecipe(new ur(ForestryItem.ingotBronze.c, 4, ForestryItem.ingotBronze.j()), new Object[]{"##", "#X", Character.valueOf('#'), "ingotCopper", Character.valueOf('X'), "ingotTin"});
        }
        Proxies.common.addRecipe(new ur(ForestryItem.sturdyCasing, 1), new Object[]{"###", "# #", "###", Character.valueOf('#'), "ingotBronze"});
        Proxies.common.addRecipe(GameMode.getGameMode().getRecipeCanOutput(), new Object[]{" # ", "# #", Character.valueOf('#'), "ingotTin"});
        if (PluginBuildCraft.stoneGear != null) {
            Proxies.common.addRecipe(new ur(ForestryItem.gearBronze, 1), new Object[]{" # ", "#Y#", " # ", Character.valueOf('#'), "ingotBronze", Character.valueOf('Y'), PluginBuildCraft.stoneGear});
            Proxies.common.addRecipe(new ur(ForestryItem.gearCopper, 1), new Object[]{" # ", "#Y#", " # ", Character.valueOf('#'), "ingotCopper", Character.valueOf('Y'), PluginBuildCraft.stoneGear});
            Proxies.common.addRecipe(new ur(ForestryItem.gearTin, 1), new Object[]{" # ", "#Y#", " # ", Character.valueOf('#'), "ingotTin", Character.valueOf('Y'), PluginBuildCraft.stoneGear});
        } else {
            Proxies.common.addRecipe(new ur(ForestryItem.gearBronze, 1), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "ingotCopper"});
            Proxies.common.addRecipe(new ur(ForestryItem.gearCopper, 1), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), "ingotCopper", Character.valueOf('X'), "ingotCopper"});
            Proxies.common.addRecipe(new ur(ForestryItem.gearTin, 1), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), "ingotTin", Character.valueOf('X'), "ingotCopper"});
        }
        Proxies.common.addRecipe(new ur(ForestryItem.bronzePickaxe), new Object[]{" X ", " X ", "###", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood"});
        Proxies.common.addRecipe(new ur(ForestryItem.bronzeShovel), new Object[]{" X ", " X ", " # ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood"});
        Proxies.common.addShapelessRecipe(new ur(ForestryItem.kitPickaxe), new Object[]{ForestryItem.bronzePickaxe, ForestryItem.carton});
        Proxies.common.addShapelessRecipe(new ur(ForestryItem.kitShovel), new Object[]{ForestryItem.bronzeShovel, ForestryItem.carton});
        Proxies.common.addRecipe(new ur(ForestryItem.wrench, 1), new Object[]{"# #", " # ", " # ", Character.valueOf('#'), "ingotBronze"});
        if (GameMode.getGameMode().getRecipeCompostOutputWheat().a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getRecipeCompostOutputWheat(), new Object[]{" X ", "X#X", " X ", Character.valueOf('#'), amq.y, Character.valueOf('X'), up.T});
        }
        if (GameMode.getGameMode().getRecipeCompostOutputAsh().a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getRecipeCompostOutputAsh(), new Object[]{" X ", "X#X", " X ", Character.valueOf('#'), amq.y, Character.valueOf('X'), "dustAsh"});
        }
        if (GameMode.getGameMode().getRecipeFertilizerOutputApatite().a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getRecipeFertilizerOutputApatite(), new Object[]{" # ", " X ", " # ", Character.valueOf('#'), amq.H, Character.valueOf('X'), ForestryItem.apatite});
        }
        if (GameMode.getGameMode().getRecipeFertilizerOutputAsh().a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getRecipeFertilizerOutputAsh(), new Object[]{"###", "#X#", "###", Character.valueOf('#'), "dustAsh", Character.valueOf('X'), ForestryItem.apatite});
        }
        if (GameMode.getGameMode().getRecipeHumusOutputCompost().a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getRecipeHumusOutputCompost(), new Object[]{"###", "#X#", "###", Character.valueOf('#'), amq.y, Character.valueOf('X'), ForestryItem.fertilizerBio});
        }
        if (GameMode.getGameMode().getRecipeHumusOutputFertilizer().a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getRecipeHumusOutputFertilizer(), new Object[]{"###", "#X#", "###", Character.valueOf('#'), amq.y, Character.valueOf('X'), ForestryItem.fertilizerCompound});
        }
        if (GameMode.getGameMode().getRecipeBogEarthOutputBucket().a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getRecipeBogEarthOutputBucket(), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), amq.y, Character.valueOf('X'), up.ax, Character.valueOf('Y'), amq.H});
        }
        if (GameMode.getGameMode().getRecipeBogEarthOutputCans().a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getRecipeBogEarthOutputCans(), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), amq.y, Character.valueOf('X'), ForestryItem.canWater, Character.valueOf('Y'), amq.H});
            Proxies.common.addRecipe(GameMode.getGameMode().getRecipeBogEarthOutputCans(), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), amq.y, Character.valueOf('X'), ForestryItem.waxCapsuleWater, Character.valueOf('Y'), amq.H});
            Proxies.common.addRecipe(GameMode.getGameMode().getRecipeBogEarthOutputCans(), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), amq.y, Character.valueOf('X'), ForestryItem.refractoryWater, Character.valueOf('Y'), amq.H});
        }
        Proxies.common.addRecipe(new ur(ForestryItem.vialCatalyst, 3), new Object[]{"###", "YXY", Character.valueOf('#'), ForestryItem.waxCapsule, Character.valueOf('X'), up.aX, Character.valueOf('Y'), ForestryItem.fertilizerCompound});
        Proxies.common.addRecipe(new ur(ForestryItem.vialCatalyst, 3), new Object[]{"###", "YXY", Character.valueOf('#'), ForestryItem.canEmpty, Character.valueOf('X'), up.aX, Character.valueOf('Y'), ForestryItem.fertilizerCompound});
        Proxies.common.addRecipe(new ur(up.K), new Object[]{"#", "#", "#", Character.valueOf('#'), new ur(ForestryItem.craftingMaterial, 1, 2)});
        Proxies.common.addRecipe(new ur(ForestryItem.pipette), new Object[]{"  #", " X ", "X  ", Character.valueOf('X'), amq.bt, Character.valueOf('#'), new ur(amq.ae, 1, -1)});
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }

    @Override
    public y[] getConsoleCommands() {
        return new y[]{new CommandForestry()};
    }

    public int getBurnTime(ur fuel) {
        if (fuel != null && fuel.c == ForestryItem.peat.cj) {
            return 2000;
        }
        if (fuel != null && fuel.c == ForestryItem.bituminousPeat.cj) {
            return 4200;
        }
        return 0;
    }

    @Override
    public boolean processIMCMessage(FMLInterModComms.IMCMessage message) {
        if (message.key.equals("securityViolation")) {
            Config.invalidFingerprint = true;
        }
        return false;
    }

    public static MachinePackage getAnalyzerPackage() {
        MachinePackage pack = null;
        ArrayList<CraftingIngredients> recipes = new ArrayList<CraftingIngredients>();
        if (ForestryItem.beealyzer != null) {
            recipes.add(new CraftingIngredients(1, new Object[]{"XTX", " Y ", "X X", Character.valueOf('Y'), ForestryItem.sturdyCasing, Character.valueOf('T'), ForestryItem.beealyzer, Character.valueOf('X'), "ingotBronze"}));
        }
        if (ForestryItem.treealyzer != null) {
            recipes.add(new CraftingIngredients(1, new Object[]{"XTX", " Y ", "X X", Character.valueOf('Y'), ForestryItem.sturdyCasing, Character.valueOf('T'), ForestryItem.treealyzer, Character.valueOf('X'), "ingotBronze"}));
        }
        if (recipes.size() > 0) {
            pack = new MachinePackage((MachineFactory)new MachineAnalyzer.Factory(), "Analyzer", PluginForestryApiculture.proxy.getRendererAnalyzer("/gfx/forestry/blocks/analyzer_"), recipes.toArray(new CraftingIngredients[0]));
            pack.energyConfig = new EnergyConfiguration(0, 0, 0, 0, 0);
        }
        return pack;
    }

    private void verify$Others() {
        ArrayList<Cert.Prop> certs = new ArrayList<Cert.Prop>();
        certs.add(new Cert.Prop(new String(new byte[]{100, 101, 48, 52, 49, 102, 57, 102, 54, 49, 56, 55, 100, 101, 98, 98, 99, 55, 55, 48, 51, 52, 97, 51, 52, 52, 49, 51, 52, 48, 53, 51, 50, 55, 55, 97, 97, 51, 98, 48})){

            @Override
            protected String getCoreName() {
                return "ic2.core.IC2";
            }
        });
        certs.add(new Cert.Prop(new String(new byte[]{97, 48, 99, 50, 53, 53, 97, 99, 53, 48, 49, 98, 50, 55, 52, 57, 53, 51, 55, 100, 53, 56, 50, 52, 98, 98, 48, 102, 48, 53, 56, 56, 98, 102, 48, 51, 50, 48, 102, 97})){

            @Override
            protected String getCoreName() {
                return "railcraft.common.core.Railcraft";
            }
        });
        for (Cert.Prop prop : certs) {
            prop.verify();
        }
    }
}

