/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IOreDictionaryHandler;
import forestry.api.core.ISaveEventHandler;
import forestry.api.core.PluginInfo;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IClassification;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.IBackpackDefinition;
import forestry.arboriculture.CommandSpawnForest;
import forestry.arboriculture.CommandSpawnTree;
import forestry.arboriculture.EventHandlerArboriculture;
import forestry.arboriculture.FruitProviderNone;
import forestry.arboriculture.FruitProviderRandom;
import forestry.arboriculture.FruitProviderRipening;
import forestry.arboriculture.GuiHandlerArboriculture;
import forestry.arboriculture.WoodType;
import forestry.arboriculture.gadgets.BlockArbFence;
import forestry.arboriculture.gadgets.BlockArbStairs;
import forestry.arboriculture.gadgets.BlockLeaves;
import forestry.arboriculture.gadgets.BlockLog;
import forestry.arboriculture.gadgets.BlockPlanks;
import forestry.arboriculture.gadgets.BlockSapling;
import forestry.arboriculture.gadgets.BlockSlab;
import forestry.arboriculture.gadgets.TileLeaves;
import forestry.arboriculture.gadgets.TileSapling;
import forestry.arboriculture.gadgets.TileStairs;
import forestry.arboriculture.genetics.AlleleFruit;
import forestry.arboriculture.genetics.AlleleGrowth;
import forestry.arboriculture.genetics.AlleleLeafEffectNone;
import forestry.arboriculture.genetics.AlleleTreeSpecies;
import forestry.arboriculture.genetics.BranchTrees;
import forestry.arboriculture.genetics.BreedingManager;
import forestry.arboriculture.genetics.GrowthProvider;
import forestry.arboriculture.genetics.GrowthProviderTropical;
import forestry.arboriculture.genetics.Mutation;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.genetics.TreeHelper;
import forestry.arboriculture.genetics.TreeTemplates;
import forestry.arboriculture.items.ItemGermlingGE;
import forestry.arboriculture.items.ItemGrafter;
import forestry.arboriculture.items.ItemStairs;
import forestry.arboriculture.items.ItemTreealyzer;
import forestry.arboriculture.items.ItemWoodBlock;
import forestry.arboriculture.proxy.ProxyArboriculture;
import forestry.arboriculture.worldgen.WorldGenAcacia;
import forestry.arboriculture.worldgen.WorldGenBalsa;
import forestry.arboriculture.worldgen.WorldGenBaobab;
import forestry.arboriculture.worldgen.WorldGenBirch;
import forestry.arboriculture.worldgen.WorldGenCherry;
import forestry.arboriculture.worldgen.WorldGenChestnut;
import forestry.arboriculture.worldgen.WorldGenEbony;
import forestry.arboriculture.worldgen.WorldGenGreenheart;
import forestry.arboriculture.worldgen.WorldGenJungle;
import forestry.arboriculture.worldgen.WorldGenKapok;
import forestry.arboriculture.worldgen.WorldGenLarch;
import forestry.arboriculture.worldgen.WorldGenLime;
import forestry.arboriculture.worldgen.WorldGenMahogany;
import forestry.arboriculture.worldgen.WorldGenOak;
import forestry.arboriculture.worldgen.WorldGenPine;
import forestry.arboriculture.worldgen.WorldGenSequoia;
import forestry.arboriculture.worldgen.WorldGenSpruce;
import forestry.arboriculture.worldgen.WorldGenTeak;
import forestry.arboriculture.worldgen.WorldGenWalnut;
import forestry.arboriculture.worldgen.WorldGenWenge;
import forestry.arboriculture.worldgen.WorldGenWillow;
import forestry.core.GameMode;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.Allele;
import forestry.core.genetics.FruitFamily;
import forestry.core.items.ItemForestryBlock;
import forestry.core.items.ItemFruit;
import forestry.core.proxy.Proxies;
import forestry.core.utils.RecipeUtil;
import forestry.plugins.NativePlugin;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.OreDictionary;

@PluginInfo(pluginID="Arboriculture", name="Arboriculture", author="Binnie & SirSengir", url="http://forestry.sengir.net/", description="Adds additional tree species and products.")
public class PluginForestryArboriculture
extends NativePlugin
implements IFuelHandler {
    @SidedProxy(clientSide="forestry.arboriculture.proxy.ClientProxyArboriculture", serverSide="forestry.arboriculture.proxy.ProxyArboriculture")
    public static ProxyArboriculture proxy;
    public static int modelIdSaplings;
    public static int modelIdLeaves;
    public static int modelIdFences;

    @Override
    public boolean isAvailable() {
        return !Config.disableArboriculture;
    }

    @Override
    public String getDescription() {
        return "Arboriculture";
    }

    @Override
    public void preInit() {
        int i;
        super.preInit();
        ForestryBlock.log1 = new BlockLog(Config.getOrCreateBlockIdProperty("log1", 1388), BlockLog.LogCat.CAT0).b("for.log1");
        up.e[ForestryBlock.log1.cm] = null;
        up.e[ForestryBlock.log1.cm] = new ItemWoodBlock(ForestryBlock.log1.cm - 256, "for.log1");
        MinecraftForge.setBlockHarvestLevel((amq)ForestryBlock.log1, (String)"axe", (int)0);
        for (i = 0; i < 4; ++i) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (String)(ForestryBlock.log1.cm + "@" + i));
        }
        ForestryBlock.log2 = new BlockLog(Config.getOrCreateBlockIdProperty("log2", 1389), BlockLog.LogCat.CAT1).b("for.log2");
        up.e[ForestryBlock.log2.cm] = null;
        up.e[ForestryBlock.log2.cm] = new ItemWoodBlock(ForestryBlock.log2.cm - 256, "for.log2");
        MinecraftForge.setBlockHarvestLevel((amq)ForestryBlock.log2, (String)"axe", (int)0);
        for (i = 0; i < 4; ++i) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (String)(ForestryBlock.log2.cm + "@" + i));
        }
        ForestryBlock.log3 = new BlockLog(Config.getOrCreateBlockIdProperty("log3", 1390), BlockLog.LogCat.CAT2).b("for.log3");
        up.e[ForestryBlock.log3.cm] = null;
        up.e[ForestryBlock.log3.cm] = new ItemWoodBlock(ForestryBlock.log3.cm - 256, "for.log3");
        MinecraftForge.setBlockHarvestLevel((amq)ForestryBlock.log3, (String)"axe", (int)0);
        for (i = 0; i < 4; ++i) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (String)(ForestryBlock.log3.cm + "@" + i));
        }
        ForestryBlock.log4 = new BlockLog(Config.getOrCreateBlockIdProperty("log4", 1391), BlockLog.LogCat.CAT3).b("for.log4");
        up.e[ForestryBlock.log4.cm] = null;
        up.e[ForestryBlock.log4.cm] = new ItemWoodBlock(ForestryBlock.log4.cm - 256, "for.log4");
        MinecraftForge.setBlockHarvestLevel((amq)ForestryBlock.log4, (String)"axe", (int)0);
        for (i = 0; i < 4; ++i) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (String)(ForestryBlock.log4.cm + "@" + i));
        }
        OreDictionary.registerOre((String)"logWood", (ur)new ur(ForestryBlock.log1, 1, -1));
        OreDictionary.registerOre((String)"logWood", (ur)new ur(ForestryBlock.log2, 1, -1));
        OreDictionary.registerOre((String)"logWood", (ur)new ur(ForestryBlock.log3, 1, -1));
        OreDictionary.registerOre((String)"logWood", (ur)new ur(ForestryBlock.log4, 1, -1));
        wj.a().a(ForestryBlock.log1.cm, new ur(up.m, 1, 1), 0.15f);
        wj.a().a(ForestryBlock.log2.cm, new ur(up.m, 1, 1), 0.15f);
        wj.a().a(ForestryBlock.log3.cm, new ur(up.m, 1, 1), 0.15f);
        wj.a().a(ForestryBlock.log4.cm, new ur(up.m, 1, 1), 0.15f);
        ForestryBlock.planks = new BlockPlanks(Config.getOrCreateBlockIdProperty("planks", 1380)).b("for.planks");
        up.e[ForestryBlock.planks.cm] = null;
        up.e[ForestryBlock.planks.cm] = new ItemWoodBlock(ForestryBlock.planks.cm - 256, "for.planks");
        MinecraftForge.setBlockHarvestLevel((amq)ForestryBlock.planks, (String)"axe", (int)0);
        OreDictionary.registerOre((String)"plankWood", (ur)new ur(ForestryBlock.planks, 1, -1));
        for (i = 0; i < 16; ++i) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (String)(ForestryBlock.planks.cm + "@" + i));
        }
        ForestryBlock.slabs1 = new BlockSlab(Config.getOrCreateBlockIdProperty("slabs1", 1386), BlockSlab.SlabCat.CAT_0).b("for.slabs1");
        up.e[ForestryBlock.slabs1.cm] = null;
        up.e[ForestryBlock.slabs1.cm] = new ItemWoodBlock(ForestryBlock.slabs1.cm - 256, "for.slabs1");
        MinecraftForge.setBlockHarvestLevel((amq)ForestryBlock.slabs1, (String)"axe", (int)0);
        ForestryBlock.slabs2 = new BlockSlab(Config.getOrCreateBlockIdProperty("slabs2", 1387), BlockSlab.SlabCat.CAT_1).b("for.slabs2");
        up.e[ForestryBlock.slabs2.cm] = null;
        up.e[ForestryBlock.slabs2.cm] = new ItemWoodBlock(ForestryBlock.slabs2.cm - 256, "for.slabs2");
        MinecraftForge.setBlockHarvestLevel((amq)ForestryBlock.slabs2, (String)"axe", (int)0);
        OreDictionary.registerOre((String)"slabWood", (ur)new ur(ForestryBlock.slabs1, 1, -1));
        OreDictionary.registerOre((String)"slabWood", (ur)new ur(ForestryBlock.slabs2, 1, -1));
        ForestryBlock.fences = new BlockArbFence(Config.getOrCreateBlockIdProperty("fences", 1394)).b("for.fences");
        up.e[ForestryBlock.fences.cm] = null;
        up.e[ForestryBlock.fences.cm] = new ItemWoodBlock(ForestryBlock.fences.cm - 256, "for.fences");
        MinecraftForge.setBlockHarvestLevel((amq)ForestryBlock.fences, (String)"axe", (int)0);
        ForestryBlock.stairs = new BlockArbStairs(Config.getOrCreateBlockIdProperty("stairs", 1396), ForestryBlock.planks, 0).b("for.stairs");
        up.e[ForestryBlock.stairs.cm] = null;
        up.e[ForestryBlock.stairs.cm] = new ItemStairs(ForestryBlock.stairs.cm - 256, "for.stairs");
        MinecraftForge.setBlockHarvestLevel((amq)ForestryBlock.stairs, (String)"axe", (int)0);
        ForestryBlock.saplingGE = new BlockSapling(Config.getOrCreateBlockIdProperty("saplingGE", 1392)).b("saplingGE");
        up.e[ForestryBlock.saplingGE.cm] = null;
        up.e[ForestryBlock.saplingGE.cm] = new ItemForestryBlock(ForestryBlock.saplingGE.cm - 256, "saplingGE");
        ForestryBlock.leaves = new BlockLeaves(Config.getOrCreateBlockIdProperty("leaves", 1393)).b("leaves");
        up.e[ForestryBlock.leaves.cm] = null;
        up.e[ForestryBlock.leaves.cm] = new ItemForestryBlock(ForestryBlock.leaves.cm - 256, "leaves");
        GameRegistry.registerTileEntity(TileSapling.class, (String)"forestry.Sapling");
        GameRegistry.registerTileEntity(TileLeaves.class, (String)"forestry.Leaves");
        GameRegistry.registerTileEntity(TileStairs.class, (String)"forestry.Stairs");
        TreeManager.treeInterface = new TreeHelper();
        TreeManager.breedingManager = new BreedingManager();
        proxy.initializeRendering();
    }

    @Override
    public void doInit() {
        super.doInit();
        proxy.addLocalizations();
        this.createAlleles();
        this.createMutations();
        this.registerTemplates();
        this.registerErsatzGenomes();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerArboriculture());
    }

    @Override
    protected void registerPackages() {
    }

    @Override
    protected void registerItems() {
        ForestryItem.sapling = new ItemGermlingGE(Config.getOrCreateItemIdProperty("sapling", 13128), EnumGermlingType.SAPLING);
        OreDictionary.registerOre((String)"treeSapling", (ur)new ur(ForestryItem.sapling, 1, -1));
        ForestryItem.treealyzer = new ItemTreealyzer(Config.getOrCreateItemIdProperty("treealyzer", 13129)).b("treealyzer").c(81);
        ForestryItem.grafter = new ItemGrafter(Config.getOrCreateItemIdProperty("grafter", 13131)).b("grafter").c(63);
    }

    @Override
    protected void registerBackpackItems() {
        if (BackpackManager.backpackItems == null) {
            return;
        }
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ur(ForestryBlock.log1, 1, -1));
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ur(ForestryBlock.log2, 1, -1));
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ur(ForestryBlock.log3, 1, -1));
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ur(ForestryBlock.log4, 1, -1));
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ur(ForestryItem.sapling, 1, -1));
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ur(ForestryItem.fruits, 1, -1));
    }

    @Override
    protected void registerCrates() {
    }

    @Override
    protected void registerRecipes() {
        int i;
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(new ur(ForestryBlock.planks, 4, i), new Object[]{new ur(ForestryBlock.log1, 1, i)});
        }
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(new ur(ForestryBlock.planks, 4, 4 + i), new Object[]{new ur(ForestryBlock.log2, 1, i)});
        }
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(new ur(ForestryBlock.planks, 4, 8 + i), new Object[]{new ur(ForestryBlock.log3, 1, i)});
        }
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(new ur(ForestryBlock.planks, 4, 12 + i), new Object[]{new ur(ForestryBlock.log4, 1, i)});
        }
        for (i = 0; i < 8; ++i) {
            Proxies.common.addRecipe(new ur(ForestryBlock.slabs1, 6, i), new Object[]{"###", Character.valueOf('#'), new ur(ForestryBlock.planks, 1, i)});
        }
        for (i = 0; i < 8; ++i) {
            Proxies.common.addRecipe(new ur(ForestryBlock.slabs2, 6, i), new Object[]{"###", Character.valueOf('#'), new ur(ForestryBlock.planks, 1, 8 + i)});
        }
        for (i = 0; i < 16; ++i) {
            Proxies.common.addRecipe(new ur(ForestryBlock.fences, 4, i), new Object[]{"###", "# #", Character.valueOf('#'), new ur(ForestryBlock.planks, 1, i)});
        }
        RecipeManagers.carpenterManager.addRecipe(100, new LiquidStack(amq.E.cm, 2000), null, new ur(ForestryItem.treealyzer), new Object[]{"X#X", "X#X", "RDR", Character.valueOf('#'), amq.bt, Character.valueOf('X'), "ingotCopper", Character.valueOf('R'), up.aC, Character.valueOf('D'), up.n});
        RecipeManagers.squeezerManager.addRecipe(10, new ur[]{new ur(ForestryItem.fruits, 1, ItemFruit.EnumFruit.CHERRY.ordinal())}, new LiquidStack(ForestryItem.liquidSeedOil, 3 * GameMode.getGameMode().getSqueezedLiquidPerSeed()), new ur(ForestryItem.mulch), 5);
        RecipeManagers.squeezerManager.addRecipe(10, new ur[]{new ur(ForestryItem.fruits, 1, ItemFruit.EnumFruit.WALNUT.ordinal())}, new LiquidStack(ForestryItem.liquidSeedOil, 10 * GameMode.getGameMode().getSqueezedLiquidPerSeed()), new ur(ForestryItem.mulch), 5);
        RecipeManagers.squeezerManager.addRecipe(10, new ur[]{new ur(ForestryItem.fruits, 1, ItemFruit.EnumFruit.CHESTNUT.ordinal())}, new LiquidStack(ForestryItem.liquidSeedOil, 12 * GameMode.getGameMode().getSqueezedLiquidPerSeed()), new ur(ForestryItem.mulch), 5);
        RecipeUtil.injectLeveledRecipe(new ur(ForestryItem.sapling), GameMode.getGameMode().getFermentedPerSapling(), new ur(ForestryItem.liquidBiomass));
        for (i = 0; i < 16; ++i) {
            WoodType type = WoodType.values()[i];
            bq compound = new bq("tag");
            type.saveToCompound(compound);
            ur stairs = new ur(ForestryBlock.stairs, 4, 0);
            stairs.d(compound);
            Proxies.common.addRecipe(stairs, new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new ur(ForestryBlock.planks, 1, i)});
        }
        Proxies.common.addRecipe(new ur(ForestryItem.grafter), new Object[]{"  B", " # ", "#  ", Character.valueOf('B'), "ingotBronze", Character.valueOf('#'), up.D});
    }

    private void createAlleles() {
        IClassification angiosperms = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.DIVISION, "angiosperms", "Angiosperms");
        AlleleManager.alleleRegistry.getClassification("kingdom.plantae").addMemberGroup(angiosperms);
        IClassification pinophyta = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.DIVISION, "pinophyta", "Pinophyta");
        AlleleManager.alleleRegistry.getClassification("kingdom.plantae").addMemberGroup(pinophyta);
        IClassification magnoliophyta = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.DIVISION, "magnoliophyta", "Magnoliophyta");
        AlleleManager.alleleRegistry.getClassification("kingdom.plantae").addMemberGroup(magnoliophyta);
        IClassification rosids = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "rosids", "Rosids");
        angiosperms.addMemberGroup(rosids);
        IClassification asterids = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "asterids", "Asterids");
        angiosperms.addMemberGroup(asterids);
        IClassification pinopsida = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "pinopsida", "Pinopsida");
        pinophyta.addMemberGroup(pinopsida);
        IClassification magnoliopsida = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "magnoliopsida", "Magnoliopsida");
        pinophyta.addMemberGroup(magnoliopsida);
        IClassification fabales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "fabales", "Fabales");
        rosids.addMemberGroup(fabales);
        IClassification rosales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "rosales", "Rosales");
        rosids.addMemberGroup(rosales);
        IClassification fagales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "fagales", "Fagales");
        rosids.addMemberGroup(fagales);
        IClassification malvales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "malvales", "Malvales");
        rosids.addMemberGroup(malvales);
        IClassification malpighiales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "malpighiales", "Malpighiales");
        rosids.addMemberGroup(malpighiales);
        IClassification ericales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "ericales", "Ericales");
        asterids.addMemberGroup(ericales);
        IClassification lamiales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "lamiales", "Lamiales");
        asterids.addMemberGroup(lamiales);
        IClassification pinales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "pinales", "Pinales");
        pinopsida.addMemberGroup(pinales);
        IClassification laurales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "laurales", "Laurales");
        rosids.addMemberGroup(laurales);
        IClassification betulaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "betulaceae", "Betulaceae");
        fagales.addMemberGroup(betulaceae);
        IClassification fagaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "fagaceae", "Fagaceae");
        fagales.addMemberGroup(fagaceae);
        IClassification juglandaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "juglandaceae", "Juglandaceae");
        fagales.addMemberGroup(juglandaceae);
        IClassification malvaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "malvaceae", "Malvaceae");
        malvales.addMemberGroup(malvaceae);
        IClassification dipterocarpaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "dipterocarpaceae", "Dipterocarpaceae");
        malvales.addMemberGroup(dipterocarpaceae);
        IClassification pinaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "pinaceae", "Pinaceae");
        pinales.addMemberGroup(pinaceae);
        IClassification cupressaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "cupressaceae", "Cupressaceae");
        pinales.addMemberGroup(cupressaceae);
        IClassification lamiaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "lamiaceae", "Lamiaceae");
        lamiales.addMemberGroup(lamiaceae);
        IClassification ebenaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "ebenaceae", "Ebenaceae");
        ericales.addMemberGroup(ebenaceae);
        IClassification fabaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "fabaceae", "Fabaceae");
        ericales.addMemberGroup(fabaceae);
        IClassification rosaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "rosaceae", "Rosaceae");
        rosales.addMemberGroup(rosaceae);
        IClassification salicaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "salicaceae", "Salicaceae");
        malpighiales.addMemberGroup(salicaceae);
        IClassification lauraceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "lauraceae", "Lauraceae");
        malpighiales.addMemberGroup(lauraceae);
        BranchTrees quercus = new BranchTrees("quercus", "Quercus");
        fagaceae.addMemberGroup(quercus);
        BranchTrees castanea = new BranchTrees("castanea", "Castanea");
        fagaceae.addMemberGroup(castanea);
        BranchTrees betula = new BranchTrees("betula", "Betula");
        betulaceae.addMemberGroup(betula);
        BranchTrees tilia = new BranchTrees("tilia", "Tilia");
        malvaceae.addMemberGroup(tilia);
        BranchTrees ceiba = new BranchTrees("ceiba", "Ceiba");
        malvaceae.addMemberGroup(ceiba);
        BranchTrees adansonia = new BranchTrees("adansonia", "Adansonia");
        malvaceae.addMemberGroup(adansonia);
        BranchTrees picea = new BranchTrees("picea", "Picea");
        pinaceae.addMemberGroup(picea);
        BranchTrees pinus = new BranchTrees("pinus", "Pinus");
        pinaceae.addMemberGroup(pinus);
        BranchTrees larix = new BranchTrees("larix", "Larix");
        pinaceae.addMemberGroup(larix);
        BranchTrees juglans = new BranchTrees("juglans", "Juglans");
        juglandaceae.addMemberGroup(juglans);
        BranchTrees sequoia = new BranchTrees("sequoia", "Sequoia");
        cupressaceae.addMemberGroup(sequoia);
        BranchTrees tectona = new BranchTrees("tectona", "Tectona");
        lamiaceae.addMemberGroup(tectona);
        BranchTrees diospyros = new BranchTrees("ebony", "Diospyros");
        ebenaceae.addMemberGroup(diospyros);
        BranchTrees shorea = new BranchTrees("mahogany", "Shorea");
        dipterocarpaceae.addMemberGroup(shorea);
        BranchTrees acacia = new BranchTrees("acacia", "Acacia");
        fabaceae.addMemberGroup(acacia);
        BranchTrees millettia = new BranchTrees("millettia", "Millettia");
        fabaceae.addMemberGroup(millettia);
        BranchTrees ochroma = new BranchTrees("ochroma", "Ochroma");
        malvaceae.addMemberGroup(ochroma);
        BranchTrees prunus = new BranchTrees("prunus", "Prunus");
        rosaceae.addMemberGroup(prunus);
        BranchTrees salix = new BranchTrees("salix", "Salix");
        salicaceae.addMemberGroup(salix);
        BranchTrees chlorocardium = new BranchTrees("chlorocardium", "Chlorocardium");
        salicaceae.addMemberGroup(chlorocardium);
        BranchTrees tropical = new BranchTrees("Tropical", "");
        FruitFamily prunes = new FruitFamily("prunes", "Prunus domestica");
        FruitFamily pomes = new FruitFamily("pomes", "Pomum");
        FruitFamily jungle = new FruitFamily("jungle", "Tropicus");
        FruitFamily nux = new FruitFamily("nuts", "Nux");
        Allele.treeOak = new AlleleTreeSpecies("treeOak", false, "Apple Oak", quercus, "robur", proxy.getFoliageColorBasic(), 5486232, WorldGenOak.class).addFruitFamily(pomes).setBodyType(0).setIsSecret();
        Allele.treeBirch = new AlleleTreeSpecies("treeBirch", false, "Silver Birch", betula, "pendula", proxy.getFoliageColorBirch(), 0xFEFF8F, WorldGenBirch.class).setBodyType(1).setIsSecret();
        Allele.treeLime = new AlleleTreeSpecies("treeLime", true, "Silver Lime", tilia, "tomentosa", 6201607, 6201743, WorldGenLime.class).addFruitFamily(nux).addFruitFamily(prunes).addFruitFamily(pomes).setBodyType(20);
        Allele.treeWalnut = new AlleleTreeSpecies("treeWalnut", true, "Common Walnut", juglans, "regia", 7965781, 11585096, WorldGenWalnut.class).addFruitFamily(nux).addFruitFamily(prunes).addFruitFamily(pomes).setGirth(2).setBodyType(24);
        Allele.treeChestnut = new AlleleTreeSpecies("treeChestnut", true, "Sweet Chestnut", castanea, "sativa", 6201607, 11585096, WorldGenChestnut.class).addFruitFamily(nux).addFruitFamily(prunes).addFruitFamily(pomes).setGirth(2).setBodyType(22);
        Allele.treeCherry = new AlleleTreeSpecies("treeCherry", true, "Hill Cherry", prunus, "serrulata", 15110618, 15089241, WorldGenCherry.class).addFruitFamily(prunes).addFruitFamily(pomes).setBodyType(19);
        Allele.treeSpruce = new AlleleTreeSpecies("treeSpruce", false, "Red Spruce", picea, "abies", proxy.getFoliageColorPine(), 5479698, WorldGenSpruce.class).setLeafIndices(49, 65, 49).setBodyType(2).setIsSecret();
        Allele.treeLarch = new AlleleTreeSpecies("treeLarch", true, "Mundane Larch", larix, "decidua", 6918032, 5675158, WorldGenLarch.class).setLeafIndices(49, 65, 49).setBodyType(16);
        Allele.treePine = new AlleleTreeSpecies("treePine", true, "Bull Pine", pinus, "sabiniana", 0xFEFF8F, 16767375, WorldGenPine.class).setLeafIndices(49, 65, 49).setBodyType(25);
        Allele.treeSequioa = new AlleleTreeSpecies("treeSequioa", false, "Sequoia", sequoia, "sempervirens", 4296305, 5675158, WorldGenSequoia.class).setLeafIndices(49, 65, 49).setGirth(3).setBodyType(17);
        Allele.treeJungle = new AlleleTreeSpecies("treeJungle", false, "Jungle", tropical, "tectona", proxy.getFoliageColorBasic(), 5479698, WorldGenJungle.class).addFruitFamily(jungle).setLeafIndices(50, 66, 50).setBodyType(3);
        Allele.treeTeak = new AlleleTreeSpecies("treeTeak", true, "Teak", tectona, "grandis", 0xFEFF8F, 16767375, WorldGenTeak.class).addFruitFamily(jungle).setLeafIndices(50, 66, 50).setBodyType(21);
        Allele.treeKapok = new AlleleTreeSpecies("treeKapok", true, "Kapok", ceiba, "pentandra", 9017467, 9022110, WorldGenKapok.class).addFruitFamily(jungle).addFruitFamily(prunes).setLeafIndices(50, 66, 50).setBodyType(28);
        Allele.treeEbony = new AlleleTreeSpecies("treeEbony", true, "Myrtle Ebony", diospyros, "pentamera", 10670666, 12898890, WorldGenEbony.class).addFruitFamily(jungle).addFruitFamily(prunes).setGirth(3).setLeafIndices(50, 66, 50).setBodyType(29);
        Allele.treeMahogany = new AlleleTreeSpecies("treeMahogony", true, "Yellow Meranti", shorea, "gibbosa", 9089364, 11120980, WorldGenMahogany.class).addFruitFamily(jungle).setGirth(2).setLeafIndices(50, 66, 50).setBodyType(30);
        Allele.treeAcacia = new AlleleTreeSpecies("treeAcacia", true, "Desert Acacia", acacia, "erioloba", 0x616101, 11776770, WorldGenAcacia.class).addFruitFamily(jungle).addFruitFamily(nux).setBodyType(23);
        Allele.treeBalsa = new AlleleTreeSpecies("treeBalsa", true, "Balsa", ochroma, "pyramidale", 5876736, 0xFEFF8F, WorldGenBalsa.class).addFruitFamily(jungle).addFruitFamily(nux).setBodyType(18);
        Allele.treeWenge = new AlleleTreeSpecies("treeWenge", true, "Wenge", millettia, "laurentii", 11379031, 11373143, WorldGenWenge.class).addFruitFamily(jungle).addFruitFamily(nux).setGirth(2).setBodyType(26);
        Allele.treeBaobab = new AlleleTreeSpecies("treeBaobab", true, "Grandidier's Baobab", adansonia, "digitata", 0xFEFF8F, 16767375, WorldGenBaobab.class).addFruitFamily(jungle).addFruitFamily(nux).setGirth(3).setBodyType(27);
        Allele.treeWillow = new AlleleTreeSpecies("treeWillow", true, "White Willow", salix, "alba", 10729637, 10729552, WorldGenWillow.class).addFruitFamily(nux).addFruitFamily(prunes).addFruitFamily(pomes).setLeafIndices(51, 67, 50).setBodyType(31);
        Allele.treeSipiri = new AlleleTreeSpecies("treeSipiri", true, "Sipiri", chlorocardium, "rodiei", 6785297, 7971189, WorldGenGreenheart.class).addFruitFamily(jungle).setBodyType(32);
        Allele.treePalm = new AlleleTreeSpecies("treePalm", true, "Palm", null, "Cocos nucifera", 0xFEFF8F, 5479698);
        Allele.treeBoojum = new AlleleTreeSpecies("treeBoojum", true, "Boojum", null, "Fouquieria columnaris", 0xFEFF8F, 5479698);
        Allele.fruitNone = new AlleleFruit("fruitNone", new FruitProviderNone());
        Allele.fruitApple = new AlleleFruit("fruitApple", new FruitProviderRandom("apple", pomes, new ur(up.j), 1.0f, 97).setColour(0xFF2E2E));
        Allele.fruitCocoa = new AlleleFruit("fruitCocoa", new FruitProviderRipening("cocoa", jungle, new ur(up.aW, 1, 3), 0.5f, 98).setColours(15522981, 12898890), true);
        Allele.fruitChestnut = new AlleleFruit("fruitChestnut", new FruitProviderRipening("chestnut", nux, new ur(ForestryItem.fruits, 1, ItemFruit.EnumFruit.CHESTNUT.ordinal()), 1.0f, 96).setRipeningPeriod(6).setColours(8336189, 12898890), true);
        Allele.fruitPalm = new AlleleFruit("fruitPalm", new FruitProviderNone());
        Allele.fruitWalnut = new AlleleFruit("fruitWalnut", new FruitProviderRipening("walnut", nux, new ur(ForestryItem.fruits, 1, ItemFruit.EnumFruit.WALNUT.ordinal()), 1.0f, 96).setRipeningPeriod(8).setColours(16491080, 12898890), true);
        Allele.fruitCherry = new AlleleFruit("fruitCherry", new FruitProviderRipening("cherry", prunes, new ur(ForestryItem.fruits, 1, ItemFruit.EnumFruit.CHERRY.ordinal()), 1.0f, 96).setColours(0xFF2E2E, 12898890), true);
        Allele.growthLightlevel = new AlleleGrowth("growthLightlevel", new GrowthProvider());
        Allele.growthAcacia = new AlleleGrowth("growthAcacia", new GrowthProvider());
        Allele.growthTropical = new AlleleGrowth("growthTropical", new GrowthProviderTropical());
        Allele.leavesNone = new AlleleLeafEffectNone("leavesNone");
    }

    private void registerTemplates() {
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getOakTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getBirchTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getSpruceTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getJungleTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getLimeTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getCherryTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getChestnutTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getWalnutTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getLarchTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getPineTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getSequoiaTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getBalsaTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getAcaciaTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getWengeTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getBaobabTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getTeakTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getKapokTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getEbonyTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getMahoganyTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getWillowTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getSipiriTemplate());
    }

    private void registerErsatzGenomes() {
        AlleleManager.ersatzSpecimen.put(new ur(amq.N.cm, 1, 0), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getOakTemplate())));
        AlleleManager.ersatzSpecimen.put(new ur(amq.N.cm, 1, 1), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getSpruceTemplate())));
        AlleleManager.ersatzSpecimen.put(new ur(amq.N.cm, 1, 2), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getBirchTemplate())));
        AlleleManager.ersatzSpecimen.put(new ur(amq.N.cm, 1, 3), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getJungleTemplate())));
        AlleleManager.ersatzSaplings.put(new ur(amq.B.cm, 1, 0), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getOakTemplate())));
        AlleleManager.ersatzSaplings.put(new ur(amq.B.cm, 1, 1), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getSpruceTemplate())));
        AlleleManager.ersatzSaplings.put(new ur(amq.B.cm, 1, 2), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getBirchTemplate())));
        AlleleManager.ersatzSaplings.put(new ur(amq.B.cm, 1, 3), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getJungleTemplate())));
    }

    private void createMutations() {
        TreeTemplates.limeA = new Mutation(Allele.treeBirch, Allele.treeOak, TreeTemplates.getLimeTemplate(), 15);
        TreeTemplates.cherryA = new Mutation(Allele.treeLime, Allele.treeOak, TreeTemplates.getCherryTemplate(), 10);
        TreeTemplates.cherryB = new Mutation(Allele.treeLime, Allele.treeBirch, TreeTemplates.getCherryTemplate(), 10);
        TreeTemplates.walnutA = new Mutation(Allele.treeLime, Allele.treeCherry, TreeTemplates.getWalnutTemplate(), 10);
        TreeTemplates.chestnutA = new Mutation(Allele.treeWalnut, Allele.treeLime, TreeTemplates.getChestnutTemplate(), 10);
        TreeTemplates.chestnutB = new Mutation(Allele.treeWalnut, Allele.treeCherry, TreeTemplates.getChestnutTemplate(), 10);
        TreeTemplates.larchA = new Mutation(Allele.treeSpruce, Allele.treeBirch, TreeTemplates.getLarchTemplate(), 15);
        TreeTemplates.larchB = new Mutation(Allele.treeSpruce, Allele.treeOak, TreeTemplates.getLarchTemplate(), 15);
        TreeTemplates.pineA = new Mutation(Allele.treeSpruce, Allele.treeLarch, TreeTemplates.getPineTemplate(), 10);
        TreeTemplates.sequoiaA = new Mutation(Allele.treeLarch, Allele.treePine, TreeTemplates.getSequoiaTemplate(), 5);
        TreeTemplates.teakA = new Mutation(Allele.treeLime, Allele.treeJungle, TreeTemplates.getTeakTemplate(), 10);
        TreeTemplates.kapokA = new Mutation(Allele.treeJungle, Allele.treeTeak, TreeTemplates.getKapokTemplate(), 10);
        TreeTemplates.ebonyA = new Mutation(Allele.treeKapok, Allele.treeTeak, TreeTemplates.getEbonyTemplate(), 10);
        TreeTemplates.mahoganyA = new Mutation(Allele.treeKapok, Allele.treeEbony, TreeTemplates.getMahoganyTemplate(), 10);
        TreeTemplates.balsaA = new Mutation(Allele.treeTeak, Allele.treeLime, TreeTemplates.getBalsaTemplate(), 10);
        TreeTemplates.acaciaA = new Mutation(Allele.treeTeak, Allele.treeBalsa, TreeTemplates.getAcaciaTemplate(), 10);
        TreeTemplates.wengeA = new Mutation(Allele.treeAcacia, Allele.treeBalsa, TreeTemplates.getWengeTemplate(), 10);
        TreeTemplates.baobabA = new Mutation(Allele.treeBalsa, Allele.treeWenge, TreeTemplates.getBaobabTemplate(), 10);
        TreeTemplates.willowA = new Mutation(Allele.treeOak, Allele.treeBirch, TreeTemplates.getWillowTemplate(), 10).setTemperatureRainfall(0.7f, 1.5f, 0.9f, 2.0f);
        TreeTemplates.willowB = new Mutation(Allele.treeOak, Allele.treeLime, TreeTemplates.getWillowTemplate(), 10).setTemperatureRainfall(0.7f, 1.5f, 0.9f, 2.0f);
        TreeTemplates.willowC = new Mutation(Allele.treeLime, Allele.treeBirch, TreeTemplates.getWillowTemplate(), 10).setTemperatureRainfall(0.7f, 1.5f, 0.9f, 2.0f);
        TreeTemplates.sipiriA = new Mutation(Allele.treeKapok, Allele.treeMahogany, TreeTemplates.getSipiriTemplate(), 10).setTemperatureRainfall(0.9f, 1.9f, 0.9f, 2.0f);
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerArboriculture();
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return null;
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }

    @Override
    public y[] getConsoleCommands() {
        return new y[]{new CommandSpawnTree(), new CommandSpawnForest()};
    }

    public int getBurnTime(ur fuel) {
        if (fuel != null && fuel.c == ForestryItem.sapling.cj) {
            return 100;
        }
        return 0;
    }
}

