/*
 * Decompiled with CFR 0.152.
 */
package forestry.pipes.gui;

import buildcraft.transport.Pipe;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IApiaristTracker;
import forestry.apiculture.items.ItemBeeGE;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.ItemGE;
import forestry.core.gui.GfxSlot;
import forestry.core.gui.GuiForestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import forestry.pipes.EnumFilterType;
import forestry.pipes.PipeLogicPropolis;
import forestry.pipes.gui.ContainerPropolisPipe;
import forestry.plugins.PluginPropolisPipe;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class GuiPropolisPipe
extends GuiForestry {
    PipeLogicPropolis pipeLogic;

    public GuiPropolisPipe(qx player, Pipe pipe) {
        super("/gfx/forestry/gui/analyzer.png", new ContainerPropolisPipe((la)player.bJ, pipe));
        this.pipeLogic = (PipeLogicPropolis)pipe.logic;
        if (!Proxies.common.isSimulating(pipe.worldObj)) {
            this.pipeLogic.requestFilterSet();
        }
        this.xSize = 175;
        this.ySize = 225;
        for (int i = 0; i < 6; ++i) {
            this.slotManager.add(new TypeFilterSlot(8, 18 + i * 18, ForgeDirection.values()[i], this.pipeLogic));
        }
        IApiaristTracker tracker = BeeManager.breedingManager.getApiaristTracker(player.p, player.bR);
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 2; ++k) {
                    this.slotManager.add(new SpeciesFilterSlot(tracker, 44 + j * 45 + k * 18, 18 + i * 18, ForgeDirection.values()[i], j, k, this.pipeLogic));
                }
            }
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        this.l.b("Apiarist's Pipe", 56, 6, 0x303030);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        this.drawBackground();
    }

    class SpeciesFilterSlot
    extends GfxSlot {
        IApiaristTracker tracker;
        ForgeDirection orientation;
        PipeLogicPropolis logic;
        int pattern;
        int allele;

        public SpeciesFilterSlot(IApiaristTracker tracker, int x2, int y2, ForgeDirection orientation, int pattern, int allele, PipeLogicPropolis logic) {
            super(GuiPropolisPipe.this.slotManager, x2, y2);
            this.tracker = tracker;
            this.orientation = orientation;
            this.pattern = pattern;
            this.allele = allele;
            this.logic = logic;
        }

        public IAlleleSpecies getSpecies() {
            return this.logic.getSpeciesFilter(this.orientation, this.pattern, this.allele);
        }

        public boolean isDefined() {
            IAlleleSpecies species = this.logic.getSpeciesFilter(this.orientation, this.pattern, this.allele);
            return species != null;
        }

        @Override
        public void draw(int startX, int startY) {
            if (!this.isDefined()) {
                return;
            }
            IAlleleSpecies species = this.logic.getSpeciesFilter(this.orientation, this.pattern, this.allele);
            int tex = ((GuiPropolisPipe)GuiPropolisPipe.this).f.o.b("/gfx/forestry/items/bees.png");
            GL11.glDisable((int)2896);
            ((GuiPropolisPipe)GuiPropolisPipe.this).f.o.b(tex);
            for (int i = 0; i < 3; ++i) {
                int iconIndex = ((ItemBeeGE)ForestryItem.beeDroneGE).getIconIndexFromSpecies(species, i);
                int color = ((ItemGE)ForestryItem.beeDroneGE).getColourFromSpecies(species, i);
                float colorR = (float)(color >> 16 & 0xFF) / 255.0f;
                float colorG = (float)(color >> 8 & 0xFF) / 255.0f;
                float colorB = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
                GuiPropolisPipe.this.b(startX + this.xPos, startY + this.yPos, iconIndex % 16 * 16, iconIndex / 16 * 16, 16, 16);
            }
            GL11.glEnable((int)2896);
        }

        @Override
        protected String getTooltip(qx player) {
            IAlleleSpecies species = this.logic.getSpeciesFilter(this.orientation, this.pattern, this.allele);
            if (species != null) {
                return species.getName();
            }
            return null;
        }

        @Override
        public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
            IAlleleBeeSpecies change;
            block7: {
                change = null;
                if (mouseButton == 1) {
                    change = null;
                } else if (this.getSpecies() == null) {
                    for (Map.Entry entry : AlleleManager.alleleRegistry.getRegisteredAlleles().entrySet()) {
                        if (!(entry.getValue() instanceof IAlleleBeeSpecies)) continue;
                        change = (IAlleleBeeSpecies)entry.getValue();
                        break;
                    }
                } else {
                    Iterator it = AlleleManager.alleleRegistry.getRegisteredAlleles().entrySet().iterator();
                    while (it.hasNext()) {
                        IAlleleBeeSpecies species;
                        Map.Entry entry = it.next();
                        if (!(entry.getValue() instanceof IAlleleBeeSpecies) || !(species = (IAlleleBeeSpecies)entry.getValue()).getUID().equals(this.getSpecies().getUID())) continue;
                        while (it.hasNext()) {
                            IAlleleBeeSpecies next;
                            Map.Entry entry2 = it.next();
                            if (!(entry2.getValue() instanceof IAlleleBeeSpecies) || (next = (IAlleleBeeSpecies)entry2.getValue()).isSecret() && !this.tracker.isDiscovered(next)) continue;
                            change = next;
                            break block7;
                        }
                        break;
                    }
                }
            }
            GuiPropolisPipe.this.pipeLogic.setSpeciesFilter(this.orientation, this.pattern, this.allele, change);
        }
    }

    class TypeFilterSlot
    extends GfxSlot {
        ForgeDirection orientation;
        PipeLogicPropolis logic;

        public TypeFilterSlot(int x2, int y2, ForgeDirection orientation, PipeLogicPropolis logic) {
            super(GuiPropolisPipe.this.slotManager, x2, y2);
            this.orientation = orientation;
            this.logic = logic;
        }

        public EnumFilterType getType() {
            return this.logic.getTypeFilter(this.orientation);
        }

        @Override
        public void draw(int startX, int startY) {
            EnumFilterType type = this.logic.getTypeFilter(this.orientation);
            int iconIndex = 0;
            if (type != null) {
                iconIndex = type.ordinal();
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int tex = ((GuiPropolisPipe)GuiPropolisPipe.this).f.o.b(PluginPropolisPipe.textureBees);
            ((GuiPropolisPipe)GuiPropolisPipe.this).f.o.b(tex);
            int textureRow = iconIndex >> 4;
            int textureColumn = iconIndex - 16 * textureRow;
            GuiPropolisPipe.this.b(startX + this.xPos, startY + this.yPos, 16 * textureColumn, 16 * textureRow, 16, 16);
        }

        @Override
        protected String getTooltip(qx player) {
            EnumFilterType type = this.logic.getTypeFilter(this.orientation);
            return StringUtil.localize("gui.pipe.filter." + type.toString().toLowerCase(Locale.ENGLISH));
        }

        @Override
        public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
            EnumFilterType change = mouseButton == 1 ? EnumFilterType.CLOSED : (this.getType().ordinal() < EnumFilterType.values().length - 1 ? EnumFilterType.values()[this.getType().ordinal() + 1] : EnumFilterType.CLOSED);
            GuiPropolisPipe.this.pipeLogic.setTypeFilter(this.orientation, change);
        }
    }
}

