/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.network;

import forestry.core.network.ForestryPacket;
import forestry.mail.EnumStationState;
import forestry.mail.TradeStationInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PacketTradeInfo
extends ForestryPacket {
    public TradeStationInfo tradeInfo;

    public PacketTradeInfo() {
    }

    public PacketTradeInfo(int id, TradeStationInfo info) {
        super(id);
        this.tradeInfo = info;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        if (this.tradeInfo == null) {
            data.writeShort(-1);
            return;
        }
        data.writeShort(0);
        data.writeUTF(this.tradeInfo.moniker);
        this.writeItemStack(this.tradeInfo.tradegood, data);
        data.writeShort(this.tradeInfo.required.length);
        for (int i = 0; i < this.tradeInfo.required.length; ++i) {
            this.writeItemStack(this.tradeInfo.required[i], data);
        }
        data.writeShort(this.tradeInfo.state.ordinal());
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        short isNotNull = data.readShort();
        if (isNotNull < 0) {
            return;
        }
        String moniker = data.readUTF();
        ur tradegood = this.readItemStack(data);
        ur[] required = new ur[data.readShort()];
        for (int i = 0; i < required.length; ++i) {
            required[i] = this.readItemStack(data);
        }
        this.tradeInfo = new TradeStationInfo(moniker, tradegood, required, EnumStationState.values()[data.readShort()]);
    }
}

