/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.core.EnumErrorCode;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.triggers.Trigger;
import forestry.core.utils.GenericInventoryAdapter;
import forestry.core.utils.StackUtils;
import forestry.mail.IStamps;
import forestry.mail.PostOffice;
import forestry.plugins.PluginForestryMail;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;

public class MachineTrader
extends Machine {
    @EntityNetData
    public String moniker = "";

    public MachineTrader(TileMachine tile) {
        super(tile);
    }

    @Override
    public String getName() {
        return "tile.mill.6";
    }

    @Override
    public void openGui(qx player, la tile) {
        if (this.isLinked()) {
            player.openGui(ForestryAPI.instance, GuiId.TraderGUI.ordinal(), this.tile.k, this.tile.l, this.tile.m, this.tile.n);
        } else {
            player.openGui(ForestryAPI.instance, GuiId.TraderNameGUI.ordinal(), this.tile.k, this.tile.l, this.tile.m, this.tile.n);
        }
    }

    @Override
    public void onRemoval() {
        if (this.isLinked()) {
            PostOffice.deleteTradeStation(this.tile.k, this.moniker);
        }
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        if (this.moniker != null) {
            nbttagcompound.a("MNK", this.moniker);
        }
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        if (nbttagcompound.b("MNK")) {
            this.moniker = nbttagcompound.i("MNK");
        }
    }

    @Override
    public void updateServerSide() {
        if (this.tile.k.G() % 40L * 10L != 0L) {
            return;
        }
        this.setErrorState(EnumErrorCode.OK);
        if (!this.hasPaperMin(0.0f) || !this.hasInputBufMin(0.0f)) {
            this.setErrorState(EnumErrorCode.NORESOURCE);
            return;
        }
        if (!this.hasPostageMin(2)) {
            this.setErrorState(EnumErrorCode.NOSTAMPS);
            return;
        }
    }

    @Override
    public boolean doWork() {
        return false;
    }

    @Override
    public boolean isWorking() {
        return false;
    }

    public boolean isLinked() {
        return this.getMoniker() != null && !this.getMoniker().isEmpty();
    }

    private float percentOccupied(int startSlot, int countSlots) {
        int max = 0;
        int avail = 0;
        la tradeInventory = this.getOrCreateTradeInventory();
        for (int i = startSlot; i < startSlot + countSlots; ++i) {
            max += 64;
            if (tradeInventory.a(i) == null) continue;
            avail += tradeInventory.a((int)i).a;
        }
        return (float)avail / (float)max;
    }

    public boolean hasPaperMin(float percentage) {
        return this.percentOccupied(5, 6) > percentage;
    }

    public boolean hasInputBufMin(float percentage) {
        return this.percentOccupied(15, 12) > percentage;
    }

    public boolean hasOutputBufMin(float percentage) {
        return this.percentOccupied(27, 12) > percentage;
    }

    public boolean hasPostageMin(int postage) {
        int posted = 0;
        la tradeInventory = this.getOrCreateTradeInventory();
        for (int i = 11; i < 15; ++i) {
            ur stamp = tradeInventory.a(i);
            if (stamp == null || !(stamp.b() instanceof IStamps)) continue;
            posted += ((IStamps)stamp.b()).getPostage(stamp).getValue() * stamp.a;
        }
        return posted >= postage;
    }

    public String getMoniker() {
        return this.moniker;
    }

    public void setMoniker(String moniker) {
        if (Proxies.common.isSimulating(this.tile.k)) {
            if (!PostOffice.isValidTradeMoniker(this.tile.k, moniker)) {
                this.setErrorState(EnumErrorCode.NOTALPHANUMERIC);
                return;
            }
            if (!PostOffice.isAvailableTradeMoniker(this.tile.k, moniker)) {
                this.setErrorState(EnumErrorCode.NOTUNIQUE);
                return;
            }
            this.moniker = moniker;
            PostOffice.getOrCreateTradeStation(this.tile.k, this.tile.getOwnerName(), this.moniker);
            this.setErrorState(EnumErrorCode.OK);
            this.tile.sendNetworkUpdate();
        } else {
            this.moniker = moniker;
        }
    }

    @Override
    public void getGUINetworkData(int i, int j) {
    }

    @Override
    public void sendGUINetworkData(rq container, rw iCrafting) {
    }

    public la getOrCreateTradeInventory() {
        if (!Proxies.common.isSimulating(this.tile.k)) {
            return new GenericInventoryAdapter(39, "INV");
        }
        if (this.moniker == null || this.moniker.isEmpty()) {
            return new GenericInventoryAdapter(39, "INV");
        }
        return PostOffice.getOrCreateTradeStation(this.tile.k, this.tile.getOwnerName(), this.moniker);
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        if (!this.isLinked()) {
            return 0;
        }
        la inventory = this.getOrCreateTradeInventory();
        ur tradegood = inventory.a(0);
        if (stack.c == up.aK.cj && (tradegood != null && tradegood.c != up.aK.cj || from == ForgeDirection.DOWN || from == ForgeDirection.UP)) {
            return StackUtils.addToInventory(stack, inventory, doAdd, 5, 6);
        }
        if (stack.b() instanceof IStamps && (tradegood != null && !(tradegood.b() instanceof IStamps) || from == ForgeDirection.DOWN || from == ForgeDirection.UP)) {
            return StackUtils.addToInventory(stack, inventory, doAdd, 11, 4);
        }
        if (tradegood == null) {
            return 0;
        }
        if (!tradegood.a(stack)) {
            return 0;
        }
        return StackUtils.addToInventory(stack, inventory, doAdd, 15, 12);
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        if (!this.isLinked()) {
            return new ur[0];
        }
        ur product = null;
        la inventory = this.getOrCreateTradeInventory();
        for (int i = 27; i < 39; ++i) {
            ur stackSlot = inventory.a(i);
            if (stackSlot == null || stackSlot.a <= 0) continue;
            product = inventory.a(i, 1);
            break;
        }
        if (product != null) {
            return new ur[]{product};
        }
        return new ur[0];
    }

    @Override
    public int getStartInventorySide(int side) {
        switch (side) {
            case 0: {
                return 5;
            }
            case 1: {
                return 11;
            }
            case 2: 
            case 4: {
                return 15;
            }
            case 3: 
            case 5: {
                return 27;
            }
        }
        return 0;
    }

    @Override
    public int getSizeInventorySide(int side) {
        switch (side) {
            case 0: {
                return 6;
            }
            case 1: {
                return 4;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 12;
            }
        }
        return 0;
    }

    @Override
    public int k_() {
        return this.getOrCreateTradeInventory().k_();
    }

    @Override
    public ur a(int i) {
        return this.getOrCreateTradeInventory().a(i);
    }

    @Override
    public ur a(int i, int j) {
        return this.getOrCreateTradeInventory().a(i, j);
    }

    @Override
    public void a(int i, ur itemstack) {
        this.getOrCreateTradeInventory().a(i, itemstack);
    }

    @Override
    public ur a_(int slot) {
        return this.getOrCreateTradeInventory().a_(slot);
    }

    @Override
    public void d() {
        this.getOrCreateTradeInventory().d();
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(PluginForestryMail.lowPaper25);
        res.add(PluginForestryMail.lowPaper10);
        res.add(PluginForestryMail.lowInput25);
        res.add(PluginForestryMail.lowInput10);
        res.add(PluginForestryMail.lowPostage40);
        res.add(PluginForestryMail.lowPostage20);
        res.add(PluginForestryMail.highBuffer90);
        res.add(PluginForestryMail.highBuffer75);
        return res;
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(any tile) {
            return new MachineTrader((TileMachine)tile);
        }
    }
}

