/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.GuiId;
import forestry.core.utils.GenericInventoryAdapter;
import forestry.core.utils.StackUtils;
import forestry.mail.IStamps;
import forestry.mail.PostOffice;

public class MachinePhilatelist
extends Machine {
    public static final short SLOT_FILTER = 0;
    public static final short SLOT_BUFFER_1 = 1;
    public static final short SLOT_BUFFER_COUNT = 27;
    private GenericInventoryAdapter inventory = new GenericInventoryAdapter(28, "INV");

    public MachinePhilatelist(TileMachine tile) {
        super(tile);
    }

    @Override
    public String getName() {
        return "tile.mill.7";
    }

    @Override
    public void openGui(qx player, la tile) {
        player.openGui(ForestryAPI.instance, GuiId.PhilatelistGUI.ordinal(), this.tile.k, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        this.inventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void updateServerSide() {
        if (this.tile.k.G() % 20L * 10L != 0L) {
            return;
        }
        ur stamp = null;
        if (this.inventory.a(0) == null) {
            stamp = PostOffice.getPostOffice(this.tile.k).getAnyStamp(1);
        } else {
            ur filter = this.inventory.a(0);
            if (filter.b() instanceof IStamps) {
                stamp = PostOffice.getPostOffice(this.tile.k).getAnyStamp(((IStamps)filter.b()).getPostage(filter), 1);
            }
        }
        if (stamp == null) {
            return;
        }
        StackUtils.stowInInventory(stamp, this.inventory, true, 1, 27);
    }

    @Override
    public boolean doWork() {
        return false;
    }

    @Override
    public boolean isWorking() {
        return false;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
    }

    @Override
    public void sendGUINetworkData(rq container, rw iCrafting) {
    }

    @Override
    public int k_() {
        return this.inventory.k_();
    }

    @Override
    public ur a(int i) {
        return this.inventory.a(i);
    }

    @Override
    public ur a(int i, int j) {
        return this.inventory.a(i, j);
    }

    @Override
    public void a(int i, ur itemstack) {
        this.inventory.a(i, itemstack);
    }

    @Override
    public ur a_(int slot) {
        return this.inventory.a_(slot);
    }

    @Override
    public void d() {
        this.inventory.d();
    }

    @Override
    public int getStartInventorySide(int side) {
        return 1;
    }

    @Override
    public int getSizeInventorySide(int side) {
        return 27;
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(any tile) {
            return new MachinePhilatelist((TileMachine)tile);
        }
    }
}

