/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import cpw.mods.fml.common.network.Player;
import forestry.api.core.IPacketHandler;
import forestry.core.network.PacketUpdate;
import forestry.core.proxy.Proxies;
import forestry.mail.POBox;
import forestry.mail.PostOffice;
import forestry.mail.gui.ContainerLetter;
import forestry.mail.gui.ContainerTradeName;
import forestry.mail.network.PacketPOBoxInfo;
import forestry.mail.network.PacketTradeInfo;
import forestry.plugins.PluginForestryMail;
import java.io.DataInputStream;

public class PacketHandlerMail
implements IPacketHandler {
    @Override
    public void onPacketData(ce network, int packetID, DataInputStream data, Player player) {
        try {
            switch (packetID) {
                case 83: {
                    PacketTradeInfo packetT = new PacketTradeInfo();
                    packetT.readData(data);
                    this.onTradeInfo(packetT);
                    break;
                }
                case 85: {
                    PacketPOBoxInfo packetP = new PacketPOBoxInfo();
                    packetP.readData(data);
                    this.onPOBoxInfo(packetP);
                    break;
                }
                case 80: {
                    PacketUpdate packet = new PacketUpdate();
                    packet.readData(data);
                    this.onLetterRecipient((qx)player, packet);
                    break;
                }
                case 81: {
                    PacketUpdate packet = new PacketUpdate();
                    packet.readData(data);
                    this.onLetterText((qx)player, packet);
                    break;
                }
                case 82: {
                    PacketUpdate packet = new PacketUpdate();
                    packet.readData(data);
                    this.onMonikerSet((qx)player, packet);
                    break;
                }
                case 86: {
                    this.onPOBoxInfoRequest((qx)player);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onTradeInfo(PacketTradeInfo packet) {
        rq container = Proxies.common.getClientInstance().g.bL;
        if (!(container instanceof ContainerLetter)) {
            return;
        }
        ((ContainerLetter)container).handleTradeInfoUpdate(packet);
    }

    private void onPOBoxInfo(PacketPOBoxInfo packet) {
        PluginForestryMail.proxy.setPOBoxInfo(Proxies.common.getRenderWorld(), Proxies.common.getClientInstance().g.bR, packet.poboxInfo);
    }

    private void onMonikerSet(qx player, PacketUpdate packet) {
        if (!(player.bL instanceof ContainerTradeName)) {
            return;
        }
        ((ContainerTradeName)player.bL).handleSetMoniker(packet);
    }

    private void onLetterText(qx player, PacketUpdate packet) {
        if (!(player.bL instanceof ContainerLetter)) {
            return;
        }
        ((ContainerLetter)player.bL).handleSetText(packet);
    }

    private void onLetterRecipient(qx player, PacketUpdate packet) {
        if (!(player.bL instanceof ContainerLetter)) {
            return;
        }
        ((ContainerLetter)player.bL).handleSetRecipient(player, packet);
    }

    private void onPOBoxInfoRequest(qx player) {
        POBox pobox = PostOffice.getPOBox(player.p, player.bR);
        if (pobox == null) {
            return;
        }
        Proxies.net.sendToPlayer(new PacketPOBoxInfo(85, pobox.getPOBoxInfo()), player);
    }
}

