/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.core.INBTTagable;
import forestry.mail.EnumAddressee;

public class MailAddress
implements INBTTagable {
    private EnumAddressee type;
    private String identifier;

    private MailAddress() {
    }

    public MailAddress(String identifier) {
        this(identifier, EnumAddressee.PLAYER);
    }

    public MailAddress(String identifier, EnumAddressee type) {
        this.identifier = identifier;
        this.type = type;
    }

    public EnumAddressee getType() {
        return this.type;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean isPlayer() {
        return this.type == EnumAddressee.PLAYER;
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        this.type = EnumAddressee.values()[nbttagcompound.d("TYP")];
        this.identifier = nbttagcompound.i("ID");
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        nbttagcompound.a("TYP", (short)this.type.ordinal());
        nbttagcompound.a("ID", this.identifier);
    }

    public static MailAddress loadFromNBT(bq nbttagcompound) {
        MailAddress address = new MailAddress();
        address.readFromNBT(nbttagcompound);
        return address;
    }
}

