/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.core.INBTTagable;
import forestry.core.utils.GenericInventoryAdapter;
import forestry.core.utils.StringUtil;
import forestry.mail.ILetter;
import forestry.mail.IStamps;
import forestry.mail.MailAddress;
import java.util.List;

public class Letter
implements ILetter,
INBTTagable {
    public static short SLOT_ATTACHMENT_1 = 0;
    public static short SLOT_POSTAGE_1 = (short)18;
    private boolean isProcessed = false;
    private MailAddress sender;
    private MailAddress[] recipient;
    private String text;
    private GenericInventoryAdapter inventory = new GenericInventoryAdapter(22, "INV");

    public Letter(MailAddress sender, MailAddress recipient) {
        this.sender = sender;
        this.recipient = new MailAddress[]{recipient};
    }

    public Letter(bq nbttagcompound) {
        if (nbttagcompound != null) {
            this.readFromNBT(nbttagcompound);
        }
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        this.isProcessed = nbttagcompound.n("PRC");
        this.sender = MailAddress.loadFromNBT(nbttagcompound.l("SDR"));
        int recipientCount = nbttagcompound.d("CRC");
        this.recipient = new MailAddress[recipientCount];
        for (int i = 0; i < recipientCount; ++i) {
            this.recipient[i] = MailAddress.loadFromNBT(nbttagcompound.l("RC" + i));
        }
        this.text = nbttagcompound.i("TXT");
        this.inventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        nbttagcompound.a("PRC", this.isProcessed);
        bq subcompound = new bq();
        this.sender.writeToNBT(subcompound);
        nbttagcompound.a("SDR", subcompound);
        nbttagcompound.a("CRC", (short)this.recipient.length);
        for (int i = 0; i < this.recipient.length; ++i) {
            subcompound = new bq();
            this.recipient[i].writeToNBT(subcompound);
            nbttagcompound.a("RC" + i, subcompound);
        }
        nbttagcompound.a("TXT", this.text);
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public ur[] getPostage() {
        return this.inventory.getStacks(SLOT_POSTAGE_1, 4);
    }

    @Override
    public ur[] getAttachments() {
        return this.inventory.getStacks(SLOT_ATTACHMENT_1, 18);
    }

    @Override
    public int countAttachments() {
        int count = 0;
        for (ur stack : this.getAttachments()) {
            if (stack == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void addAttachment(ur itemstack) {
        this.inventory.tryAddStack(itemstack, false);
    }

    @Override
    public void addAttachments(ur[] itemstacks) {
        for (ur stack : itemstacks) {
            this.addAttachment(stack);
        }
    }

    @Override
    public void invalidatePostage() {
        for (int i = SLOT_POSTAGE_1; i < SLOT_POSTAGE_1 + 4; ++i) {
            this.inventory.a(i, null);
        }
    }

    public void setInventory(GenericInventoryAdapter inventory) {
        this.inventory = inventory;
    }

    @Override
    public void setProcessed(boolean flag) {
        this.isProcessed = flag;
    }

    @Override
    public boolean isProcessed() {
        return this.isProcessed;
    }

    @Override
    public boolean isMailable() {
        if (this.isProcessed) {
            return false;
        }
        return this.recipient != null && this.recipient.length > 0;
    }

    @Override
    public boolean isPostPaid() {
        int posted = 0;
        for (ur stamp : this.getPostage()) {
            if (stamp == null || !(stamp.b() instanceof IStamps)) continue;
            posted += ((IStamps)stamp.b()).getPostage(stamp).getValue() * stamp.a;
        }
        return posted >= this.requiredPostage();
    }

    @Override
    public int requiredPostage() {
        int required = 1;
        for (ur attach : this.getAttachments()) {
            if (attach == null) continue;
            ++required;
        }
        return required;
    }

    @Override
    public void addStamps(ur stamps) {
        this.inventory.tryAddStack(stamps, SLOT_POSTAGE_1, 4, false);
    }

    @Override
    public boolean hasRecipient() {
        if (this.getRecipients().length <= 0) {
            return false;
        }
        MailAddress recipient = this.getRecipients()[0];
        if (recipient == null) {
            return false;
        }
        return !recipient.getIdentifier().isEmpty();
    }

    @Override
    public void setSender(MailAddress address) {
        this.sender = address;
    }

    @Override
    public MailAddress getSender() {
        return this.sender;
    }

    public void setRecipients(MailAddress[] recipients) {
        this.recipient = recipients;
    }

    @Override
    public void setRecipient(MailAddress address) {
        this.recipient = address == null ? new MailAddress[0] : new MailAddress[]{address};
    }

    @Override
    public MailAddress[] getRecipients() {
        return this.recipient;
    }

    @Override
    public String getRecipientString() {
        String recipientString = "";
        for (MailAddress address : this.recipient) {
            if (recipientString.length() > 0) {
                recipientString = recipientString + ", ";
            }
            recipientString = recipientString + address.getIdentifier();
        }
        return recipientString;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void addTooltip(List list) {
        if (this.sender != null) {
            list.add(StringUtil.localize("gui.mail.from") + ": " + this.sender.getIdentifier());
        }
        if (this.recipient != null && this.recipient.length > 0) {
            list.add(StringUtil.localize("gui.mail.to") + ": " + this.getRecipientString());
        }
    }

    public int k_() {
        return this.inventory.k_();
    }

    public ur a(int var1) {
        return this.inventory.a(var1);
    }

    public ur a(int var1, int var2) {
        return this.inventory.a(var1, var2);
    }

    public ur a_(int var1) {
        return this.inventory.a_(var1);
    }

    public void a(int var1, ur var2) {
        this.inventory.a(var1, var2);
    }

    public String b() {
        return this.inventory.b();
    }

    public int c() {
        return this.inventory.c();
    }

    public void d() {
        this.inventory.d();
    }

    public boolean a_(qx var1) {
        return true;
    }

    public void l_() {
        this.inventory.l_();
    }

    public void f() {
        this.inventory.f();
    }
}

