/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.triggers;

import buildcraft.api.gates.ITriggerParameter;
import forestry.api.core.ITileStructure;
import forestry.core.triggers.Trigger;
import forestry.core.utils.StringUtil;
import forestry.farming.gadgets.TileFarmPlain;
import forestry.farming.gadgets.TileHatch;

public class TriggerLowSoil
extends Trigger {
    private int threshold = 64;

    public TriggerLowSoil(int id, int threshold) {
        super(id, 7);
        this.threshold = threshold;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize("trigger.lowSoil") + " < " + this.threshold;
    }

    @Override
    public boolean hasParameter() {
        return true;
    }

    @Override
    public boolean isTriggerActive(any tile, ITriggerParameter parameter) {
        ur filter;
        if (!(tile instanceof TileHatch)) {
            return false;
        }
        ITileStructure central = ((TileHatch)tile).getCentralTE();
        if (central == null || !(central instanceof TileFarmPlain)) {
            return false;
        }
        if (parameter == null || parameter.getItemStack() == null) {
            filter = new ur(-1, this.threshold, -1);
        } else {
            filter = parameter.getItemStack().l();
            filter.a = this.threshold;
        }
        return !((TileFarmPlain)central).hasResources(new ur[]{filter});
    }
}

