/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.triggers;

import buildcraft.api.gates.ITriggerParameter;
import forestry.api.core.ITileStructure;
import forestry.core.triggers.Trigger;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TankSlot;
import forestry.farming.gadgets.TileFarmPlain;
import forestry.farming.gadgets.TileHatch;

public class TriggerLowLiquid
extends Trigger {
    private float threshold = 0.25f;

    public TriggerLowLiquid(int id, float threshold) {
        super(id, 1);
        this.threshold = threshold;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize("trigger.lowLiquid") + " < " + this.threshold * 100.0f + "%";
    }

    @Override
    public boolean isTriggerActive(any tile, ITriggerParameter parameter) {
        if (!(tile instanceof TileHatch)) {
            return false;
        }
        ITileStructure central = ((TileHatch)tile).getCentralTE();
        if (central == null || !(central instanceof TileFarmPlain)) {
            return false;
        }
        TankSlot tank = ((TileFarmPlain)central).getTank();
        return (float)tank.quantity / (float)tank.capacity <= this.threshold;
    }
}

