/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.IFarmHousing;
import forestry.core.utils.Utils;
import forestry.core.utils.Vect;
import forestry.farming.logic.FarmLogic;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidStack;

public abstract class FarmLogicWatered
extends FarmLogic {
    protected ur[] ground;
    private ur[] resource;
    private ur[] waste;
    ArrayList produce = new ArrayList();

    public FarmLogicWatered(IFarmHousing housing, ur[] resource, ur[] ground, ur[] waste) {
        super(housing);
        this.ground = ground;
        this.resource = resource;
        this.waste = waste;
    }

    @Override
    public int getFertilizerConsumption() {
        return 10;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(20.0f * hydrationModifier);
    }

    @Override
    public boolean isAcceptedResource(ur itemstack) {
        return this.resource[0].a(itemstack);
    }

    @Override
    public Collection collect() {
        ArrayList products = this.produce;
        this.produce = new ArrayList();
        return products;
    }

    @Override
    public boolean cultivate(int x2, int y2, int z2, ForgeDirection direction, int extent) {
        this.world = this.housing.getWorld();
        if (this.maintainSoil(x2, y2, z2, direction, extent)) {
            return true;
        }
        if (!this.isManual && this.maintainWater(x2, y2, z2, direction, extent)) {
            return true;
        }
        return this.maintainCrops(x2, y2 + 1, z2, direction, extent);
    }

    private boolean isWaste(ur stack) {
        for (ur block : this.waste) {
            if (!block.a(stack)) continue;
            return true;
        }
        return false;
    }

    private boolean maintainSoil(int x2, int y2, int z2, ForgeDirection direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x2, y2, z2, direction, i);
            if (!this.isAirBlock(position) && !Utils.isReplaceableBlock(this.world, position.x, position.y, position.z)) {
                ur block = this.getAsItemStack(position);
                if (!this.isWaste(block) || !this.housing.hasResources(this.resource)) continue;
                this.produce.addAll(amq.p[block.c].getBlockDropped(this.world, x2, y2, z2, block.c, 0));
                this.setBlock(position, 0, 0);
                return this.trySetSoil(position);
            }
            if (this.isManual) continue;
            if (i % 2 != 0) {
                ForgeDirection cclock = ForgeDirection.EAST;
                if (direction == ForgeDirection.EAST) {
                    cclock = ForgeDirection.SOUTH;
                } else if (direction == ForgeDirection.SOUTH) {
                    cclock = ForgeDirection.EAST;
                } else if (direction == ForgeDirection.WEST) {
                    cclock = ForgeDirection.SOUTH;
                }
                Vect previous = this.translateWithOffset(position.x, position.y, position.z, cclock, 1);
                ur soil = this.getAsItemStack(previous);
                if (this.ground[0].a(soil)) continue;
                this.trySetSoil(position);
                continue;
            }
            return this.trySetSoil(position);
        }
        return false;
    }

    private boolean maintainWater(int x2, int y2, int z2, ForgeDirection direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x2, y2, z2, direction, i);
            if (!this.isAirBlock(position) && !Utils.isReplaceableBlock(this.world, position.x, position.y, position.z)) continue;
            boolean isEnclosed = true;
            if (this.world.c(position.x + 1, position.y, position.z)) {
                isEnclosed = false;
            } else if (this.world.c(position.x - 1, position.y, position.z)) {
                isEnclosed = false;
            } else if (this.world.c(position.x, position.y, position.z + 1)) {
                isEnclosed = false;
            } else if (this.world.c(position.x, position.y, position.z - 1)) {
                isEnclosed = false;
            }
            if (!isEnclosed) continue;
            return this.trySetWater(position);
        }
        return false;
    }

    protected boolean maintainCrops(int x2, int y2, int z2, ForgeDirection direction, int extent) {
        return false;
    }

    private boolean trySetSoil(Vect position) {
        if (!this.housing.hasResources(this.resource)) {
            return false;
        }
        this.setBlock(position, this.ground[0].c, this.ground[0].j());
        this.housing.removeResources(this.resource);
        return true;
    }

    private boolean trySetWater(Vect position) {
        LiquidStack liquid = new LiquidStack(amq.E.cm, 1000);
        if (!this.housing.hasLiquid(liquid)) {
            return false;
        }
        this.setBlock(position, amq.E.cm, 0);
        this.housing.removeLiquid(liquid);
        return true;
    }
}

