/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import forestry.core.utils.Vect;
import forestry.farming.logic.FarmLogic;
import java.util.ArrayList;
import net.minecraftforge.common.ForgeDirection;

public abstract class FarmLogicHomogenous
extends FarmLogic {
    protected final ur[] resource;
    protected final ur[] ground;
    protected final ur[] waste;
    protected final IFarmable[] germlings;
    ArrayList produce = new ArrayList();

    public FarmLogicHomogenous(IFarmHousing housing, ur[] resource, ur[] ground, ur[] waste, IFarmable[] germlings) {
        super(housing);
        this.resource = resource;
        this.ground = ground;
        this.waste = waste;
        this.germlings = germlings;
    }

    @Override
    public boolean isAcceptedResource(ur itemstack) {
        return this.resource[0].a(itemstack);
    }

    @Override
    public boolean isAcceptedGermling(ur itemstack) {
        for (IFarmable germling : this.germlings) {
            if (!germling.isGermling(itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isWindfall(ur itemstack) {
        for (IFarmable germling : this.germlings) {
            if (!germling.isWindfall(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean cultivate(int x2, int y2, int z2, ForgeDirection direction, int extent) {
        this.world = this.housing.getWorld();
        if (this.maintainSoil(x2, y2, z2, direction, extent)) {
            return true;
        }
        return this.maintainGermlings(x2, y2 + 1, z2, direction, extent);
    }

    private boolean maintainSoil(int x2, int yGround, int z2, ForgeDirection direction, int extent) {
        if (!this.housing.hasResources(this.resource)) {
            return false;
        }
        block0: for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x2, yGround, z2, direction, i);
            if (!this.isAirBlock(position) && !Utils.isReplaceableBlock(this.world, position.x, position.y, position.z)) {
                ur block = this.getAsItemStack(position);
                for (ur grnd : this.ground) {
                    if (StackUtils.isIdenticalItem(grnd, block)) continue block0;
                }
                if (this.waste.length > 0 && this.waste[0].a(block)) {
                    this.produce.add(this.waste[0].l());
                } else {
                    return false;
                }
            }
            this.setBlock(position, this.ground[0].c, this.ground[0].j());
            this.housing.removeResources(this.resource);
            return true;
        }
        return false;
    }

    protected abstract boolean maintainGermlings(int var1, int var2, int var3, ForgeDirection var4, int var5);
}

