/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.Utils;
import forestry.core.utils.Vect;
import forestry.farming.logic.FarmLogicWatered;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import net.minecraftforge.common.ForgeDirection;

public abstract class FarmLogicCrops
extends FarmLogicWatered {
    private IFarmable[] seeds;

    public FarmLogicCrops(IFarmHousing housing, IFarmable[] seeds) {
        super(housing, new ur[]{new ur(amq.y)}, new ur[]{new ur(amq.aD)}, new ur[]{new ur(amq.y), new ur((amq)amq.x)});
        this.seeds = seeds;
    }

    @Override
    public boolean isAcceptedGermling(ur itemstack) {
        for (IFarmable germling : this.seeds) {
            if (!germling.isGermling(itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isWindfall(ur itemstack) {
        for (IFarmable germling : this.seeds) {
            if (!germling.isWindfall(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection collect() {
        ArrayList products = this.produce;
        this.produce = new ArrayList();
        Vect coords = new Vect(this.housing.getCoords());
        Vect area = new Vect(this.housing.getArea());
        Vect offset = new Vect(this.housing.getOffset());
        Vect min = coords.add(offset);
        Vect max = coords.add(offset).add(area);
        aoe harvestBox = aoe.a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
        List list = this.housing.getWorld().a(lq.class, harvestBox);
        for (int i = 0; i < list.size(); ++i) {
            ur contained;
            lq entity = (lq)list.get(i);
            if (!(entity instanceof px)) continue;
            px item = (px)entity;
            if (item.L || !this.isAcceptedGermling(contained = item.d()) && !this.isWindfall(contained)) continue;
            this.produce.add(contained.l());
            item.x();
        }
        return products;
    }

    @Override
    protected boolean maintainCrops(int x2, int y2, int z2, ForgeDirection direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x2, y2, z2, direction, i);
            if (!this.isAirBlock(position) && !Utils.isReplaceableBlock(this.world, position.x, position.y, position.z)) continue;
            ur below = this.getAsItemStack(position.add(new Vect(0, -1, 0)));
            if (this.ground[0].c != below.c || below.j() <= 0) continue;
            return this.trySetCrop(position);
        }
        return false;
    }

    private boolean trySetCrop(Vect position) {
        for (IFarmable candidate : this.seeds) {
            if (!this.housing.plantGermling(candidate, this.world, position.x, position.y, position.z)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection harvest(int x2, int y2, int z2, ForgeDirection direction, int extent) {
        this.world = this.housing.getWorld();
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x2, y2 + 1, z2, direction, i);
            for (IFarmable seed : this.seeds) {
                ICrop crop = seed.getCropAt(this.world, position.x, position.y, position.z);
                if (crop == null) continue;
                crops.push(crop);
            }
        }
        return crops;
    }
}

