/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.Farmables;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.config.ForestryBlock;
import forestry.core.utils.Vect;
import forestry.farming.logic.FarmLogicHomogenous;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import net.minecraftforge.common.ForgeDirection;

public class FarmLogicArboreal
extends FarmLogicHomogenous {
    private HashMap lastExtentsHarvest = new HashMap();
    protected int yOffset = 0;

    public FarmLogicArboreal(IFarmHousing housing, ur[] resource, ur[] ground, ur[] waste, IFarmable[] germlings) {
        super(housing, resource, ground, waste, germlings);
    }

    public FarmLogicArboreal(IFarmHousing housing) {
        super(housing, new ur[]{new ur(amq.y)}, new ur[]{new ur(ForestryBlock.soil.cm, 1, 0), new ur(ForestryBlock.soil.cm, 1, -1)}, new ur[]{new ur(amq.H)}, ((Collection)Farmables.farmables.get("farmArboreal")).toArray(new IFarmable[0]));
    }

    @Override
    public String getName() {
        return "Managed Arboretum";
    }

    @Override
    public int getIconIndex() {
        return amq.B.cl;
    }

    @Override
    public String getTextureFile() {
        return "/terrain.png";
    }

    @Override
    public int getFertilizerConsumption() {
        return 30;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(10.0f * hydrationModifier);
    }

    @Override
    public Collection collect() {
        ArrayList products = this.produce;
        this.produce = new ArrayList();
        Vect coords = new Vect(this.housing.getCoords());
        Vect area = new Vect(this.housing.getArea());
        Vect offset = new Vect(this.housing.getOffset());
        Vect min = coords.add(offset);
        Vect max = coords.add(offset).add(area);
        aoe harvestBox = aoe.a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
        List list = this.housing.getWorld().a(lq.class, harvestBox);
        for (int i = 0; i < list.size(); ++i) {
            ur contained;
            lq entity = (lq)list.get(i);
            if (!(entity instanceof px)) continue;
            px item = (px)entity;
            if (item.L || !this.isAcceptedGermling(contained = item.d()) && !this.isWindfall(contained)) continue;
            this.produce.add(contained.l());
            item.x();
        }
        return products;
    }

    @Override
    public Collection harvest(int x2, int y2, int z2, ForgeDirection direction, int extent) {
        int lastExtent;
        this.world = this.housing.getWorld();
        Collection crops = null;
        Vect start = new Vect(x2, y2, z2);
        if (!this.lastExtentsHarvest.containsKey(start)) {
            this.lastExtentsHarvest.put(start, 0);
        }
        if ((lastExtent = ((Integer)this.lastExtentsHarvest.get(start)).intValue()) > extent) {
            lastExtent = 0;
        }
        Vect position = this.translateWithOffset(x2, y2 + 1, z2, direction, lastExtent);
        crops = this.getHarvestBlocks(position);
        this.lastExtentsHarvest.put(start, ++lastExtent);
        return crops;
    }

    private Collection getHarvestBlocks(Vect position) {
        ArrayList<Vect> seen = new ArrayList<Vect>();
        Stack<ICrop> crops = new Stack<ICrop>();
        IFarmable germling = null;
        for (IFarmable germl : this.germlings) {
            ICrop crop = germl.getCropAt(this.world, position.x, position.y, position.z);
            if (crop == null) continue;
            crops.push(crop);
            seen.add(position);
            germling = germl;
            break;
        }
        if (germling == null) {
            return crops;
        }
        ArrayList candidates = this.processHarvestBlock(germling, crops, seen, position, position);
        ArrayList temp = new ArrayList();
        while (!candidates.isEmpty()) {
            for (Vect candidate : candidates) {
                temp.addAll(this.processHarvestBlock(germling, crops, seen, position, candidate));
            }
            candidates.clear();
            candidates.addAll(temp);
            temp.clear();
        }
        return crops;
    }

    private ArrayList processHarvestBlock(IFarmable germling, Stack crops, Collection seen, Vect start, Vect position) {
        ArrayList<Vect> candidates = new ArrayList<Vect>();
        for (int i = -1; i < 2; ++i) {
            for (int j = this.yOffset; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    ICrop crop;
                    Vect candidate = new Vect(position.x + i, position.y + j, position.z + k);
                    if (candidate.equals(position) || Math.abs(candidate.x - start.x) > 5 || Math.abs(candidate.z - start.z) > 5) continue;
                    boolean skip = false;
                    for (Vect prcs : seen) {
                        if (!candidate.equals(prcs)) continue;
                        skip = true;
                        break;
                    }
                    if (skip || (crop = germling.getCropAt(this.world, candidate.x, candidate.y, candidate.z)) == null) continue;
                    crops.push(crop);
                    candidates.add(candidate);
                    seen.add(candidate);
                }
            }
        }
        return candidates;
    }

    @Override
    protected boolean maintainGermlings(int x2, int ySaplings, int z2, ForgeDirection direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x2, ySaplings, z2, direction, i);
            if (!this.isAirBlock(position)) continue;
            ForgeDirection reverse = direction.getOpposite();
            Vect soilBelow = new Vect(position.x, position.y - 1, position.z);
            Vect soilPrevious = new Vect(position.x * reverse.offsetX, position.y - 1, position.z * reverse.offsetZ);
            if (!this.ground[0].a(this.getAsItemStack(soilPrevious)) && this.ground[0].a(this.getAsItemStack(soilBelow))) {
                return this.plantSapling(position);
            }
            if (!this.ground[0].a(this.getAsItemStack(soilBelow))) continue;
            return this.plantSapling(position);
        }
        return false;
    }

    private boolean plantSapling(Vect position) {
        for (IFarmable candidate : this.germlings) {
            if (!this.housing.plantGermling(candidate, this.world, position.x, position.y, position.z)) continue;
            return true;
        }
        return false;
    }
}

