/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.genetics.IFruitBearer;
import forestry.api.genetics.IFruitFamily;
import forestry.core.network.PacketFXSignal;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Vect;
import forestry.farming.logic.Crop;
import java.util.ArrayList;
import java.util.Collection;

public class CropFruit
extends Crop {
    IFruitFamily family;

    public CropFruit(yc world, Vect position, IFruitFamily family) {
        super(world, position);
        this.family = family;
    }

    @Override
    protected boolean isCrop(Vect pos) {
        any tile = this.world.q(pos.x, pos.y, pos.z);
        if (!(tile instanceof IFruitBearer)) {
            return false;
        }
        IFruitBearer bearer = (IFruitBearer)tile;
        if (!bearer.hasFruit()) {
            return false;
        }
        return !(bearer.getRipeness() < 0.9f);
    }

    @Override
    protected Collection harvestBlock(Vect pos) {
        any tile = this.world.q(pos.x, pos.y, pos.z);
        if (!(tile instanceof IFruitBearer)) {
            return new ArrayList();
        }
        Proxies.common.sendFXSignal(PacketFXSignal.VisualFXType.BLOCK_DESTROY, PacketFXSignal.SoundFXType.LEAF, this.world, pos.x, pos.y, pos.z, this.world.a(pos.x, pos.y, pos.z), 0);
        return ((IFruitBearer)tile).pickFruit(null);
    }
}

