/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gui;

import forestry.api.farming.IFarmLogic;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.GfxSlot;
import forestry.core.gui.GfxSlotManager;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.Ledger;
import forestry.core.gui.LiquidTankSlot;
import forestry.core.gui.SocketSlot;
import forestry.core.utils.StringUtil;
import forestry.farming.gadgets.TileFarmPlain;
import forestry.farming.gui.ContainerFarm;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;

public class GuiFarm
extends GuiForestry {
    public GuiFarm(qx player, TileFarmPlain tile) {
        super("/gfx/forestry/gui/mfarm.png", (ContainerForestry)new ContainerFarm(player.bJ, tile), tile);
        this.slotManager.add(new LiquidTankSlot(this.slotManager, 15, 19, tile.getTank(), 0).setOverlayOrigin(216, 18));
        this.slotManager.add(new SocketSlot(this.slotManager, 69, 40, tile, 0));
        this.slotManager.add(new FarmLogicSlot(this.slotManager, 69, 22, tile, 0));
        this.slotManager.add(new FarmLogicSlot(this.slotManager, 69, 58, tile, 1));
        this.slotManager.add(new FarmLogicSlot(this.slotManager, 51, 40, tile, 2));
        this.slotManager.add(new FarmLogicSlot(this.slotManager, 87, 40, tile, 3));
        this.xSize = 216;
        this.ySize = 220;
        this.tile = tile;
    }

    @Override
    protected void initLedgers(Object inventory) {
        super.initLedgers(inventory);
        this.ledgerManager.insert(new FarmLedger((TileFarmPlain)this.tile));
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        String title = StringUtil.localize("Farm");
        this.l.b(title, this.getCenteredOffset(title), 6, this.fontColor.get("gui.title"));
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int var2, int var3) {
        this.drawBackground();
        int fertilizerRemain = ((TileFarmPlain)this.tile).getStoredFertilizerScaled(16);
        if (fertilizerRemain > 0) {
            this.b(this.guiLeft + 81, this.guiTop + 94 + 17 - fertilizerRemain, this.xSize, 17 - fertilizerRemain, 4, fertilizerRemain);
        }
    }

    private static class FarmLogicSlot
    extends GfxSlot {
        private TileFarmPlain tile;
        private int slot;

        public FarmLogicSlot(GfxSlotManager manager, int xPos, int yPos, TileFarmPlain tile, int slot) {
            super(manager, xPos, yPos);
            this.tile = tile;
            this.slot = slot;
        }

        private IFarmLogic getLogic() {
            return this.tile.getFarmLogics()[this.slot];
        }

        private int getIconIndex() {
            if (this.getLogic() == null) {
                return 0;
            }
            return this.getLogic().getIconIndex();
        }

        private String getTexture() {
            if (this.getLogic() == null) {
                return "";
            }
            return this.getLogic().getTextureFile();
        }

        @Override
        public void draw(int startX, int startY) {
            if (this.getLogic() == null) {
                return;
            }
            if (this.getTexture() != null && !this.getTexture().isEmpty()) {
                int texture = this.manager.minecraft.o.b(this.getTexture());
                this.manager.minecraft.o.b(texture);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                int textureI = this.getIconIndex() >> 4;
                int textureJ = this.getIconIndex() - textureI * 16;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.manager.gui.b(startX + this.xPos, startY + this.yPos, 16 * textureJ, 16 * textureI, 16, 16);
            }
        }

        @Override
        protected String getTooltip(qx player) {
            if (this.getLogic() != null) {
                return this.getLogic().getName();
            }
            return null;
        }

        @Override
        protected void addInformation(ArrayList list, qx player) {
            if (this.getLogic() == null) {
                return;
            }
            list.add("Fertilizer: " + this.getLogic().getFertilizerConsumption());
            list.add("Water: " + this.getLogic().getWaterConsumption(this.tile.getHydrationModifier()));
        }
    }

    protected class FarmLedger
    extends Ledger {
        private TileFarmPlain farm;

        public FarmLedger(TileFarmPlain farm) {
            super(GuiFarm.this.ledgerManager);
            this.farm = farm;
            this.maxHeight = 118;
            this.overlayColor = GuiFarm.this.fontColor.get("ledger.farm.background");
        }

        @Override
        public void draw(int x2, int y2) {
            this.drawBackground(x2, y2);
            this.drawIcon("/gui/items.png", up.ax.b(0), x2 + 3, y2 + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiFarm.this.l.a(StringUtil.localize("gui.hydration"), x2 + 22, y2 + 8, GuiFarm.this.fontColor.get("ledger.power.header"));
            GuiFarm.this.l.a(StringUtil.localize("gui.hydr.heat") + ":", x2 + 22, y2 + 20, GuiFarm.this.fontColor.get("ledger.power.subheader"));
            GuiFarm.this.l.b(StringUtil.floatAsPercent(this.farm.getHydrationTempModifier()), x2 + 22, y2 + 32, GuiFarm.this.fontColor.get("ledger.power.text"));
            GuiFarm.this.l.a(StringUtil.localize("gui.hydr.humid") + ":", x2 + 22, y2 + 44, GuiFarm.this.fontColor.get("ledger.power.subheader"));
            GuiFarm.this.l.b(StringUtil.floatAsPercent(this.farm.getHydrationHumidModifier()), x2 + 22, y2 + 56, GuiFarm.this.fontColor.get("ledger.power.text"));
            GuiFarm.this.l.a(StringUtil.localize("gui.hydr.rainfall") + ":", x2 + 22, y2 + 68, GuiFarm.this.fontColor.get("ledger.power.subheader"));
            GuiFarm.this.l.b(StringUtil.floatAsPercent(this.farm.getHydrationRainfallModifier()) + " (" + this.farm.getDrought() + " d)", x2 + 22, y2 + 80, GuiFarm.this.fontColor.get("ledger.power.text"));
            GuiFarm.this.l.a(StringUtil.localize("gui.hydr.overall") + ":", x2 + 22, y2 + 92, GuiFarm.this.fontColor.get("ledger.power.subheader"));
            GuiFarm.this.l.b(StringUtil.floatAsPercent(this.farm.getHydrationModifier()), x2 + 22, y2 + 104, GuiFarm.this.fontColor.get("ledger.power.text"));
        }

        @Override
        public String getTooltip() {
            return StringUtil.floatAsPercent(this.farm.getHydrationModifier()) + " " + StringUtil.localize("gui.hydration");
        }
    }
}

