/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import buildcraft.api.inventory.ISpecialInventory;
import forestry.api.core.ITileStructure;
import forestry.core.triggers.Trigger;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.GenericInventoryAdapter;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import forestry.farming.gadgets.TileFarm;
import forestry.farming.gadgets.TileFarmPlain;
import forestry.plugins.PluginForestryFarming;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class TileHatch
extends TileFarm
implements ISpecialInventory,
ISidedInventory {
    public static int TEXTURE_SHIFT = 80;

    public TileHatch() {
        this.textureShift = TEXTURE_SHIFT;
    }

    @Override
    public boolean hasFunction() {
        return true;
    }

    @Override
    protected void createInventory() {
    }

    @Override
    protected void updateServerSide() {
        if (this.k.G() % 40L == 0L) {
            this.dumpStash();
        }
    }

    protected void dumpStash() {
        if (!this.hasMaster()) {
            return;
        }
        ForgeDirection[] pipes = BlockUtil.getPipeDirections(this.k, this.Coords(), ForgeDirection.UP);
        if (pipes.length > 0) {
            this.dumpToPipe(pipes);
        } else {
            la[] inventories = BlockUtil.getAdjacentInventories(this.k, this.Coords(), ForgeDirection.UP);
            this.dumpToInventory(inventories);
        }
    }

    private void dumpToPipe(ForgeDirection[] pipes) {
        ur[] products = this.extractItem(true, ForgeDirection.DOWN, 1);
        for (int i = 0; i < products.length; ++i) {
            while (products[i].a > 0) {
                BlockUtil.putFromStackIntoPipe(this, pipes, products[i]);
            }
        }
    }

    private void dumpToInventory(la[] inventories) {
        ITileStructure central = this.getCentralTE();
        if (central == null) {
            return;
        }
        la inv = central.getInventory();
        block0: for (int i = 12; i < 20; ++i) {
            if (inv.a(i) == null) continue;
            ur stack = inv.a(i);
            if (stack.a <= 0) continue;
            for (int j = 0; j < inventories.length; ++j) {
                if (inventories[j].k_() < 4) continue;
                la inventory = Utils.getChest(inventories[j]);
                StackUtils.stowInInventory(stack, inventory, true);
                if (stack.a > 0) continue;
                inv.a(i, null);
                continue block0;
            }
        }
    }

    private la getStructureInventory() {
        ITileStructure central;
        if (this.inventory != null) {
            if (this.isMaster()) {
                return this.inventory;
            }
        } else if (this.hasMaster() && (central = this.getCentralTE()) != null) {
            return central.getInventory();
        }
        return null;
    }

    public int k_() {
        la inv = this.getStructureInventory();
        if (inv != null) {
            return inv.k_();
        }
        return 0;
    }

    public ur a(int slotIndex) {
        la inv = this.getStructureInventory();
        if (inv != null) {
            return inv.a(slotIndex);
        }
        return null;
    }

    public ur a(int slotIndex, int amount) {
        la inv = this.getStructureInventory();
        if (inv != null) {
            return inv.a(slotIndex, amount);
        }
        return null;
    }

    public ur a_(int slotIndex) {
        la inv = this.getStructureInventory();
        if (inv != null) {
            return inv.a_(slotIndex);
        }
        return null;
    }

    public void a(int slotIndex, ur itemstack) {
        la inv = this.getStructureInventory();
        if (inv != null) {
            inv.a(slotIndex, itemstack);
        }
    }

    public int c() {
        la inv = this.getStructureInventory();
        if (inv != null) {
            return inv.c();
        }
        return 0;
    }

    public void l_() {
    }

    public void f() {
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case UP: {
                return 6;
            }
            case DOWN: {
                return 12;
            }
            case NORTH: 
            case SOUTH: {
                return 0;
            }
            case WEST: 
            case EAST: {
                return 20;
            }
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        switch (side) {
            case UP: {
                return 6;
            }
            case DOWN: {
                return 8;
            }
            case NORTH: 
            case SOUTH: {
                return 6;
            }
            case WEST: 
            case EAST: {
                return 1;
            }
        }
        return this.k_();
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        if (!this.hasMaster()) {
            return 0;
        }
        ITileStructure struct = this.getCentralTE();
        if (!(struct instanceof TileFarmPlain)) {
            return 0;
        }
        TileFarmPlain housing = (TileFarmPlain)struct;
        GenericInventoryAdapter inv = (GenericInventoryAdapter)housing.getInventory();
        if (housing.acceptsAsFertilizer(stack)) {
            return inv.addStack(stack, 20, 1, false, doAdd);
        }
        if (housing.acceptsAsResource(stack)) {
            return inv.addStack(stack, 0, 6, false, doAdd);
        }
        if (housing.acceptsAsGermling(stack)) {
            return inv.addStack(stack, 6, 6, false, doAdd);
        }
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        if (this.hasMaster()) {
            ITileStructure central = this.getCentralTE();
            if (central == null) {
                return new ur[0];
            }
        } else {
            return StackUtils.EMPTY_STACK_ARRAY;
        }
        la inv = this.getCentralTE().getInventory();
        ur product = null;
        for (int i = 12; i < 20; ++i) {
            if (inv.a(i) == null) continue;
            ur stack = inv.a(i);
            if (doRemove) {
                product = inv.a(i, 1);
                break;
            }
            product = stack.l();
            product.a = 1;
            break;
        }
        if (product != null) {
            return new ur[]{product};
        }
        return StackUtils.EMPTY_STACK_ARRAY;
    }

    @Override
    public LinkedList getCustomTriggers() {
        if (!this.hasMaster()) {
            return null;
        }
        LinkedList<Trigger> list = new LinkedList<Trigger>();
        list.add(PluginForestryFarming.lowResourceLiquid50);
        list.add(PluginForestryFarming.lowResourceLiquid25);
        list.add(PluginForestryFarming.lowSoil128);
        list.add(PluginForestryFarming.lowSoil64);
        list.add(PluginForestryFarming.lowSoil32);
        list.add(PluginForestryFarming.lowFertilizer50);
        list.add(PluginForestryFarming.lowFertilizer25);
        return list;
    }
}

