/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import forestry.api.fuels.FuelManager;
import forestry.api.fuels.RainSubstrate;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.Mill;
import forestry.core.gadgets.TileMill;
import forestry.core.proxy.Proxies;
import net.minecraftforge.common.ForgeDirection;

public class MillRainmaker
extends Mill {
    private int duration;
    private boolean reverse;

    public MillRainmaker(TileMill tile) {
        super(tile);
        this.tileMill = tile;
        this.speed = 0.01f;
    }

    @Override
    public String getName() {
        return "Rainmaker";
    }

    @Override
    public void openGui(qx player, la tile) {
        if (!Proxies.common.isSimulating(player.p)) {
            return;
        }
        if (player.bJ.g() == null) {
            return;
        }
        int usedItemId = player.bJ.g().c;
        if (FuelManager.rainSubstrate.containsKey(player.bJ.g()) && this.charge == 0) {
            RainSubstrate substrate = (RainSubstrate)FuelManager.rainSubstrate.get(usedItemId);
            if (substrate.item.a(player.bJ.g())) {
                this.addCharge(substrate);
                --player.bJ.g().a;
            }
        }
        this.tileMill.sendNetworkUpdate();
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.charge = nbttagcompound.e("Charge");
        this.progress = nbttagcompound.g("Progress");
        this.stage = nbttagcompound.e("Stage");
        this.duration = nbttagcompound.e("Duration");
        this.reverse = nbttagcompound.n("Reverse");
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("Charge", this.charge);
        nbttagcompound.a("Progress", this.progress);
        nbttagcompound.a("Stage", this.stage);
        nbttagcompound.a("Duration", this.duration);
        nbttagcompound.a("Reverse", this.reverse);
    }

    public void addCharge(RainSubstrate substrate) {
        this.charge = 1;
        this.speed = substrate.speed;
        this.duration = substrate.duration;
        this.reverse = substrate.reverse;
    }

    @Override
    public void activate() {
        if (Proxies.render.hasRendering()) {
            this.tileMill.k.a((double)this.tileMill.l, (double)this.tileMill.m, (double)this.tileMill.n, "ambient.weather.thunder", 4.0f, (1.0f + (this.tileMill.k.t.nextFloat() - this.tileMill.k.t.nextFloat()) * 0.2f) * 0.7f);
            float f = (float)this.tile.l + 0.5f;
            float f1 = (float)this.tile.m + 0.0f + this.tile.k.t.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)this.tile.n + 0.5f;
            float f3 = 0.52f;
            float f4 = this.tile.k.t.nextFloat() * 0.6f - 0.3f;
            Proxies.common.addEntityExplodeFX(this.tile.k, f - f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
            Proxies.common.addEntityExplodeFX(this.tile.k, f + f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
            Proxies.common.addEntityExplodeFX(this.tile.k, f + f4, f1, f2 - f3, 0.0f, 0.0f, 0.0f);
            Proxies.common.addEntityExplodeFX(this.tile.k, f + f4, f1, f2 + f3, 0.0f, 0.0f, 0.0f);
        }
        if (Proxies.common.isSimulating(this.tile.k)) {
            if (this.reverse) {
                this.tile.k.K().b(false);
            } else {
                this.tile.k.K().b(true);
                this.tile.k.K().g(this.duration);
            }
            this.charge = 0;
            this.duration = 0;
            this.reverse = false;
            this.tileMill.sendNetworkUpdate();
        }
    }

    @Override
    public boolean doWork() {
        return false;
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        if (this.charge != 0) {
            return 0;
        }
        if (!FuelManager.rainSubstrate.containsKey(stack)) {
            return 0;
        }
        RainSubstrate substrate = (RainSubstrate)FuelManager.rainSubstrate.get(stack);
        if (!substrate.item.a(stack)) {
            return 0;
        }
        if (doAdd) {
            this.addCharge(substrate);
        }
        return 1;
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(any tile) {
            return new MillRainmaker((TileMill)tile);
        }
    }
}

