/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.recipes.ISqueezerManager;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TankSlot;
import forestry.core.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidStack;

public class MachineSqueezer
extends Machine {
    @EntityNetData
    public TankSlot productTank = new TankSlot(10000);
    private ur[] inventoryStacks = new ur[12];
    private Recipe currentRecipe;
    private short resourceSlot1 = 0;
    private short remnantSlot = (short)9;
    private short canSlot = (short)10;
    private short outputSlot = (short)11;
    private Stack pendingLiquids = new Stack();
    private Stack pendingRemnants = new Stack();
    private int productionTime;
    private int timePerItem;

    public MachineSqueezer(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("squeezer"));
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.9");
    }

    @Override
    public void openGui(qx player, la tile) {
        player.openGui(ForestryAPI.instance, GuiId.SqueezerGUI.ordinal(), player.p, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("ProductionTime", this.productionTime);
        nbttagcompound.a("TimePerItem", this.timePerItem);
        by nbttaglist = new by();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            bq nbttagcompound1 = new bq();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((cd)nbttagcompound1);
        }
        nbttagcompound.a("Items", (cd)nbttaglist);
        nbttaglist = new by();
        ur[] remnants = this.pendingRemnants.toArray(new ur[this.pendingRemnants.size()]);
        for (int i = 0; i < remnants.length; ++i) {
            if (remnants[i] == null) continue;
            bq nbttagcompound1 = new bq();
            nbttagcompound1.a("Slot", (byte)i);
            remnants[i].b(nbttagcompound1);
            nbttaglist.a((cd)nbttagcompound1);
        }
        nbttagcompound.a("PendingRemnants", (cd)nbttaglist);
        nbttaglist = new by();
        LiquidStack[] liquids = this.pendingLiquids.toArray(new LiquidStack[this.pendingLiquids.size()]);
        for (int i = 0; i < liquids.length; ++i) {
            if (liquids[i] == null) continue;
            bq nbttagcompound1 = new bq();
            nbttagcompound1.a("Slot", (byte)i);
            liquids[i].writeToNBT(nbttagcompound1);
            nbttaglist.a((cd)nbttagcompound1);
        }
        nbttagcompound.a("PendingLiquids", (cd)nbttaglist);
        bq NBTproductSlot = new bq();
        this.productTank.writeToNBT(NBTproductSlot);
        nbttagcompound.a("ProductTank", (cd)NBTproductSlot);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        bq nbttagcompound1;
        int i;
        super.readFromNBT(nbttagcompound);
        this.productionTime = nbttagcompound.e("ProductionTime");
        this.timePerItem = nbttagcompound.e("TimePerItem");
        by nbttaglist = nbttagcompound.m("Items");
        this.inventoryStacks = new ur[this.k_()];
        for (i = 0; i < nbttaglist.c(); ++i) {
            nbttagcompound1 = (bq)nbttaglist.b(i);
            byte byte0 = nbttagcompound1.c("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = ur.a((bq)nbttagcompound1);
        }
        nbttaglist = nbttagcompound.m("PendingRemnants");
        for (i = 0; i < nbttaglist.c(); ++i) {
            nbttagcompound1 = (bq)nbttaglist.b(i);
            this.pendingRemnants.add(ur.a((bq)nbttagcompound1));
        }
        nbttaglist = nbttagcompound.m("PendingLiquids");
        for (i = 0; i < nbttaglist.c(); ++i) {
            nbttagcompound1 = (bq)nbttaglist.b(i);
            this.pendingLiquids.add(LiquidStack.loadLiquidStackFromNBT((bq)nbttagcompound1));
        }
        this.productTank = new TankSlot(10000);
        if (nbttagcompound.b("ProductTank")) {
            this.productTank.readFromNBT(nbttagcompound.l("ProductTank"));
        }
        this.checkRecipe();
    }

    @Override
    public void updateServerSide() {
        LiquidContainerData container;
        if (this.inventoryStacks[this.canSlot] != null && (container = LiquidHelper.getEmptyContainer(this.inventoryStacks[this.canSlot], new LiquidStack(this.productTank.liquidId, this.productTank.quantity, this.productTank.liquidMeta))) != null) {
            this.inventoryStacks[this.outputSlot] = this.bottleIntoContainer(this.inventoryStacks[this.canSlot], this.inventoryStacks[this.outputSlot], container, this.productTank);
            if (this.inventoryStacks[this.canSlot].a <= 0) {
                this.inventoryStacks[this.canSlot] = null;
            }
        }
        if (this.tile.k.G() % 20L * 10L != 0L) {
            return;
        }
        this.checkRecipe();
        if (this.getErrorState() == EnumErrorCode.NORECIPE && this.currentRecipe != null) {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public boolean doWork() {
        this.checkRecipe();
        this.tryAddPending();
        if (!this.pendingLiquids.isEmpty() || !this.pendingRemnants.isEmpty()) {
            return false;
        }
        if (this.productionTime <= 0) {
            return false;
        }
        if (this.currentRecipe == null) {
            return false;
        }
        --this.productionTime;
        if (this.productionTime > 0) {
            this.setErrorState(EnumErrorCode.OK);
            return true;
        }
        this.pendingLiquids.push(this.currentRecipe.liquid.copy());
        if (this.currentRecipe.remnants != null && this.tile.k.t.nextInt(100) < this.currentRecipe.chance) {
            this.pendingRemnants.push(this.currentRecipe.remnants.l());
        }
        this.removeResources(this.currentRecipe.resources);
        this.checkRecipe();
        this.resetRecipe();
        this.tryAddPending();
        this.setErrorState(EnumErrorCode.OK);
        return true;
    }

    private void checkRecipe() {
        ur[] resources = new ur[9];
        System.arraycopy(this.inventoryStacks, 0, resources, 0, 9);
        Recipe sameRec = RecipeManager.findMatchingRecipe(resources);
        if (sameRec == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.productionTime = 0;
            this.timePerItem = 0;
            return;
        }
        this.productionTime = this.currentRecipe.timePerItem;
        this.timePerItem = this.currentRecipe.timePerItem;
    }

    private boolean tryAddPending() {
        LiquidStack next;
        if (!this.pendingLiquids.isEmpty() && this.addProduct(next = (LiquidStack)this.pendingLiquids.peek())) {
            this.pendingLiquids.pop();
            return true;
        }
        if (!this.pendingRemnants.isEmpty() && this.addRemnant((ur)(next = (ur)this.pendingRemnants.peek()))) {
            this.pendingRemnants.pop();
            return true;
        }
        if (!this.pendingLiquids.isEmpty() || !this.pendingRemnants.isEmpty()) {
            this.setErrorState(EnumErrorCode.NOSPACE);
        }
        return false;
    }

    private boolean addProduct(LiquidStack stack) {
        stack.amount -= this.productTank.fill(stack, true);
        return stack.amount <= 0;
    }

    private boolean addRemnant(ur stack) {
        if (this.inventoryStacks[this.remnantSlot] == null) {
            this.inventoryStacks[this.remnantSlot] = stack;
            return true;
        }
        if (!this.inventoryStacks[this.remnantSlot].a(stack)) {
            return false;
        }
        int space = this.inventoryStacks[this.remnantSlot].d() - this.inventoryStacks[this.remnantSlot].a;
        if (space <= 0) {
            return false;
        }
        this.inventoryStacks[this.remnantSlot].a += stack.a;
        stack.a -= space;
        return true;
    }

    private void removeResources(ur[] stacks) {
        int[] removed = new int[stacks.length];
        block0: for (int i = this.resourceSlot1; i < this.remnantSlot; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            for (int j = 0; j < stacks.length && this.inventoryStacks[i] != null; ++j) {
                if (removed[j] >= stacks[j].a || !this.inventoryStacks[i].a(stacks[j])) continue;
                if (this.inventoryStacks[i].a >= stacks[j].a) {
                    this.a(i, stacks[j].a);
                    removed[j] = stacks[j].a;
                    continue;
                }
                int avail = this.inventoryStacks[i].a;
                this.inventoryStacks[i].a -= stacks[j].a;
                int n = j;
                removed[n] = removed[n] + avail;
                if (this.inventoryStacks[i].a > 0) continue;
                this.inventoryStacks[i] = null;
                continue block0;
            }
        }
    }

    @Override
    public boolean isWorking() {
        return this.currentRecipe != null && this.productTank.quantity < this.productTank.capacity;
    }

    @Override
    public boolean hasWork() {
        return this.currentRecipe != null && this.productTank.quantity < this.productTank.capacity;
    }

    public int getProgressScaled(int i) {
        if (this.timePerItem == 0) {
            return i;
        }
        return this.productionTime * i / this.timePerItem;
    }

    public int getResourceScaled(int i) {
        return this.productTank.quantity * i / 10000;
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.productionTime = j;
                break;
            }
            case 1: {
                this.timePerItem = j;
                break;
            }
            case 2: {
                this.productTank.liquidId = j;
                break;
            }
            case 3: {
                this.productTank.quantity = j;
                break;
            }
            case 4: {
                this.productTank.liquidMeta = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(rq container, rw iCrafting) {
        iCrafting.a(container, 0, this.productionTime);
        iCrafting.a(container, 1, this.timePerItem);
        iCrafting.a(container, 2, this.productTank.liquidId);
        iCrafting.a(container, 3, this.productTank.quantity);
        iCrafting.a(container, 4, this.productTank.liquidMeta);
    }

    @Override
    public int k_() {
        return this.inventoryStacks.length;
    }

    @Override
    public ur a(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public ur a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            ur product = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return product;
        }
        ur product = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return product;
    }

    @Override
    public void a(int i, ur itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.c()) {
            itemstack.a = this.c();
        }
    }

    @Override
    public ur a_(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        ur toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0) {
            return this.canSlot;
        }
        if (side == 1) {
            return this.remnantSlot;
        }
        return this.resourceSlot1;
    }

    @Override
    public int getSizeInventorySide(int side) {
        if (side == 0) {
            return 2;
        }
        if (side == 1) {
            return 1;
        }
        return 9;
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        if (LiquidHelper.isEmptyContainer(stack)) {
            if (this.inventoryStacks[this.canSlot] == null) {
                if (doAdd) {
                    this.inventoryStacks[this.canSlot] = stack.l();
                }
                return stack.a;
            }
            if (!this.inventoryStacks[this.canSlot].a(stack)) {
                return 0;
            }
            int space = this.inventoryStacks[this.canSlot].d() - this.inventoryStacks[this.canSlot].a;
            if (space <= 0) {
                return 0;
            }
            if (space < stack.a) {
                if (doAdd) {
                    this.inventoryStacks[this.canSlot].a = this.inventoryStacks[this.canSlot].d();
                }
                return space;
            }
            if (doAdd) {
                this.inventoryStacks[this.canSlot].a += stack.a;
            }
            return stack.a;
        }
        int freeSlots = 0;
        int slot = -1;
        int used = 0;
        for (int i = 0; i < this.remnantSlot; ++i) {
            int space;
            if (this.inventoryStacks[i] == null) {
                ++freeSlots;
                slot = i;
                continue;
            }
            if (!this.inventoryStacks[i].a(stack) || (space = this.inventoryStacks[i].d() - this.inventoryStacks[i].a) <= 0) continue;
            if (space < stack.a - used) {
                if (doAdd) {
                    this.inventoryStacks[i].a = this.inventoryStacks[i].d();
                }
                used += space;
                continue;
            }
            if (doAdd) {
                this.inventoryStacks[i].a += stack.a - used;
            }
            return stack.a;
        }
        if (freeSlots <= 0) {
            return used;
        }
        if (doAdd) {
            this.inventoryStacks[slot] = stack.l();
            this.inventoryStacks[slot].a = stack.a - used;
        }
        return stack.a;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        if (this.inventoryStacks[this.outputSlot] != null) {
            ur product = new ur(this.inventoryStacks[this.outputSlot].c, 1, this.inventoryStacks[this.outputSlot].j());
            if (doRemove) {
                --this.inventoryStacks[this.outputSlot].a;
                if (this.inventoryStacks[this.outputSlot].a <= 0) {
                    this.inventoryStacks[this.outputSlot] = null;
                }
            }
            return new ur[]{product};
        }
        if (this.inventoryStacks[this.remnantSlot] == null) {
            return new ur[0];
        }
        ur product = new ur(this.inventoryStacks[this.remnantSlot].c, 1, this.inventoryStacks[this.remnantSlot].j());
        if (doRemove) {
            --this.inventoryStacks[this.remnantSlot].a;
            if (this.inventoryStacks[this.remnantSlot].a <= 0) {
                this.inventoryStacks[this.remnantSlot] = null;
            }
        }
        return new ur[]{product};
    }

    @Override
    public LiquidStack drain(ForgeDirection from, int quantityMax, boolean doEmpty) {
        return this.drain(0, quantityMax, doEmpty);
    }

    @Override
    public LiquidStack drain(int tankIndex, int quantityMax, boolean doEmpty) {
        return this.productTank.drain(quantityMax, doEmpty);
    }

    public TankSlot[] getTanks(ForgeDirection direction) {
        return new TankSlot[]{this.productTank};
    }

    @Override
    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.productTank;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static void initialize() {
    }

    public static class RecipeManager
    implements ISqueezerManager {
        public static ArrayList recipes = new ArrayList();

        @Override
        public void addRecipe(int timePerItem, ur[] resources, LiquidStack liquid, ur remnants, int chance) {
            recipes.add(new Recipe(timePerItem, resources, liquid, remnants, chance));
        }

        @Override
        public void addRecipe(int timePerItem, ur[] resources, LiquidStack liquid) {
            this.addRecipe(timePerItem, resources, liquid, null, 0);
        }

        public static Recipe findMatchingRecipe(ur[] items) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.matches(items)) continue;
                return recipe;
            }
            return null;
        }

        @Override
        public List getRecipes() {
            HashMap<ur[], ur[]> recipeList = new HashMap<ur[], ur[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(recipe.resources, new ur[]{recipe.remnants, recipe.liquid.asItemStack()});
            }
            return (List)((Object)recipeList);
        }
    }

    public static class Recipe {
        public final int timePerItem;
        public final ur[] resources;
        public final LiquidStack liquid;
        public final ur remnants;
        public final int chance;

        public Recipe(int timePerItem, ur[] resources, LiquidStack liquid, ur remnants, int chance) {
            this.timePerItem = timePerItem;
            this.resources = resources;
            this.liquid = liquid;
            this.remnants = remnants;
            this.chance = chance;
        }

        public boolean matches(ur[] res) {
            if (res == null || res.length <= 0) {
                return false;
            }
            boolean matchedAll = true;
            for (ur stack : this.resources) {
                boolean matched = false;
                for (ur matchStack : res) {
                    if (matchStack == null || !matchStack.a(stack) || matchStack.a < stack.a) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                matchedAll = false;
            }
            return matchedAll;
        }
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(any tile) {
            return new MachineSqueezer((TileMachine)tile);
        }
    }
}

