/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import forestry.api.core.EnumHumidity;
import forestry.api.core.ForestryAPI;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.genetics.ClimateHelper;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TankSlot;
import forestry.core.utils.Utils;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidStack;

public class MachineRaintank
extends Machine {
    public static final short SLOT_RESOURCE = 0;
    public static final short SLOT_PRODUCT = 1;
    @EntityNetData
    public TankSlot resourceTank = new TankSlot(30000);
    private ur[] inventoryStacks = new ur[3];
    private boolean isValidBiome = true;
    private int fillingTime;
    private int fillingTotalTime;
    private LiquidContainerData productPending;
    private ur usedEmpty;

    public MachineRaintank(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("raintank"));
        if (tile.k != null) {
            yy biome = tile.k.a(tile.l, tile.n);
            if (ClimateHelper.getHumidity(biome.G) == EnumHumidity.ARID) {
                this.setErrorState(EnumErrorCode.INVALIDBIOME);
                this.isValidBiome = false;
            }
        }
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.3");
    }

    @Override
    public void openGui(qx player, la tile) {
        player.openGui(ForestryAPI.instance, GuiId.RaintankGUI.ordinal(), player.p, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("FillingTime", this.fillingTime);
        nbttagcompound.a("FillingTotalTime", this.fillingTotalTime);
        nbttagcompound.a("IsValidBiome", this.isValidBiome);
        bq NBTresourceSlot = new bq();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        nbttagcompound.a("ResourceTank", (cd)NBTresourceSlot);
        by nbttaglist = new by();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            bq nbttagcompound1 = new bq();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((cd)nbttagcompound1);
        }
        nbttagcompound.a("Items", (cd)nbttaglist);
        if (this.usedEmpty != null) {
            bq nbttagcompoundP = new bq();
            this.usedEmpty.b(nbttagcompoundP);
            nbttagcompound.a("UsedEmpty", (cd)nbttagcompoundP);
        }
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.fillingTime = nbttagcompound.e("FillingTime");
        this.fillingTotalTime = nbttagcompound.e("FillingTotalTime");
        this.isValidBiome = nbttagcompound.n("IsValidBiome");
        this.resourceTank = new TankSlot(30000);
        if (nbttagcompound.b("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.l("ResourceTank"));
        }
        by nbttaglist = nbttagcompound.m("Items");
        this.inventoryStacks = new ur[this.k_()];
        for (int i = 0; i < nbttaglist.c(); ++i) {
            bq nbttagcompound1 = (bq)nbttaglist.b(i);
            byte byte0 = nbttagcompound1.c("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = ur.a((bq)nbttagcompound1);
        }
        if (nbttagcompound.b("UsedEmpty")) {
            bq nbttagcompoundP = nbttagcompound.l("UsedEmpty");
            this.usedEmpty = ur.a((bq)nbttagcompoundP);
        }
    }

    @Override
    public void updateServerSide() {
        if (!Proxies.common.isSimulating(this.tile.k)) {
            return;
        }
        if (!this.isValidBiome) {
            this.setErrorState(EnumErrorCode.INVALIDBIOME);
            return;
        }
        if (!this.tile.k.k(this.tile.Coords().x, this.tile.Coords().y, this.tile.Coords().z)) {
            this.setErrorState(EnumErrorCode.NOSKY);
            return;
        }
        if (!this.tile.k.N()) {
            this.setErrorState(EnumErrorCode.NOTRAINING);
            return;
        }
        this.resourceTank.fill(new LiquidStack(amq.E.cm, 10), true);
        this.setErrorState(EnumErrorCode.OK);
    }

    @Override
    public boolean doWork() {
        if (!Proxies.common.isSimulating(this.tile.k)) {
            return false;
        }
        if (this.productPending != null) {
            if (this.tryProductAdd(this.productPending.filled.l(), true)) {
                this.productPending = null;
                return true;
            }
            return false;
        }
        if (this.fillingTime > 0) {
            LiquidContainerData container;
            --this.fillingTime;
            if (this.fillingTime <= 0 && this.usedEmpty != null && (container = LiquidHelper.getEmptyContainer(this.usedEmpty, new LiquidStack(amq.E, 1))) != null && !this.tryProductAdd(container.filled.l(), true)) {
                this.productPending = container;
            }
            return true;
        }
        if (this.tryStart(true)) {
            return true;
        }
        this.usedEmpty = null;
        return false;
    }

    private boolean tryStart(boolean doStart) {
        if (this.inventoryStacks[0] == null) {
            return false;
        }
        if (this.inventoryStacks[0].a <= 0) {
            return false;
        }
        LiquidContainerData container = LiquidHelper.getEmptyContainer(this.inventoryStacks[0], new LiquidStack(amq.E, 1));
        if (container == null) {
            return false;
        }
        if (!this.tryProductAdd(container.filled, false)) {
            return false;
        }
        if (this.resourceTank.quantity < container.stillLiquid.amount) {
            return false;
        }
        if (doStart) {
            this.resourceTank.quantity -= container.stillLiquid.amount;
            if (this.resourceTank.quantity < 0) {
                this.resourceTank.quantity = 0;
            }
            this.a(0, 1);
            this.fillingTotalTime = 10;
            this.fillingTime = 10;
            this.usedEmpty = container.container;
        }
        return true;
    }

    private boolean tryProductAdd(ur product, boolean doAdd) {
        if (product == null) {
            return false;
        }
        if (this.inventoryStacks[1] != null) {
            if (this.inventoryStacks[1].c != product.c) {
                return false;
            }
            if (this.inventoryStacks[1].a >= this.inventoryStacks[1].d()) {
                return false;
            }
        }
        if (!doAdd) {
            return true;
        }
        if (this.inventoryStacks[1] == null) {
            this.inventoryStacks[1] = product;
        } else {
            this.inventoryStacks[1].a += product.a;
        }
        return true;
    }

    @Override
    public boolean isWorking() {
        return this.fillingTime > 0 || this.productPending != null || this.tryStart(false);
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        if (this.inventoryStacks[0] == null) {
            return false;
        }
        return (float)this.inventoryStacks[0].a / (float)this.inventoryStacks[0].d() > percentage;
    }

    @Override
    public boolean hasWork() {
        if (this.fillingTime > 0) {
            return true;
        }
        if (this.inventoryStacks[0] == null) {
            return false;
        }
        LiquidContainerData container = LiquidHelper.getEmptyContainer(this.inventoryStacks[0], new LiquidStack(amq.E, 1));
        if (container == null) {
            return false;
        }
        return this.resourceTank.quantity >= container.stillLiquid.amount;
    }

    public int getFillProgressScaled(int i) {
        if (this.fillingTotalTime == 0) {
            return 0;
        }
        return this.fillingTime * i / this.fillingTotalTime;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.quantity * i / 30000;
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        LiquidContainerData container = LiquidHelper.getEmptyContainer(stack, new LiquidStack(amq.E, 1));
        if (container == null) {
            return 0;
        }
        if (this.inventoryStacks[0] == null) {
            if (doAdd) {
                this.inventoryStacks[0] = stack.l();
            }
            return stack.a;
        }
        if (this.inventoryStacks[0].a >= this.inventoryStacks[0].d()) {
            return 0;
        }
        if (!this.inventoryStacks[0].a(stack)) {
            return 0;
        }
        int space = this.c() - this.inventoryStacks[0].a;
        if (space >= stack.a) {
            if (doAdd) {
                this.inventoryStacks[0].a += stack.a;
            }
            return stack.a;
        }
        if (doAdd) {
            this.inventoryStacks[0].a = this.c();
            stack.a -= space;
        }
        return space;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        if (this.inventoryStacks[1] == null) {
            return new ur[0];
        }
        if (this.inventoryStacks[1].a <= 0) {
            return new ur[0];
        }
        ur product = new ur(this.inventoryStacks[1].b(), 1);
        if (doRemove) {
            --this.inventoryStacks[1].a;
            if (this.inventoryStacks[1].a <= 0) {
                this.inventoryStacks[1] = null;
            }
        }
        return new ur[]{product};
    }

    @Override
    public int k_() {
        return this.inventoryStacks.length;
    }

    @Override
    public ur a(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public ur a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            ur removed = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return removed;
        }
        ur removed = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return removed;
    }

    @Override
    public void a(int i, ur itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.c()) {
            itemstack.a = this.c();
        }
    }

    @Override
    public ur a_(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        ur toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0 || side == 1) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getSizeInventorySide(int side) {
        return 1;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.fillingTime = j;
                break;
            }
            case 1: {
                this.fillingTotalTime = j;
                break;
            }
            case 2: {
                this.resourceTank.liquidId = j;
                break;
            }
            case 3: {
                this.resourceTank.quantity = j;
                break;
            }
            case 4: {
                this.resourceTank.liquidMeta = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(rq container, rw iCrafting) {
        iCrafting.a(container, 0, this.fillingTime);
        iCrafting.a(container, 1, this.fillingTotalTime);
        iCrafting.a(container, 2, this.resourceTank.liquidId);
        iCrafting.a(container, 3, this.resourceTank.quantity);
        iCrafting.a(container, 4, this.resourceTank.liquidMeta);
    }

    @Override
    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (resource.itemID != amq.E.cm) {
            return 0;
        }
        int used = this.resourceTank.fill(resource, doFill);
        if (doFill && used > 0) {
            this.tile.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public LiquidStack drain(ForgeDirection from, int quantityMax, boolean doEmpty) {
        return this.drain(0, quantityMax, doEmpty);
    }

    @Override
    public LiquidStack drain(int tankIndex, int quantityMax, boolean doEmpty) {
        return this.resourceTank.drain(quantityMax, doEmpty);
    }

    public TankSlot[] getTanks(ForgeDirection direction) {
        return new TankSlot[]{this.resourceTank};
    }

    @Override
    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.resourceTank;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.lowResource25);
        res.add(ForestryTrigger.lowResource10);
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(any tile) {
            return new MachineRaintank((TileMachine)tile);
        }
    }
}

