/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.recipes.IMoistenerManager;
import forestry.api.recipes.RecipeManagers;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StackUtils;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TankSlot;
import forestry.core.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidStack;

public class MachineMoistener
extends Machine {
    @EntityNetData
    public TankSlot resourceTank = new TankSlot(10000);
    private ur[] inventoryStacks = new ur[12];
    public Recipe currentRecipe;
    private short stashSlot1 = 0;
    private short reservoirSlot1 = (short)6;
    private short reservoirSize = (short)3;
    private short workingSlot = (short)9;
    private short productSlot = (short)10;
    private short resourceSlot = (short)11;
    public int burnTime = 0;
    public int totalTime = 0;
    public int productionTime = 0;
    private int timePerItem = 0;
    private ur currentProduct;
    private ur pendingProduct;

    public ur getResourceStack() {
        return this.inventoryStacks[this.resourceSlot];
    }

    public MachineMoistener(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("moistener"));
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.6");
    }

    @Override
    public void openGui(qx player, la tile) {
        player.openGui(ForestryAPI.instance, GuiId.MoistenerGUI.ordinal(), player.p, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("BurnTime", this.burnTime);
        nbttagcompound.a("TotalTime", this.totalTime);
        nbttagcompound.a("ProductionTime", this.productionTime);
        bq NBTresourceSlot = new bq();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        nbttagcompound.a("ResourceTank", (cd)NBTresourceSlot);
        by nbttaglist = new by();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            bq nbttagcompound1 = new bq();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((cd)nbttagcompound1);
        }
        nbttagcompound.a("Items", (cd)nbttaglist);
        if (this.pendingProduct != null) {
            bq nbttagcompoundP = new bq();
            this.pendingProduct.b(nbttagcompoundP);
            nbttagcompound.a("PendingProduct", (cd)nbttagcompoundP);
        }
        if (this.currentProduct != null) {
            bq nbttagcompoundP = new bq();
            this.currentProduct.b(nbttagcompoundP);
            nbttagcompound.a("CurrentProduct", (cd)nbttagcompoundP);
        }
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.burnTime = nbttagcompound.e("BurnTime");
        this.totalTime = nbttagcompound.e("TotalTime");
        this.productionTime = nbttagcompound.e("ProductionTime");
        this.resourceTank = new TankSlot(10000);
        if (nbttagcompound.b("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.l("ResourceTank"));
        }
        by nbttaglist = nbttagcompound.m("Items");
        this.inventoryStacks = new ur[this.k_()];
        for (int i = 0; i < nbttaglist.c(); ++i) {
            bq nbttagcompound1 = (bq)nbttaglist.b(i);
            byte byte0 = nbttagcompound1.c("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = ur.a((bq)nbttagcompound1);
        }
        if (nbttagcompound.b("PendingProduct")) {
            bq nbttagcompoundP = nbttagcompound.l("PendingProduct");
            this.pendingProduct = ur.a((bq)nbttagcompoundP);
        }
        if (nbttagcompound.b("CurrentProduct")) {
            bq nbttagcompoundP = nbttagcompound.l("CurrentProduct");
            this.currentProduct = ur.a((bq)nbttagcompoundP);
        }
        this.checkRecipe();
    }

    @Override
    public void updateServerSide() {
        int lightvalue;
        LiquidContainerData container;
        if (this.inventoryStacks[this.productSlot] != null && (container = LiquidHelper.getLiquidContainer(this.inventoryStacks[this.productSlot])) != null && container.stillLiquid.isLiquidEqual(new ur(amq.E))) {
            this.inventoryStacks[this.productSlot] = StackUtils.replenishByContainer(this.tile, this.inventoryStacks[this.productSlot], container, this.resourceTank);
            if (this.inventoryStacks[this.productSlot].a <= 0) {
                this.inventoryStacks[this.productSlot] = null;
            }
        }
        if ((lightvalue = this.tile.k.m(this.tile.l, this.tile.m + 1, this.tile.n)) > 11) {
            this.setErrorState(EnumErrorCode.NOTGLOOMY);
            return;
        }
        int speed = lightvalue >= 9 ? 1 : (lightvalue >= 7 ? 2 : (lightvalue >= 5 ? 3 : 4));
        if (this.burnTime > 0 && this.pendingProduct == null) {
            if (this.resourceTank.quantity <= 0) {
                return;
            }
            this.checkRecipe();
            if (this.currentRecipe == null) {
                return;
            }
            --this.resourceTank.quantity;
            this.burnTime -= speed;
            this.productionTime -= speed;
            if (this.productionTime <= 0) {
                this.pendingProduct = this.currentProduct;
                this.a((int)this.resourceSlot, 1);
                this.resetRecipe();
                this.tryAddPending();
            }
        } else if (this.pendingProduct != null) {
            this.tryAddPending();
        } else if (this.rotateWorkingSlot()) {
            this.checkRecipe();
            if (this.inventoryStacks[this.workingSlot] == null) {
                return;
            }
            if (FuelManager.moistenerResource.containsKey(this.inventoryStacks[this.workingSlot])) {
                MoistenerFuel res = (MoistenerFuel)FuelManager.moistenerResource.get(this.inventoryStacks[this.workingSlot]);
                this.burnTime = this.totalTime = res.moistenerValue;
            }
        } else {
            this.rotateReservoir();
        }
        if (this.currentRecipe != null) {
            this.setErrorState(EnumErrorCode.OK);
        } else {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
    }

    private boolean tryAddPending() {
        if (this.pendingProduct == null) {
            return false;
        }
        if (this.inventoryStacks[this.productSlot] == null) {
            this.inventoryStacks[this.productSlot] = this.pendingProduct.l();
            this.pendingProduct = null;
            return true;
        }
        if (this.inventoryStacks[this.productSlot].a(this.pendingProduct) && this.inventoryStacks[this.productSlot].a <= this.inventoryStacks[this.productSlot].d() - this.pendingProduct.a) {
            this.inventoryStacks[this.productSlot].a += this.pendingProduct.a;
            this.pendingProduct = null;
            return true;
        }
        return false;
    }

    public void checkRecipe() {
        Recipe sameRec = RecipeManager.findMatchingRecipe(this.getResourceStack());
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.currentProduct = null;
            this.productionTime = 0;
            this.timePerItem = 0;
            this.setErrorState(EnumErrorCode.NORECIPE);
            return;
        }
        this.currentProduct = this.currentRecipe.product;
        this.productionTime = this.currentRecipe.timePerItem;
        this.timePerItem = this.currentRecipe.timePerItem;
    }

    private int getFreeSlot(ur deposit, int startSlot, int endSlot, boolean emptyOnly) {
        int slot = -1;
        for (int i = startSlot; i < endSlot; ++i) {
            if (this.inventoryStacks[i] == null) {
                if (slot >= 0) continue;
                slot = i;
                continue;
            }
            if (emptyOnly || !this.inventoryStacks[i].a(deposit) || this.inventoryStacks[i].a >= this.inventoryStacks[i].d()) continue;
            slot = i;
        }
        return slot;
    }

    private int getFreeStashSlot(ur deposit, boolean emptyOnly) {
        return this.getFreeSlot(deposit, 0, this.reservoirSlot1, emptyOnly);
    }

    private int getFreeReservoirSlot(ur deposit) {
        return this.getFreeSlot(deposit, this.reservoirSlot1, this.reservoirSlot1 + this.reservoirSize, false);
    }

    private int getNextResourceSlot(int startSlot, int endSlot) {
        int stage = -1;
        int resourceSlot = -1;
        for (int i = startSlot; i < endSlot; ++i) {
            if (this.inventoryStacks[i] == null || !FuelManager.moistenerResource.containsKey(this.inventoryStacks[i])) continue;
            MoistenerFuel res = (MoistenerFuel)FuelManager.moistenerResource.get(this.inventoryStacks[i]);
            if (stage >= 0 && res.stage >= stage) continue;
            stage = res.stage;
            resourceSlot = i;
        }
        return resourceSlot;
    }

    private boolean rotateWorkingSlot() {
        if (this.inventoryStacks[this.workingSlot] != null) {
            ur deposit;
            if (FuelManager.moistenerResource.containsKey(this.inventoryStacks[this.workingSlot])) {
                MoistenerFuel res = (MoistenerFuel)FuelManager.moistenerResource.get(this.inventoryStacks[this.workingSlot]);
                deposit = res.product.l();
            } else {
                deposit = this.inventoryStacks[this.workingSlot].l();
            }
            int targetSlot = this.getFreeReservoirSlot(deposit);
            if (targetSlot < 0) {
                return false;
            }
            if (this.inventoryStacks[targetSlot] == null) {
                this.inventoryStacks[targetSlot] = deposit;
            } else {
                ++this.inventoryStacks[targetSlot].a;
            }
            this.a((int)this.workingSlot, 1);
        }
        if (this.inventoryStacks[this.workingSlot] != null) {
            return true;
        }
        int resourceSlot = this.getNextResourceSlot(this.reservoirSlot1, this.reservoirSlot1 + this.reservoirSize);
        if (resourceSlot < 0) {
            return false;
        }
        this.inventoryStacks[this.workingSlot] = this.inventoryStacks[resourceSlot].a(1);
        if (this.inventoryStacks[resourceSlot].a <= 0) {
            this.inventoryStacks[resourceSlot] = null;
        }
        return true;
    }

    private void rotateReservoir() {
        int resourceSlot;
        int targetSlot;
        ArrayList<Integer> slotsToShift = new ArrayList<Integer>();
        for (int i = this.reservoirSlot1; i < this.reservoirSlot1 + this.reservoirSize; ++i) {
            if (this.inventoryStacks[i] == null || FuelManager.moistenerResource.containsKey(this.inventoryStacks[i])) continue;
            slotsToShift.add(i);
        }
        int shiftedSlots = 0;
        Iterator i$ = slotsToShift.iterator();
        while (i$.hasNext()) {
            int slot = (Integer)i$.next();
            targetSlot = this.getFreeStashSlot(this.inventoryStacks[slot], true);
            if (targetSlot < 0) continue;
            this.inventoryStacks[targetSlot] = this.inventoryStacks[slot];
            this.inventoryStacks[slot] = null;
            ++shiftedSlots;
        }
        for (int i = 0; i < (slotsToShift.size() > 0 ? shiftedSlots : 2) && (resourceSlot = this.getNextResourceSlot(0, this.reservoirSlot1)) >= 0 && (targetSlot = this.getFreeReservoirSlot(this.inventoryStacks[resourceSlot])) >= 0; ++i) {
            if (this.inventoryStacks[targetSlot] == null) {
                this.inventoryStacks[targetSlot] = this.inventoryStacks[resourceSlot];
                this.inventoryStacks[resourceSlot] = null;
                continue;
            }
            StackUtils.mergeStacks(this.inventoryStacks[resourceSlot], this.inventoryStacks[targetSlot]);
            if (this.inventoryStacks[resourceSlot] == null || this.inventoryStacks[resourceSlot].a > 0) continue;
            this.inventoryStacks[resourceSlot] = null;
        }
    }

    @Override
    public boolean doWork() {
        return false;
    }

    @Override
    public boolean isWorking() {
        return this.burnTime > 0 && this.resourceTank.quantity > 0;
    }

    @Override
    public boolean hasFuelMin(float percentage) {
        int max = 0;
        int avail = 0;
        for (int i = this.stashSlot1; i < this.reservoirSlot1; ++i) {
            if (this.inventoryStacks[i] == null) {
                max += 64;
                continue;
            }
            if (!FuelManager.moistenerResource.containsKey(this.inventoryStacks[i])) continue;
            MoistenerFuel res = (MoistenerFuel)FuelManager.moistenerResource.get(this.inventoryStacks[i]);
            if (!res.item.a(this.inventoryStacks[i])) continue;
            max += 64;
            avail += this.inventoryStacks[i].a;
        }
        return (float)avail / (float)max > percentage;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        if (this.inventoryStacks[this.resourceSlot] == null) {
            return false;
        }
        return (float)this.inventoryStacks[this.resourceSlot].a / (float)this.inventoryStacks[this.resourceSlot].d() > percentage;
    }

    public boolean isProducing() {
        return this.productionTime > 0;
    }

    public int getProductionProgressScaled(int i) {
        if (this.timePerItem == 0) {
            return 0;
        }
        return this.productionTime * i / this.timePerItem;
    }

    public int getConsumptionProgressScaled(int i) {
        if (this.totalTime == 0) {
            return 0;
        }
        return this.burnTime * i / this.totalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.quantity * i / 10000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public int k_() {
        return this.inventoryStacks.length;
    }

    @Override
    public ur a(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public void a(int i, ur itemstack) {
        this.inventoryStacks[i] = itemstack;
    }

    @Override
    public ur a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            ur removed = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return removed;
        }
        ur removed = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return removed;
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0) {
            return this.productSlot;
        }
        if (side == 1) {
            return this.resourceSlot;
        }
        return 0;
    }

    @Override
    public int getSizeInventorySide(int side) {
        if (side == 0) {
            return 1;
        }
        if (side == 1) {
            return 1;
        }
        return 6;
    }

    @Override
    public ur a_(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        ur toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        LiquidContainerData container = LiquidHelper.getLiquidContainer(stack);
        if (container != null && container.stillLiquid.isLiquidEqual(new LiquidStack(amq.E, 1))) {
            if (this.inventoryStacks[this.productSlot] == null) {
                if (doAdd) {
                    this.inventoryStacks[this.productSlot] = stack.l();
                }
                return stack.a;
            }
            if (!this.inventoryStacks[this.productSlot].a(stack)) {
                return 0;
            }
            int space = this.inventoryStacks[this.productSlot].d() - this.inventoryStacks[this.productSlot].a;
            if (space <= 0) {
                return 0;
            }
            if (space < stack.a) {
                if (doAdd) {
                    this.inventoryStacks[this.productSlot].a = this.inventoryStacks[this.productSlot].d();
                }
                return space;
            }
            if (doAdd) {
                this.inventoryStacks[this.productSlot].a += stack.a;
            }
            return stack.a;
        }
        if (from == ForgeDirection.UP || from == ForgeDirection.DOWN) {
            if (this.inventoryStacks[this.resourceSlot] == null) {
                if (doAdd) {
                    this.inventoryStacks[this.resourceSlot] = stack.l();
                }
                return stack.a;
            }
            if (!this.inventoryStacks[this.resourceSlot].a(stack)) {
                return 0;
            }
            int space = this.inventoryStacks[this.resourceSlot].d() - this.inventoryStacks[this.resourceSlot].a;
            if (space <= 0) {
                return 0;
            }
            if (space < stack.a) {
                if (doAdd) {
                    this.inventoryStacks[this.resourceSlot].a = this.inventoryStacks[this.resourceSlot].d();
                }
                return space;
            }
            if (doAdd) {
                this.inventoryStacks[this.resourceSlot].a += stack.a;
            }
            return stack.a;
        }
        int freeSlots = 0;
        int slot = -1;
        int used = 0;
        for (int i = 0; i < this.reservoirSlot1; ++i) {
            int space;
            if (this.inventoryStacks[i] == null) {
                ++freeSlots;
                slot = i;
                continue;
            }
            if (!this.inventoryStacks[i].a(stack) || (space = this.inventoryStacks[i].d() - this.inventoryStacks[i].a) <= 0) continue;
            if (space < stack.a - used) {
                if (doAdd) {
                    this.inventoryStacks[i].a = this.inventoryStacks[i].d();
                }
                used += space;
                continue;
            }
            if (doAdd) {
                this.inventoryStacks[i].a += stack.a - used;
            }
            return stack.a;
        }
        if (freeSlots <= 2) {
            return used;
        }
        if (doAdd) {
            this.inventoryStacks[slot] = stack.l();
            this.inventoryStacks[slot].a = stack.a - used;
        }
        return stack.a;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        if (this.inventoryStacks[this.productSlot] != null && this.inventoryStacks[this.productSlot].a > 0) {
            ur product = new ur(this.inventoryStacks[this.productSlot].c, 1, this.inventoryStacks[this.productSlot].j());
            if (doRemove) {
                --this.inventoryStacks[this.productSlot].a;
                if (this.inventoryStacks[this.productSlot].a <= 0) {
                    this.inventoryStacks[this.productSlot] = null;
                }
            }
            return new ur[]{product};
        }
        for (int i = 0; i < this.reservoirSlot1; ++i) {
            if (this.inventoryStacks[i] == null || FuelManager.moistenerResource.containsKey(this.inventoryStacks[i])) continue;
            ur product = new ur(this.inventoryStacks[i].c, 1, this.inventoryStacks[i].j());
            if (doRemove) {
                --this.inventoryStacks[i].a;
                if (this.inventoryStacks[i].a <= 0) {
                    this.inventoryStacks[i] = null;
                }
            }
            return new ur[]{product};
        }
        return new ur[0];
    }

    @Override
    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        int used = this.resourceTank.fill(resource, doFill);
        if (doFill && used > 0) {
            this.tile.sendNetworkUpdate();
        }
        return used;
    }

    public TankSlot[] getTanks(ForgeDirection direction) {
        return new TankSlot[]{this.resourceTank};
    }

    @Override
    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.resourceTank;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.burnTime = j;
                break;
            }
            case 1: {
                this.totalTime = j;
                break;
            }
            case 2: {
                this.productionTime = j;
                break;
            }
            case 3: {
                this.timePerItem = j;
                break;
            }
            case 4: {
                this.resourceTank.liquidId = j;
                break;
            }
            case 5: {
                this.resourceTank.quantity = j;
                break;
            }
            case 6: {
                this.resourceTank.liquidMeta = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(rq container, rw iCrafting) {
        iCrafting.a(container, 0, this.burnTime);
        iCrafting.a(container, 1, this.totalTime);
        iCrafting.a(container, 2, this.productionTime);
        iCrafting.a(container, 3, this.timePerItem);
        iCrafting.a(container, 4, this.resourceTank.liquidId);
        iCrafting.a(container, 5, this.resourceTank.quantity);
        iCrafting.a(container, 6, this.resourceTank.liquidMeta);
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.lowFuel25);
        res.add(ForestryTrigger.lowFuel10);
        res.add(ForestryTrigger.lowResource25);
        res.add(ForestryTrigger.lowResource10);
        return res;
    }

    public static void initialize() {
        RecipeManagers.moistenerManager.addRecipe(new ur(up.S), new ur((amq)amq.bB), 5000);
        RecipeManagers.moistenerManager.addRecipe(new ur(amq.z), new ur(amq.ar), 20000);
        RecipeManagers.moistenerManager.addRecipe(new ur(amq.bp), new ur(amq.bp, 1, 1), 20000);
    }

    public static class RecipeManager
    implements IMoistenerManager {
        public static ArrayList recipes = new ArrayList();

        @Override
        public void addRecipe(ur resource, ur product, int timePerItem) {
            recipes.add(new Recipe(resource, product, timePerItem));
        }

        public static Recipe findMatchingRecipe(ur item) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.matches(item)) continue;
                return recipe;
            }
            return null;
        }

        @Override
        public List getRecipes() {
            HashMap<ur[], ur[]> recipeList = new HashMap<ur[], ur[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(new ur[]{recipe.resource}, new ur[]{recipe.product});
            }
            return (List)((Object)recipeList);
        }
    }

    public static class Recipe {
        public int timePerItem;
        public ur resource;
        public ur product;

        public Recipe(ur resource, ur product, int timePerItem) {
            this.timePerItem = timePerItem;
            this.resource = resource;
            this.product = product;
        }

        public boolean matches(ur res) {
            if (res == null && this.resource == null) {
                return true;
            }
            if (res == null && this.resource != null) {
                return false;
            }
            if (res != null && this.resource == null) {
                return false;
            }
            return this.resource.a(res);
        }
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(any tile) {
            return new MachineMoistener((TileMachine)tile);
        }
    }
}

