/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.recipes.IFermenterManager;
import forestry.core.EnumErrorCode;
import forestry.core.GameMode;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.RecipeUtil;
import forestry.core.utils.StackUtils;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TankSlot;
import forestry.core.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidStack;

public class MachineFermenter
extends Machine {
    public static final short SLOT_RESOURCE = 0;
    public static final short SLOT_FUEL = 1;
    public static final short SLOT_CAN_OUTPUT = 2;
    public static final short SLOT_CAN_INPUT = 3;
    public static final short SLOT_INPUT = 4;
    @EntityNetData
    public TankSlot resourceTank = new TankSlot(10000);
    @EntityNetData
    public TankSlot productTank = new TankSlot(10000);
    private ur[] inventoryStacks = new ur[5];
    private Recipe currentRecipe;
    public int fermentationTime = 0;
    public int fermentationTotalTime = 0;
    public int fuelBurnTime = 0;
    public int fuelTotalTime = 0;
    public int fuelCurrentFerment = 0;

    public MachineFermenter(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("fermenter"));
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.0");
    }

    @Override
    public void openGui(qx player, la tile) {
        player.openGui(ForestryAPI.instance, GuiId.FermenterGUI.ordinal(), player.p, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("FermentationTime", this.fermentationTime);
        nbttagcompound.a("FermentationTotalTime", this.fermentationTotalTime);
        nbttagcompound.a("FuelBurnTime", this.fuelBurnTime);
        nbttagcompound.a("FuelTotalTime", this.fuelTotalTime);
        nbttagcompound.a("FuelCurrentFerment", this.fuelCurrentFerment);
        bq NBTresourceSlot = new bq();
        bq NBTproductSlot = new bq();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        this.productTank.writeToNBT(NBTproductSlot);
        nbttagcompound.a("ResourceTank", (cd)NBTresourceSlot);
        nbttagcompound.a("ProductTank", (cd)NBTproductSlot);
        by nbttaglist = new by();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            bq nbttagcompound1 = new bq();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((cd)nbttagcompound1);
        }
        nbttagcompound.a("Items", (cd)nbttaglist);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.fermentationTime = nbttagcompound.e("FermentationTime");
        this.fermentationTotalTime = nbttagcompound.e("FermentationTotalTime");
        this.fuelBurnTime = nbttagcompound.e("FuelBurnTime");
        this.fuelTotalTime = nbttagcompound.e("FuelTotalTime");
        this.fuelCurrentFerment = nbttagcompound.e("FuelCurrentFerment");
        this.resourceTank = new TankSlot(10000);
        this.productTank = new TankSlot(10000);
        if (nbttagcompound.b("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.l("ResourceTank"));
            this.productTank.readFromNBT(nbttagcompound.l("ProductTank"));
        }
        by nbttaglist = nbttagcompound.m("Items");
        this.inventoryStacks = new ur[this.k_()];
        for (int i = 0; i < nbttaglist.c(); ++i) {
            bq nbttagcompound1 = (bq)nbttaglist.b(i);
            byte byte0 = nbttagcompound1.c("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = ur.a((bq)nbttagcompound1);
        }
    }

    @Override
    public void updateServerSide() {
        LiquidContainerData container;
        if (this.inventoryStacks[4] != null && (container = LiquidHelper.getLiquidContainer(this.inventoryStacks[4])) != null && RecipeManager.isLiquidResource(container.stillLiquid)) {
            this.inventoryStacks[4] = StackUtils.replenishByContainer(this.tile, this.inventoryStacks[4], container, this.resourceTank);
            if (this.inventoryStacks[4].a <= 0) {
                this.inventoryStacks[4] = null;
            }
        }
        if (this.inventoryStacks[3] != null && (container = LiquidHelper.getEmptyContainer(this.inventoryStacks[3], new LiquidStack(this.productTank.liquidId, this.productTank.quantity, this.productTank.liquidMeta))) != null) {
            this.inventoryStacks[2] = this.bottleIntoContainer(this.inventoryStacks[3], this.inventoryStacks[2], container, this.productTank);
            if (this.inventoryStacks[3].a <= 0) {
                this.inventoryStacks[3] = null;
            }
        }
        if (this.tile.k.G() % 20L * 10L != 0L) {
            return;
        }
        if (RecipeManager.findMatchingRecipe(this.inventoryStacks[0], new LiquidStack(this.resourceTank.liquidId, this.resourceTank.quantity, this.resourceTank.liquidMeta)) != null) {
            this.setErrorState(EnumErrorCode.OK);
        } else if (this.inventoryStacks[1] == null && this.fuelBurnTime <= 0) {
            this.setErrorState(EnumErrorCode.NOFUEL);
        } else {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
    }

    @Override
    public boolean doWork() {
        if (this.currentRecipe == null) {
            this.checkRecipe();
            this.resetRecipe();
            if (this.currentRecipe != null) {
                this.a(0, 1);
                return true;
            }
            return false;
        }
        if (this.fuelBurnTime > 0 && this.resourceTank.quantity > 0 && this.productTank.quantity < 10000) {
            --this.fuelBurnTime;
            if (this.currentRecipe == null) {
                return true;
            }
            if (this.fermentationTime <= 0) {
                return false;
            }
            this.resourceTank.drain(this.fuelCurrentFerment, true);
            this.fermentationTime -= this.fuelCurrentFerment;
            this.addProduct(new LiquidStack(this.currentRecipe.output.itemID, Math.round((float)this.fuelCurrentFerment * this.currentRecipe.modifier), this.currentRecipe.output.itemMeta));
            if (this.fermentationTime > 0) {
                return true;
            }
            this.currentRecipe = null;
            return true;
        }
        if (this.fuelBurnTime <= 0) {
            this.fuelBurnTime = this.fuelTotalTime = this.determineFuelValue(this.getFuelStack());
            if (this.fuelBurnTime > 0) {
                this.fuelCurrentFerment = this.determineFermentPerCycle(this.getFuelStack());
                this.a(1, 1);
                return true;
            }
            this.fuelCurrentFerment = 0;
            return false;
        }
        return false;
    }

    private void addProduct(LiquidStack output) {
        this.productTank.fill(output, true);
        if (this.productTank.quantity > 10000) {
            this.productTank.quantity = 10000;
        }
    }

    private void checkRecipe() {
        Recipe sameRec = RecipeManager.findMatchingRecipe(this.inventoryStacks[0], new LiquidStack(this.resourceTank.liquidId, this.resourceTank.quantity, this.resourceTank.liquidMeta));
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
        }
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.fermentationTime = 0;
            this.fermentationTotalTime = 0;
            return;
        }
        this.fermentationTime = this.currentRecipe.fermentationValue;
        this.fermentationTotalTime = this.currentRecipe.fermentationValue;
    }

    private int determineFuelValue(ur item) {
        if (item == null) {
            return 0;
        }
        int fuelid = item.b().cj;
        if (fuelid == 0) {
            return 0;
        }
        if (FuelManager.fermenterFuel.containsKey(item)) {
            return ((FermenterFuel)FuelManager.fermenterFuel.get((Object)item.b())).burnDuration;
        }
        return 0;
    }

    private int determineFermentPerCycle(ur item) {
        if (item == null) {
            return 0;
        }
        int fuelid = item.b().cj;
        if (fuelid == 0) {
            return 0;
        }
        if (FuelManager.fermenterFuel.containsKey(item.b())) {
            return ((FermenterFuel)FuelManager.fermenterFuel.get((Object)item.b())).fermentPerCycle;
        }
        return 0;
    }

    @Override
    public boolean isWorking() {
        if (this.currentRecipe == null && RecipeManager.findMatchingRecipe(this.inventoryStacks[0], new LiquidStack(this.resourceTank.liquidId, this.resourceTank.quantity, this.resourceTank.liquidMeta)) == null) {
            return false;
        }
        if (this.fuelBurnTime > 0) {
            return this.resourceTank.quantity > 0 && this.productTank.quantity < 10000;
        }
        return this.determineFuelValue(this.getFuelStack()) > 0;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        if (this.getFermentationStack() == null) {
            return false;
        }
        return (float)this.getFermentationStack().a / (float)this.getFermentationStack().d() > percentage;
    }

    @Override
    public boolean hasFuelMin(float percentage) {
        if (this.getFuelStack() == null) {
            return false;
        }
        return (float)this.getFuelStack().a / (float)this.getFuelStack().d() > percentage;
    }

    @Override
    public boolean hasWork() {
        if (this.getFuelStack() == null && this.fuelBurnTime <= 0) {
            return false;
        }
        if (this.fuelBurnTime <= 0 && RecipeManager.findMatchingRecipe(this.inventoryStacks[0], new LiquidStack(this.resourceTank.liquidId, this.resourceTank.quantity, this.resourceTank.liquidMeta)) == null) {
            return false;
        }
        if (this.getFermentationStack() == null && this.fermentationTime <= 0) {
            return false;
        }
        if (this.fermentationTime <= 0 && RecipeManager.findMatchingRecipe(this.inventoryStacks[0], new LiquidStack(this.resourceTank.liquidId, this.resourceTank.quantity, this.resourceTank.liquidMeta)) == null) {
            return false;
        }
        if (this.resourceTank.quantity <= 0) {
            return false;
        }
        return this.productTank.quantity < this.productTank.capacity;
    }

    public int getBurnTimeRemainingScaled(int i) {
        if (this.fuelTotalTime == 0) {
            return 0;
        }
        return this.fuelBurnTime * i / this.fuelTotalTime;
    }

    public int getFermentationProgressScaled(int i) {
        if (this.fermentationTotalTime == 0) {
            return 0;
        }
        return this.fermentationTime * i / this.fermentationTotalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.quantity * i / 10000;
    }

    public int getProductScaled(int i) {
        return this.productTank.quantity * i / 10000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return Utils.rateTankLevel(this.getProductScaled(100));
    }

    public ur getFermentationStack() {
        return this.inventoryStacks[0];
    }

    public ur getFuelStack() {
        return this.inventoryStacks[1];
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.fuelBurnTime = j;
                break;
            }
            case 1: {
                this.fuelTotalTime = j;
                break;
            }
            case 2: {
                this.fermentationTime = j;
                break;
            }
            case 3: {
                this.fermentationTotalTime = j;
                break;
            }
            case 4: {
                this.resourceTank.liquidId = j;
                break;
            }
            case 5: {
                this.resourceTank.quantity = j;
                break;
            }
            case 6: {
                this.resourceTank.liquidMeta = j;
                break;
            }
            case 7: {
                this.productTank.liquidId = j;
                break;
            }
            case 8: {
                this.productTank.quantity = j;
                break;
            }
            case 9: {
                this.productTank.liquidMeta = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(rq container, rw iCrafting) {
        iCrafting.a(container, 0, this.fuelBurnTime);
        iCrafting.a(container, 1, this.fuelTotalTime);
        iCrafting.a(container, 2, this.fermentationTime);
        iCrafting.a(container, 3, this.fermentationTotalTime);
        iCrafting.a(container, 4, this.resourceTank.liquidId);
        iCrafting.a(container, 5, this.resourceTank.quantity);
        iCrafting.a(container, 6, this.resourceTank.liquidMeta);
        iCrafting.a(container, 7, this.productTank.liquidId);
        iCrafting.a(container, 8, this.productTank.quantity);
        iCrafting.a(container, 9, this.productTank.liquidMeta);
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        int inventory;
        if (FuelManager.fermenterFuel.containsKey(stack.b())) {
            inventory = 1;
        } else if (RecipeManager.isResource(stack)) {
            inventory = 0;
        } else if (LiquidHelper.isEmptyContainer(stack)) {
            inventory = 3;
        } else {
            LiquidContainerData container = LiquidHelper.getLiquidContainer(stack);
            if (container != null && RecipeManager.isLiquidResource(container.stillLiquid)) {
                inventory = 4;
            } else {
                return 0;
            }
        }
        int space = 0;
        if (this.inventoryStacks[inventory] == null) {
            space = this.c();
        } else {
            if (!StackUtils.isIdenticalItem(this.inventoryStacks[inventory], stack)) {
                return 0;
            }
            space = this.inventoryStacks[inventory].d() - this.inventoryStacks[inventory].a;
        }
        if (space <= 0) {
            return 0;
        }
        if (space >= stack.a) {
            if (doAdd) {
                if (this.inventoryStacks[inventory] == null) {
                    this.inventoryStacks[inventory] = stack.l();
                } else {
                    this.inventoryStacks[inventory].a += stack.a;
                }
            }
            return stack.a;
        }
        if (doAdd) {
            this.inventoryStacks[inventory].a += space;
        }
        return Math.min(stack.a, space);
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        ur product = null;
        if (this.inventoryStacks[2] != null) {
            product = new ur(this.inventoryStacks[2].c, 1, this.inventoryStacks[2].j());
            if (doRemove) {
                --this.inventoryStacks[2].a;
                if (this.inventoryStacks[2].a <= 0) {
                    this.inventoryStacks[2] = null;
                }
            }
        }
        if (product != null) {
            return new ur[]{product};
        }
        return new ur[0];
    }

    @Override
    public int k_() {
        return this.inventoryStacks.length;
    }

    @Override
    public ur a(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public ur a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            ur removed = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return removed;
        }
        ur removed = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return removed;
    }

    @Override
    public void a(int i, ur itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.c()) {
            itemstack.a = this.c();
        }
    }

    @Override
    public ur a_(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        ur toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int getSizeInventorySide(int side) {
        return 1;
    }

    @Override
    public int getStartInventorySide(int side) {
        switch (side) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 4;
    }

    @Override
    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (!RecipeManager.isLiquidResource(resource)) {
            return 0;
        }
        int used = this.resourceTank.fill(resource, doFill);
        if (doFill && used > 0) {
            this.tile.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public LiquidStack drain(ForgeDirection from, int quantityMax, boolean doEmpty) {
        return this.drain(0, quantityMax, doEmpty);
    }

    @Override
    public LiquidStack drain(int tankIndex, int quantityMax, boolean doEmpty) {
        if (tankIndex != 0) {
            return null;
        }
        return this.productTank.drain(quantityMax, doEmpty);
    }

    public TankSlot[] getTanks(ForgeDirection direction) {
        return new TankSlot[]{this.resourceTank, this.productTank};
    }

    @Override
    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (direction == this.tile.getOrientation().getRotation(ForgeDirection.UP)) {
            return this.resourceTank;
        }
        if (direction == this.tile.getOrientation().getRotation(ForgeDirection.DOWN)) {
            return this.productTank;
        }
        return null;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.lowFuel25);
        res.add(ForestryTrigger.lowFuel10);
        res.add(ForestryTrigger.lowResource25);
        res.add(ForestryTrigger.lowResource10);
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static void initialize() {
        RecipeUtil.injectLeveledRecipe(new ur(amq.B, 1, 0), GameMode.getGameMode().getFermentedPerSapling(), new ur(ForestryItem.liquidBiomass));
        RecipeUtil.injectLeveledRecipe(new ur(amq.B, 1, 1), GameMode.getGameMode().getFermentedPerSapling(), new ur(ForestryItem.liquidBiomass));
        RecipeUtil.injectLeveledRecipe(new ur(amq.B, 1, 2), GameMode.getGameMode().getFermentedPerSapling(), new ur(ForestryItem.liquidBiomass));
        RecipeUtil.injectLeveledRecipe(new ur(amq.B, 1, 3), GameMode.getGameMode().getFermentedPerSapling(), new ur(ForestryItem.liquidBiomass));
        RecipeUtil.injectLeveledRecipe(new ur(amq.aY), GameMode.getGameMode().getFermentedPerCacti(), new ur(ForestryItem.liquidBiomass));
        RecipeUtil.injectLeveledRecipe(new ur(up.T), GameMode.getGameMode().getFermentedPerWheat(), new ur(ForestryItem.liquidBiomass));
        RecipeUtil.injectLeveledRecipe(new ur(up.aJ), GameMode.getGameMode().getFermentedPerCane(), new ur(ForestryItem.liquidBiomass));
        RecipeUtil.injectLeveledRecipe(new ur((amq)amq.ai), GameMode.getGameMode().getFermentedPerMushroom(), new ur(ForestryItem.liquidBiomass));
        RecipeUtil.injectLeveledRecipe(new ur((amq)amq.aj), GameMode.getGameMode().getFermentedPerMushroom(), new ur(ForestryItem.liquidBiomass));
    }

    public static class RecipeManager
    implements IFermenterManager {
        public static ArrayList recipes = new ArrayList();

        @Override
        public void addRecipe(ur resource, int fermentationValue, float modifier, LiquidStack output, LiquidStack liquid) {
            recipes.add(new Recipe(resource, fermentationValue, modifier, output, liquid));
        }

        @Override
        public void addRecipe(ur resource, int fermentationValue, float modifier, LiquidStack output) {
            recipes.add(new Recipe(resource, fermentationValue, modifier, output, null));
        }

        public static Recipe findMatchingRecipe(ur res, LiquidStack liqu) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.matches(res, liqu)) continue;
                return recipe;
            }
            return null;
        }

        public static boolean isResource(ur resource) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.resource.a(resource)) continue;
                return true;
            }
            return false;
        }

        public static boolean isLiquidResource(LiquidStack liquid) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.liquid.isLiquidEqual(liquid)) continue;
                return true;
            }
            return false;
        }

        public static boolean isLiquidProduct(LiquidStack liquid) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.output.isLiquidEqual(liquid)) continue;
                return true;
            }
            return false;
        }

        @Override
        public List getRecipes() {
            HashMap<ur[], ur[]> recipeList = new HashMap<ur[], ur[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(new ur[]{recipe.resource, recipe.liquid.asItemStack()}, new ur[]{recipe.output.asItemStack()});
            }
            return (List)((Object)recipeList);
        }
    }

    public static class Recipe {
        public final ur resource;
        public final int fermentationValue;
        public final float modifier;
        public final LiquidStack output;
        public final LiquidStack liquid;

        public Recipe(ur resource, int fermentationValue, float modifier, LiquidStack output, LiquidStack liquid) {
            this.resource = resource;
            this.fermentationValue = fermentationValue;
            this.modifier = modifier;
            this.output = output;
            this.liquid = liquid;
        }

        public boolean matches(ur res, LiquidStack liqu) {
            if (res == null) {
                return false;
            }
            if (this.resource.c != res.c) {
                return false;
            }
            if (this.resource.j() >= 0 && this.resource.j() != res.j()) {
                return false;
            }
            if (this.liquid == null) {
                return true;
            }
            if (this.liquid != null && liqu == null) {
                return false;
            }
            if (!this.liquid.isLiquidEqual(liqu)) {
                return false;
            }
            return this.liquid.amount <= liqu.amount;
        }
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(any tile) {
            return new MachineFermenter((TileMachine)tile);
        }
    }
}

