/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.recipes.IFabricatorManager;
import forestry.api.recipes.RecipeManagers;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.interfaces.ICrafter;
import forestry.core.interfaces.ICraftingPlan;
import forestry.core.network.GuiId;
import forestry.core.utils.GenericInventoryAdapter;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.core.utils.StackUtils;
import forestry.core.utils.TankSlot;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidStack;

public class MachineFabricator
extends Machine
implements ICrafter {
    private static final int MAX_HEAT = 5000;
    public static final short SLOT_METAL = 0;
    public static final short SLOT_PLAN = 1;
    public static final short SLOT_RESULT = 2;
    public static final short SLOT_CRAFTING_1 = 3;
    public static final short SLOT_INVENTORY_1 = 12;
    public static final short SLOT_INVENTORY_COUNT = 18;
    private GenericInventoryAdapter inventory = new GenericInventoryAdapter(30, "Items");
    private TankSlot moltenTank = new TankSlot(2000);
    private int heat = 0;
    private int guiMeltingPoint = 0;
    private LiquidStack pendingSmelt;

    public MachineFabricator(TileMachine tile) {
        super(tile);
    }

    @Override
    public String getName() {
        return "tile.machine.11";
    }

    @Override
    public void openGui(qx player, la tile) {
        player.openGui(ForestryAPI.instance, GuiId.FabricatorGUI.ordinal(), player.p, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("Heat", this.heat);
        bq nbtMoltenTank = new bq();
        this.moltenTank.writeToNBT(nbtMoltenTank);
        nbttagcompound.a("MoltenTank", (cd)nbtMoltenTank);
        if (this.pendingSmelt != null) {
            bq smelt = new bq();
            this.pendingSmelt.writeToNBT(smelt);
            nbttagcompound.a("PendingSmelt", (cd)smelt);
        }
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.heat = nbttagcompound.e("Heat");
        this.moltenTank = new TankSlot(2000);
        if (nbttagcompound.b("MoltenTank")) {
            this.moltenTank.readFromNBT(nbttagcompound.l("MoltenTank"));
        }
        if (nbttagcompound.b("PendingSmelt")) {
            bq smelt = nbttagcompound.l("PendingSmelt");
            this.pendingSmelt = LiquidStack.loadLiquidStackFromNBT((bq)smelt);
        }
        this.inventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void updateServerSide() {
        Smelting smelt;
        if (this.moltenTank.quantity > 0 && (smelt = RecipeManager.findMatchingSmelting(this.moltenTank.asLiquidStack())) != null && this.heat < smelt.meltingPoint) {
            this.moltenTank.drain(5, true);
        }
        if (this.pendingSmelt != null) {
            int filled = this.moltenTank.fill(this.pendingSmelt, true);
            this.pendingSmelt.amount -= filled;
            if (this.pendingSmelt.amount <= 0) {
                this.pendingSmelt = null;
            }
        } else if (this.moltenTank.quantity < this.moltenTank.capacity && this.inventory.a(0) != null && (smelt = RecipeManager.findMatchingSmelting(this.inventory.a(0))) != null && smelt.meltingPoint <= this.heat) {
            this.a(0, 1);
            this.pendingSmelt = smelt.product.copy();
        }
        this.dissipateHeat();
    }

    @Override
    public boolean doWork() {
        return this.addHeat(25);
    }

    private boolean addHeat(int addition) {
        if (this.heat >= 5000) {
            return false;
        }
        this.heat += addition;
        if (this.heat > 5000) {
            this.heat = 5000;
        }
        return true;
    }

    private void dissipateHeat() {
        if (this.heat > 2500) {
            this.heat -= 2;
        } else if (this.heat > 0) {
            --this.heat;
        }
    }

    public Object[] getPlan() {
        if (this.inventory.a(1) == null) {
            return null;
        }
        Recipe myRecipe = RecipeManager.findMatchingRecipe(this.inventory.a(1));
        if (myRecipe == null) {
            return null;
        }
        return myRecipe.internal.getIngredients();
    }

    @Override
    public ur getResult() {
        Recipe myRecipe = RecipeManager.findMatchingRecipe(this.inventory.a(1), this.moltenTank.asLiquidStack(), this.inventory.getStacks(3, 9));
        if (myRecipe == null) {
            return null;
        }
        return myRecipe.internal.b().l();
    }

    @Override
    public ur takeResult(boolean consumeRecipe) {
        up planItem;
        Recipe myRecipe = RecipeManager.findMatchingRecipe(this.inventory.a(1), this.moltenTank.asLiquidStack(), this.inventory.getStacks(3, 9));
        if (myRecipe == null) {
            return null;
        }
        LiquidStack liquid = myRecipe.molten;
        if (this.removeFromInventory(1, this.inventory.getStacks(3, 9), false)) {
            this.removeFromInventory(1, this.inventory.getStacks(3, 9), true);
            this.moltenTank.drain(liquid.amount, true);
        } else if (consumeRecipe) {
            this.removeFromCraftMatrix(myRecipe);
            this.moltenTank.drain(liquid.amount, true);
        } else {
            return null;
        }
        ur result = myRecipe.internal.b().l();
        if (this.inventory.a(1) != null && (planItem = this.inventory.a(1).b()) instanceof ICraftingPlan) {
            this.inventory.a(1, ((ICraftingPlan)planItem).planUsed(this.inventory.a(1), result));
        }
        return result;
    }

    private void removeFromCraftMatrix(Recipe recipe) {
        for (int i = 0; i < 9; ++i) {
            if (this.inventory.a(3 + i) == null) continue;
            this.inventory.a(3 + i, 1);
        }
    }

    private boolean removeFromInventory(int count, ur[] set, boolean doRemove) {
        boolean hasRemoved = true;
        for (int i = 0; i < count; ++i) {
            ur[] condensedSet;
            for (ur req : condensedSet = StackUtils.condenseStacks(set)) {
                for (int j = 12; j < 30; ++j) {
                    ur pol = this.inventory.a(j);
                    if (pol == null || !StackUtils.isItemOreEqual(pol, req)) continue;
                    if (pol.a > req.a) {
                        if (doRemove) {
                            this.inventory.a(j, req.a);
                        }
                        req.a = 0;
                        continue;
                    }
                    if (doRemove) {
                        this.inventory.a(j, req.a);
                    }
                    req.a -= pol.a;
                }
            }
            boolean hasLeft = false;
            for (ur req : condensedSet) {
                if (req == null || req.a <= 0) continue;
                hasLeft = true;
            }
            if (!hasLeft) continue;
            hasRemoved = false;
        }
        return hasRemoved;
    }

    @Override
    public boolean isWorking() {
        return this.heat <= 5000;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 5000;
    }

    public int getMeltingPoint() {
        Smelting smelt;
        if (this.moltenTank.quantity > 0) {
            Smelting smelt2 = RecipeManager.findMatchingSmelting(this.moltenTank.asLiquidStack());
            if (smelt2 != null) {
                return smelt2.meltingPoint;
            }
        } else if (this.a(0) != null && (smelt = RecipeManager.findMatchingSmelting(this.a(0))) != null) {
            return smelt.meltingPoint;
        }
        return 0;
    }

    public int getMeltingPointScaled(int i) {
        if (this.guiMeltingPoint > 0) {
            return this.guiMeltingPoint * i / 5000;
        }
        int meltingPoint = this.getMeltingPoint();
        if (meltingPoint <= 0) {
            return 0;
        }
        return meltingPoint * i / 5000;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.moltenTank.liquidId = j;
                break;
            }
            case 1: {
                this.moltenTank.quantity = j;
                break;
            }
            case 2: {
                this.heat = j;
                break;
            }
            case 3: {
                this.guiMeltingPoint = j;
                break;
            }
            case 4: {
                this.moltenTank.liquidMeta = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(rq container, rw iCrafting) {
        iCrafting.a(container, 0, this.moltenTank.liquidId);
        iCrafting.a(container, 1, this.moltenTank.quantity);
        iCrafting.a(container, 2, this.heat);
        iCrafting.a(container, 3, this.getMeltingPoint());
        iCrafting.a(container, 4, this.moltenTank.liquidMeta);
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        if (from == ForgeDirection.UP && RecipeManager.findMatchingSmelting(stack) != null) {
            return this.inventory.addStack(stack, 0, 1, false, doAdd);
        }
        return this.inventory.addStack(stack, 12, 18, false, doAdd);
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        ur taken = doRemove ? this.takeResult(false) : this.getResult();
        if (taken != null) {
            return new ur[]{taken};
        }
        return new ur[0];
    }

    @Override
    public int k_() {
        return this.inventory.k_();
    }

    @Override
    public ur a(int i) {
        return this.inventory.a(i);
    }

    @Override
    public ur a(int i, int j) {
        return this.inventory.a(i, j);
    }

    @Override
    public void a(int i, ur itemstack) {
        this.inventory.a(i, itemstack);
    }

    @Override
    public int c() {
        return this.inventory.c();
    }

    @Override
    public ur a_(int slot) {
        return this.inventory.a_(slot);
    }

    public TankSlot[] getTanks(ForgeDirection direction) {
        return new TankSlot[]{this.moltenTank};
    }

    public static void initialize() {
        RecipeManagers.fabricatorManager.addSmelting(new ur(amq.P), new LiquidStack(ForestryItem.liquidGlass, 1000), 1000);
        RecipeManagers.fabricatorManager.addSmelting(new ur(amq.bt), new LiquidStack(ForestryItem.liquidGlass, 375), 1000);
        RecipeManagers.fabricatorManager.addSmelting(new ur(amq.H), new LiquidStack(ForestryItem.liquidGlass, 1000), 3000);
    }

    public static class RecipeManager
    implements IFabricatorManager {
        public static ArrayList recipes = new ArrayList();
        private static ArrayList smeltings = new ArrayList();

        @Override
        public void addRecipe(ur plan, LiquidStack molten, ur result, Object[] pattern) {
            recipes.add(new Recipe(plan, molten, ShapedRecipeCustom.createShapedRecipe(pattern, result)));
        }

        @Override
        public void addSmelting(ur resource, LiquidStack molten, int meltingPoint) {
            smeltings.add(new Smelting(resource, molten, meltingPoint));
        }

        public static Recipe findMatchingRecipe(ur plan) {
            for (Recipe recipe : recipes) {
                if (!recipe.matches(plan)) continue;
                return recipe;
            }
            return null;
        }

        public static Recipe findMatchingRecipe(ur plan, LiquidStack liquid, ur[] resources) {
            ur[][] gridResources = new ur[3][3];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    gridResources[j][i] = resources[i * 3 + j];
                }
            }
            for (Recipe recipe : recipes) {
                if (!recipe.matches(plan, gridResources) || !recipe.hasLiquid(liquid)) continue;
                return recipe;
            }
            return null;
        }

        public static boolean isResourceLiquid(LiquidStack liquid) {
            for (Recipe recipe : recipes) {
                if (!recipe.hasLiquid(liquid)) continue;
                return true;
            }
            return false;
        }

        public static Smelting findMatchingSmelting(ur resource) {
            if (resource == null) {
                return null;
            }
            for (Smelting smelting : smeltings) {
                if (!smelting.matches(resource)) continue;
                return smelting;
            }
            return null;
        }

        public static Smelting findMatchingSmelting(LiquidStack product) {
            if (product == null) {
                return null;
            }
            for (Smelting smelting : smeltings) {
                if (!smelting.matches(product)) continue;
                return smelting;
            }
            return null;
        }

        @Override
        public List getRecipes() {
            return null;
        }
    }

    public static class Smelting {
        ur resource;
        LiquidStack product;
        int meltingPoint;

        public Smelting(ur resource, LiquidStack molten, int meltingPoint) {
            this.resource = resource;
            this.product = molten;
            this.meltingPoint = meltingPoint;
        }

        public boolean matches(ur resource) {
            return this.resource.a(resource);
        }

        public boolean matches(LiquidStack product) {
            return this.product.isLiquidEqual(product);
        }
    }

    public static class Recipe {
        ur plan;
        LiquidStack molten;
        ShapedRecipeCustom internal;

        public Recipe(ur plan, LiquidStack molten, ShapedRecipeCustom internal) {
            this.plan = plan;
            this.molten = molten;
            this.internal = internal;
        }

        public boolean matches(ur plan) {
            if (this.plan == null) {
                return true;
            }
            if (plan == null && this.plan == null) {
                return true;
            }
            if (plan == null && this.plan != null) {
                return false;
            }
            if (this.plan.j() < 0) {
                return plan.c == this.plan.c;
            }
            return plan.a(this.plan);
        }

        public boolean matches(ur plan, ur[][] resources) {
            if (!this.matches(plan)) {
                return false;
            }
            return this.internal.matches(resources);
        }

        public boolean hasLiquid(LiquidStack resource) {
            if (!resource.isLiquidEqual(this.molten)) {
                return false;
            }
            return this.molten.amount <= resource.amount;
        }

        public LiquidStack getLiquid() {
            return this.molten;
        }

        public wp asIRecipe() {
            return this.internal;
        }
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(any tile) {
            return new MachineFabricator((TileMachine)tile);
        }
    }
}

