/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.render;

import forestry.core.ForestryClient;
import forestry.core.TemperatureState;
import forestry.core.gadgets.Engine;
import forestry.core.gadgets.TileEngine;
import forestry.core.interfaces.IBlockRenderer;
import forestry.core.proxy.Proxies;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderEngine
implements IBlockRenderer {
    private axa model = new axa(){};
    private String gfxBase;
    private ayf boiler = new ayf(this.model, 0, 0);
    private ayf trunk;
    private ayf piston;
    private ayf extension;

    public RenderEngine() {
        this.boiler.a(-8.0f, -8.0f, -8.0f, 16, 6, 16);
        this.boiler.c = 8.0f;
        this.boiler.d = 8.0f;
        this.boiler.e = 8.0f;
        this.trunk = new ayf(this.model, 0, 0);
        this.trunk.a(-4.0f, -4.0f, -4.0f, 8, 12, 8);
        this.trunk.c = 8.0f;
        this.trunk.d = 8.0f;
        this.trunk.e = 8.0f;
        this.piston = new ayf(this.model, 0, 0);
        this.piston.a(-6.0f, -2.0f, -6.0f, 12, 4, 12);
        this.piston.c = 8.0f;
        this.piston.d = 8.0f;
        this.piston.e = 8.0f;
        this.extension = new ayf(this.model, 0, 0);
        this.extension.a(-5.0f, -3.0f, -5.0f, 10, 2, 10);
        this.extension.c = 8.0f;
        this.extension.d = 8.0f;
        this.extension.e = 8.0f;
    }

    public RenderEngine(String baseTexture) {
        this();
        this.gfxBase = baseTexture;
    }

    @Override
    public void preloadTextures() {
        ForestryClient.preloadTexture(this.gfxBase + "base.png");
        ForestryClient.preloadTexture(this.gfxBase + "extension.png");
        ForestryClient.preloadTexture(this.gfxBase + "piston.png");
        ForestryClient.preloadTexture("/gfx/forestry/blocks/engine_trunk_low.png");
        ForestryClient.preloadTexture("/gfx/forestry/blocks/engine_trunk_medium.png");
        ForestryClient.preloadTexture("/gfx/forestry/blocks/engine_trunk_high.png");
        ForestryClient.preloadTexture("/gfx/forestry/blocks/engine_trunk_higher.png");
        ForestryClient.preloadTexture("/gfx/forestry/blocks/engine_trunk_highest.png");
    }

    @Override
    public void inventoryRender(double x2, double y2, double z2, float f, float f1) {
        this.render(TemperatureState.COOL, 0.25f, ForgeDirection.UP, x2, y2, z2);
    }

    @Override
    public void renderTileEntityAt(any tileentity, double d, double d1, double d2, float f) {
        TileEngine engineTile = (TileEngine)tileentity;
        Engine engine = engineTile.getEngine();
        if (engine != null) {
            this.render(engine.getTemperatureState(), engine.progress, engineTile.getOrientation(), d, d1, d2);
        }
    }

    private void render(TemperatureState state, float progress, ForgeDirection orientation, double x2, double y2, double z2) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)((float)x2), (float)((float)y2), (float)((float)z2));
        float step = (double)progress > 0.5 ? 5.99f - (progress - 0.5f) * 2.0f * 5.99f : progress * 2.0f * 5.99f;
        float[] angle = new float[]{0.0f, 0.0f, 0.0f};
        float[] translate = new float[]{0.0f, 0.0f, 0.0f};
        float tfactor = step / 16.0f;
        switch (orientation) {
            case EAST: {
                angle[2] = -1.5707964f;
                translate[0] = 1.0f;
                break;
            }
            case WEST: {
                angle[2] = 1.5707964f;
                translate[0] = -1.0f;
                break;
            }
            case UP: {
                translate[1] = 1.0f;
                break;
            }
            case DOWN: {
                angle[2] = (float)Math.PI;
                translate[1] = -1.0f;
                break;
            }
            case SOUTH: {
                angle[0] = 1.5707964f;
                translate[2] = 1.0f;
                break;
            }
            default: {
                angle[0] = -1.5707964f;
                translate[2] = -1.0f;
            }
        }
        this.boiler.f = angle[0];
        this.boiler.g = angle[1];
        this.boiler.h = angle[2];
        this.trunk.f = angle[0];
        this.trunk.g = angle[1];
        this.trunk.h = angle[2];
        this.piston.f = angle[0];
        this.piston.g = angle[1];
        this.piston.h = angle[2];
        this.extension.f = angle[0];
        this.extension.g = angle[1];
        this.extension.h = angle[2];
        float factor = 0.0625f;
        Proxies.common.bindTexture(this.gfxBase + "base.png");
        this.boiler.a(factor);
        Proxies.common.bindTexture(this.gfxBase + "piston.png");
        GL11.glTranslatef((float)(translate[0] * tfactor), (float)(translate[1] * tfactor), (float)(translate[2] * tfactor));
        this.piston.a(factor);
        GL11.glTranslatef((float)(-translate[0] * tfactor), (float)(-translate[1] * tfactor), (float)(-translate[2] * tfactor));
        Proxies.common.bindTexture(this.gfxBase + "extension.png");
        float chamberf = 0.125f;
        int i = 0;
        while ((float)i <= step + 2.0f) {
            this.extension.a(factor);
            GL11.glTranslatef((float)(translate[0] * chamberf), (float)(translate[1] * chamberf), (float)(translate[2] * chamberf));
            i += 2;
        }
        i = 0;
        while ((float)i <= step + 2.0f) {
            GL11.glTranslatef((float)(-translate[0] * chamberf), (float)(-translate[1] * chamberf), (float)(-translate[2] * chamberf));
            i += 2;
        }
        String texture = "";
        switch (state) {
            case OVERHEATING: {
                texture = "/gfx/forestry/blocks/engine_trunk_highest.png";
                break;
            }
            case RUNNING_HOT: {
                texture = "/gfx/forestry/blocks/engine_trunk_higher.png";
                break;
            }
            case OPERATING_TEMPERATURE: {
                texture = "/gfx/forestry/blocks/engine_trunk_high.png";
                break;
            }
            case WARMED_UP: {
                texture = "/gfx/forestry/blocks/engine_trunk_medium.png";
                break;
            }
            default: {
                texture = "/gfx/forestry/blocks/engine_trunk_low.png";
            }
        }
        Proxies.common.bindTexture(texture);
        this.trunk.a(factor);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }
}

