/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gui;

import forestry.core.gadgets.TileEngine;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.GfxSlot;
import forestry.core.gui.GfxSlotManager;
import forestry.core.gui.LiquidTankSlot;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import forestry.energy.gadgets.EngineBronze;
import forestry.energy.gui.ContainerEngineBronze;
import forestry.energy.gui.GuiEngine;
import org.lwjgl.opengl.GL11;

public class GuiEngineBronze
extends GuiEngine {
    public GuiEngineBronze(qw inventory, TileEngine tile) {
        super("/gfx/forestry/gui/bioengine.png", (ContainerForestry)new ContainerEngineBronze(inventory, tile), tile);
        this.slotManager.add(new LiquidTankSlot(this.slotManager, 89, 19, tile, 0));
        this.slotManager.add(new LiquidTankSlot(this.slotManager, 107, 19, tile, 1));
        this.slotManager.add(new BiogasSlot(this.slotManager, 30, 47, (EngineBronze)tile.getEngine()));
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        String name = StringUtil.localize("tile.engine.0");
        this.l.b(name, this.getCenteredOffset(name), 6, this.fontColor.get("gui.title"));
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int i, int j) {
        this.drawBackground();
        EngineBronze engine = (EngineBronze)this.tile.getMachine();
        int temp = engine.getOperatingTemperatureScaled(16);
        if (temp > 16) {
            temp = 16;
        }
        if (temp > 0) {
            this.b(this.guiLeft + 53, this.guiTop + 47 + 16 - temp, 176, 76 - temp, 4, temp);
        }
    }

    protected class BiogasSlot
    extends GfxSlot {
        EngineBronze engine;

        public BiogasSlot(GfxSlotManager manager, int xPos, int yPos, EngineBronze engine) {
            super(manager, xPos, yPos);
            this.engine = engine;
            this.height = 16;
        }

        @Override
        public void draw(int startX, int startY) {
            int x2;
            if (this.engine == null || this.engine.totalTime <= 0) {
                return;
            }
            up content = null;
            int liquidImgIndex = 0;
            int squaled = this.engine.burnTime * this.height / this.engine.totalTime;
            if (squaled > this.height) {
                squaled = this.height;
            }
            if (this.engine.currentLiquidId <= 0) {
                return;
            }
            int liquidId = this.engine.currentLiquidId;
            int liquidMeta = this.engine.currentLiquidMeta;
            if (liquidId < amq.p.length && amq.p[liquidId] != null) {
                content = amq.p[liquidId];
                liquidImgIndex = amq.p[liquidId].cl;
                Proxies.common.bindTexture(((amq)content).getTextureFile());
            } else {
                content = up.e[liquidId];
                liquidImgIndex = up.e[liquidId].b(liquidMeta);
                Proxies.common.bindTexture(content.getTextureFile());
            }
            int imgLine = liquidImgIndex / 16;
            int imgColumn = liquidImgIndex - imgLine * 16;
            int start = 0;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            do {
                x2 = 0;
                if (squaled > 16) {
                    x2 = 16;
                    squaled -= 16;
                } else {
                    x2 = squaled;
                    squaled = 0;
                }
                GuiEngineBronze.this.b(startX + this.xPos, startY + this.yPos + this.height - x2 - start, imgColumn * 16, imgLine * 16, 16, 16 - (16 - x2));
                start += 16;
            } while (x2 != 0 && squaled != 0);
            int tex = ((GuiEngineBronze)GuiEngineBronze.this).f.o.b(GuiEngineBronze.this.textureFile);
            ((GuiEngineBronze)GuiEngineBronze.this).f.o.b(tex);
        }

        @Override
        public String getTooltip(qx player) {
            if (this.engine.currentLiquidId <= 0) {
                return StringUtil.localize("gui.empty");
            }
            String tooltip = up.e[this.engine.currentLiquidId].l(new ur(this.engine.currentLiquidId, 1, this.engine.currentLiquidMeta));
            return tooltip;
        }
    }
}

