/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gui;

import forestry.core.gadgets.Engine;
import forestry.core.gadgets.TileInventory;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.Ledger;
import forestry.core.utils.StringUtil;

public abstract class GuiEngine
extends GuiForestry {
    public GuiEngine(String texture, ContainerForestry container, TileInventory tile) {
        super(texture, container, (la)tile);
    }

    @Override
    protected void initLedgers(Object inventory) {
        super.initLedgers(inventory);
        this.ledgerManager.insert(new EngineLedger((Engine)this.tile.getMachine()));
    }

    protected class EngineLedger
    extends Ledger {
        private Engine engine;

        public EngineLedger(Engine engine) {
            super(GuiEngine.this.ledgerManager);
            this.engine = engine;
            this.maxHeight = 94;
            this.overlayColor = GuiEngine.this.fontColor.get("ledger.power.background");
        }

        @Override
        public void draw(int x2, int y2) {
            this.drawBackground(x2, y2);
            this.drawIcon("/gfx/forestry/gui/misc.png", 0, x2 + 3, y2 + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiEngine.this.l.a(StringUtil.localize("gui.energy"), x2 + 22, y2 + 8, GuiEngine.this.fontColor.get("ledger.power.header"));
            GuiEngine.this.l.a(StringUtil.localize("gui.currentOutput") + ":", x2 + 22, y2 + 20, GuiEngine.this.fontColor.get("ledger.power.subheader"));
            GuiEngine.this.l.b(this.engine.getCurrentOutput() + " MJ/t", x2 + 22, y2 + 32, GuiEngine.this.fontColor.get("ledger.power.text"));
            GuiEngine.this.l.a(StringUtil.localize("gui.stored") + ":", x2 + 22, y2 + 44, GuiEngine.this.fontColor.get("ledger.power.subheader"));
            GuiEngine.this.l.b(this.engine.getEnergyStored() + " MJ", x2 + 22, y2 + 56, GuiEngine.this.fontColor.get("ledger.power.text"));
            GuiEngine.this.l.a(StringUtil.localize("gui.heat") + ":", x2 + 22, y2 + 68, GuiEngine.this.fontColor.get("ledger.power.subheader"));
            GuiEngine.this.l.b((double)this.engine.getHeat() / 10.0 + " C", x2 + 22, y2 + 80, GuiEngine.this.fontColor.get("ledger.power.text"));
        }

        @Override
        public String getTooltip() {
            return this.engine.getCurrentOutput() + " MJ/t";
        }
    }
}

