/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.FuelManager;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.Engine;
import forestry.core.gadgets.EngineFactory;
import forestry.core.gadgets.TileEngine;
import forestry.core.network.GuiId;
import forestry.core.network.IndexInPayload;
import forestry.core.network.PacketPayload;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.TankSlot;
import forestry.core.utils.TileInventoryAdapter;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidStack;

public class EngineBronze
extends Engine {
    public static final short SLOT_CAN = 0;
    public TankSlot fuelTank = new TankSlot(10000);
    public TankSlot heatingTank = new TankSlot(10000);
    private TileInventoryAdapter inventory;
    public int currentLiquidId;
    public int currentLiquidMeta;
    public int burnTime;
    public int totalTime;
    private boolean shutdown;

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = super.getPacketPayload();
        if (this.shutdown) {
            payload.append(new int[]{1});
        } else {
            payload.append(new int[]{0});
        }
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload, IndexInPayload index) {
        super.fromPacketPayload(payload, index);
        this.shutdown = payload.intPayload[index.intIndex + 6] > 0;
    }

    public EngineBronze(TileEngine engine) {
        super(engine);
        this.setHints((String[])Config.hints.get("engine.bronze"));
        this.maxEnergy = 100000;
        this.maxEnergyExtracted = 500;
        this.maxHeat = 10000;
        this.inventory = new TileInventoryAdapter(engine, 1, "Items");
    }

    @Override
    public void openGui(qx player, la tile) {
        player.openGui(ForestryAPI.instance, GuiId.EngineBronzeGUI.ordinal(), player.p, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void updateServerSide() {
        LiquidContainerData container;
        super.updateServerSide();
        if (this.inventory.a(0) != null && (container = LiquidHelper.getLiquidContainer(this.inventory.a(0))) != null) {
            TankSlot tank = null;
            if (container.stillLiquid.isLiquidEqual(new LiquidStack(amq.G.cm, 1))) {
                tank = this.heatingTank;
            } else if (FuelManager.bronzeEngineFuel.containsKey(container.stillLiquid.asItemStack())) {
                tank = this.fuelTank;
            }
            if (tank != null) {
                this.inventory.a(0, this.replenishByContainer(this.inventory.a(0), container, tank));
                if (this.inventory.a((int)0).a <= 0) {
                    this.inventory.a(0, null);
                }
            }
        }
        if (this.tile.k.G() % 20L * 10L != 0L) {
            return;
        }
        if (this.getHeatLevel() <= 0.2 && this.heatingTank.quantity <= 0) {
            this.setErrorState(EnumErrorCode.NOHEAT);
        } else if (this.burnTime <= 0 && this.fuelTank.quantity <= 0) {
            this.setErrorState(EnumErrorCode.NOFUEL);
        } else {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public void burn() {
        this.currentOutput = 0;
        if (this.tile.isActivated() && (this.fuelTank.quantity >= 1000 || this.burnTime > 0)) {
            double heatStage = this.getHeatLevel();
            if (heatStage > 0.25 && this.shutdown) {
                this.shutdown(false);
            } else if (this.shutdown && this.heatingTank.quantity > 0 && this.heatingTank.liquidId == amq.G.cm) {
                this.addHeat(20);
                --this.heatingTank.quantity;
            }
            if (heatStage > 0.2) {
                if (this.burnTime > 0) {
                    --this.burnTime;
                    if (this.currentLiquidId > 0) {
                        this.currentOutput = this.determineFuelValue(new ur(this.currentLiquidId, 1, this.currentLiquidMeta));
                        this.addEnergy(this.currentOutput);
                    }
                } else {
                    this.burnTime = this.totalTime = this.determineBurnTime(this.fuelTank.getLiquid().asItemStack());
                    this.currentLiquidId = this.fuelTank.liquidId;
                    this.currentLiquidMeta = this.fuelTank.liquidMeta;
                    this.fuelTank.drain(1000, true);
                }
            } else {
                this.shutdown(true);
            }
        }
    }

    private void shutdown(boolean val) {
        this.shutdown = val;
    }

    @Override
    public int dissipateHeat() {
        EngineBronzeFuel fuel;
        double heatStage;
        if (this.heat <= 0) {
            return 0;
        }
        int loss = 1;
        if (!this.isBurning()) {
            ++loss;
        }
        if ((heatStage = this.getHeatLevel()) > 0.55) {
            ++loss;
        }
        if ((fuel = (EngineBronzeFuel)FuelManager.bronzeEngineFuel.get(new ur(this.currentLiquidId, 1, this.currentLiquidMeta))) != null) {
            loss *= fuel.dissipationMultiplier;
        }
        this.heat -= loss;
        return loss;
    }

    @Override
    public int generateHeat() {
        int generate = 0;
        if (this.tile.isActivated()) {
            double heatStage = this.getHeatLevel();
            if (heatStage >= 0.75) {
                generate += 3;
            } else if (heatStage > 0.24) {
                generate += 2;
            } else if (heatStage > 0.2) {
                ++generate;
            }
        }
        this.heat += generate;
        return generate;
    }

    private int determineFuelValue(ur item) {
        if (FuelManager.bronzeEngineFuel.containsKey(item)) {
            return ((EngineBronzeFuel)FuelManager.bronzeEngineFuel.get((Object)item)).powerPerCycle;
        }
        return 0;
    }

    private int determineBurnTime(ur item) {
        if (FuelManager.bronzeEngineFuel.containsKey(item)) {
            return ((EngineBronzeFuel)FuelManager.bronzeEngineFuel.get((Object)item)).burnDuration;
        }
        return 0;
    }

    @Override
    public boolean isBurning() {
        return this.mayBurn() && this.burnTime > 0;
    }

    @Override
    public int getBurnTimeRemainingScaled(int i) {
        if (this.totalTime == 0) {
            return 0;
        }
        return this.burnTime * i / this.totalTime;
    }

    public int getOperatingTemperatureScaled(int i) {
        return (int)Math.round((double)(this.heat * i) / ((double)this.maxHeat * 0.2));
    }

    public int getFuelScaled(int i) {
        return this.fuelTank.quantity * i / 10000;
    }

    public int getHeatingFuelScaled(int i) {
        return this.heatingTank.quantity * i / 10000;
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.b("CurrentLiquidId")) {
            this.currentLiquidId = nbttagcompound.e("CurrentLiquidId");
        }
        if (nbttagcompound.b("CurrentLiquidMeta")) {
            this.currentLiquidMeta = nbttagcompound.e("CurrentLiquidMeta");
        }
        this.burnTime = nbttagcompound.e("EngineBurnTime");
        this.totalTime = nbttagcompound.e("EngineTotalTime");
        this.fuelTank = new TankSlot(10000);
        this.heatingTank = new TankSlot(10000);
        if (nbttagcompound.b("FuelSlot")) {
            this.fuelTank.readFromNBT(nbttagcompound.l("FuelSlot"));
            this.heatingTank.readFromNBT(nbttagcompound.l("HeatingSlot"));
        }
        this.inventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("CurrentLiquidId", this.currentLiquidId);
        nbttagcompound.a("CurrentLiquidMeta", this.currentLiquidMeta);
        nbttagcompound.a("EngineBurnTime", this.burnTime);
        nbttagcompound.a("EngineTotalTime", this.totalTime);
        bq nbtFuelSlot = new bq();
        bq nbtHeatingSlot = new bq();
        this.fuelTank.writeToNBT(nbtFuelSlot);
        this.heatingTank.writeToNBT(nbtHeatingSlot);
        nbttagcompound.a("FuelSlot", (cd)nbtFuelSlot);
        nbttagcompound.a("HeatingSlot", (cd)nbtHeatingSlot);
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.burnTime = j;
                break;
            }
            case 1: {
                this.totalTime = j;
                break;
            }
            case 2: {
                this.fuelTank.liquidId = j;
                break;
            }
            case 3: {
                this.fuelTank.quantity = j;
                break;
            }
            case 4: {
                this.heatingTank.liquidId = j;
                break;
            }
            case 5: {
                this.heatingTank.quantity = j;
                break;
            }
            case 6: {
                this.currentOutput = j;
                break;
            }
            case 7: {
                this.storedEnergy = j;
                break;
            }
            case 8: {
                this.heat = j;
                break;
            }
            case 9: {
                this.currentLiquidId = j;
                break;
            }
            case 10: {
                this.currentLiquidMeta = j;
                break;
            }
            case 11: {
                this.fuelTank.liquidMeta = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(rq containerEngine, rw iCrafting) {
        iCrafting.a(containerEngine, 0, this.burnTime);
        iCrafting.a(containerEngine, 1, this.totalTime);
        iCrafting.a(containerEngine, 2, this.fuelTank.liquidId);
        iCrafting.a(containerEngine, 3, this.fuelTank.quantity);
        iCrafting.a(containerEngine, 4, this.heatingTank.liquidId);
        iCrafting.a(containerEngine, 5, this.heatingTank.quantity);
        iCrafting.a(containerEngine, 6, this.currentOutput);
        iCrafting.a(containerEngine, 7, this.storedEnergy);
        iCrafting.a(containerEngine, 8, this.heat);
        iCrafting.a(containerEngine, 9, this.currentLiquidId);
        iCrafting.a(containerEngine, 10, this.currentLiquidMeta);
        iCrafting.a(containerEngine, 11, this.fuelTank.liquidMeta);
    }

    @Override
    public int k_() {
        return this.inventory.k_();
    }

    @Override
    public ur a(int i) {
        return this.inventory.a(i);
    }

    @Override
    public void a(int i, ur itemstack) {
        this.inventory.a(i, itemstack);
    }

    @Override
    public ur a(int i, int j) {
        return this.inventory.a(i, j);
    }

    @Override
    public ur a_(int slot) {
        return this.inventory.a_(slot);
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        LiquidContainerData container = LiquidHelper.getLiquidContainer(stack);
        if (container == null) {
            return 0;
        }
        return this.inventory.addStack(stack, false, doAdd);
    }

    @Override
    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        int used = 0;
        if (FuelManager.bronzeEngineFuel.containsKey(resource.asItemStack())) {
            used = this.fuelTank.fill(resource, doFill);
        }
        if (resource.itemID == amq.G.cm) {
            used = this.heatingTank.fill(resource, doFill);
        }
        return used;
    }

    @Override
    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (tankIndex == 0) {
            return this.fuelTank.fill(resource, doFill);
        }
        if (tankIndex == 1) {
            return this.heatingTank.fill(resource, doFill);
        }
        return 0;
    }

    @Override
    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new TankSlot[]{this.fuelTank, this.heatingTank};
    }

    @Override
    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.fuelTank;
    }

    public static class Factory
    extends EngineFactory {
        @Override
        public Engine createEngine(any tile) {
            return new EngineBronze((TileEngine)tile);
        }
    }
}

