/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation.planters;

import forestry.api.core.GlobalManager;
import forestry.api.cultivation.ICropProvider;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.TileMachine;
import forestry.core.proxy.Proxies;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.StructureBlueprint;
import forestry.core.utils.StructureConstruction;
import forestry.core.utils.TileInventoryAdapter;
import forestry.core.utils.Vect;
import forestry.cultivation.gadgets.TilePlanter;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;

public abstract class Planter
extends Machine {
    public static final short SLOT_SOIL_1 = 0;
    public static final short SLOT_GERMLING_1 = 4;
    public static final short SLOT_WASTE_1 = 8;
    public static final short SLOT_COUNT_PART = 4;
    public ur validSoil;
    public ur validGround;
    public ur validWaste;
    public ur validDisposal;
    public StructureBlueprint site;
    public Vect siteOffset;
    public StructureBlueprint soil;
    public Vect soilOffset;
    public StructureBlueprint plantation;
    public Vect plantationOffset;
    protected boolean requiresSoil = true;
    protected boolean requiresGermling = false;
    protected ArrayList cropProviders = new ArrayList();
    protected TileInventoryAdapter inventory;
    protected StructureConstruction templateArboretum;
    protected boolean isCleared = false;
    protected boolean isUnbroken = false;
    protected StructureConstruction templateSoil;
    protected StructureConstruction templateWater;
    protected StructureConstruction templatePlantation;

    @Override
    public abstract void openGui(qx var1, la var2);

    public boolean hasGermlingBySeed(ur germling) {
        for (ICropProvider provider : this.cropProviders) {
            if (!provider.isGermling(germling)) continue;
            return true;
        }
        return false;
    }

    private ICropProvider getCropProvider(ur germling) {
        for (ICropProvider provider : this.cropProviders) {
            if (!provider.isGermling(germling)) continue;
            return provider;
        }
        return null;
    }

    public Planter(TileMachine tile) {
        super(tile);
        this.inventory = new TileInventoryAdapter(tile, 12, "Items");
    }

    public Planter(TileMachine tile, ICropProvider provider) {
        super(tile);
        this.cropProviders.add(provider);
        this.inventory = new TileInventoryAdapter(tile, 12, "Items");
    }

    public Planter(TileMachine tile, ArrayList providers) {
        super(tile);
        for (ICropProvider provider : providers) {
            this.cropProviders.add(provider);
        }
        this.inventory = new TileInventoryAdapter(tile, 12, "Items");
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        by nbttaglistStructure;
        super.readFromNBT(nbttagcompound);
        this.isCleared = nbttagcompound.n("IsCleared");
        this.isUnbroken = nbttagcompound.n("IsBuilt");
        this.inventory.readFromNBT(nbttagcompound);
        if (nbttagcompound.b("TemplateArboretum")) {
            this.templateArboretum = new StructureConstruction();
            nbttaglistStructure = nbttagcompound.m("TemplateArboretum");
            this.templateArboretum.readFromNBT((bq)nbttaglistStructure.b(0));
        }
        if (nbttagcompound.b("TemplateSoil")) {
            this.templateSoil = new StructureConstruction();
            this.templateWater = new StructureConstruction();
            nbttaglistStructure = nbttagcompound.m("TemplateSoil");
            this.templateSoil.readFromNBT((bq)nbttaglistStructure.b(0));
            this.templateWater.readFromNBT((bq)nbttaglistStructure.b(0));
        }
        if (nbttagcompound.b("TemplatePlantation")) {
            this.templatePlantation = new StructureConstruction();
            nbttaglistStructure = nbttagcompound.m("TemplatePlantation");
            this.templatePlantation.readFromNBT((bq)nbttaglistStructure.b(0));
        }
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        bq nbttagcompoundStructure;
        by nbttaglistStructure;
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("IsCleared", this.isCleared);
        nbttagcompound.a("IsBuilt", this.isUnbroken);
        this.inventory.writeToNBT(nbttagcompound);
        if (this.templateArboretum != null) {
            nbttaglistStructure = new by();
            nbttagcompoundStructure = new bq();
            this.templateArboretum.writeToNBT(nbttagcompoundStructure);
            nbttaglistStructure.a((cd)nbttagcompoundStructure);
            nbttagcompound.a("TemplateArboretum", (cd)nbttaglistStructure);
        }
        if (this.templateSoil != null) {
            nbttaglistStructure = new by();
            nbttagcompoundStructure = new bq();
            this.templateSoil.writeToNBT(nbttagcompoundStructure);
            nbttaglistStructure.a((cd)nbttagcompoundStructure);
            nbttagcompound.a("TemplateSoil", (cd)nbttaglistStructure);
        }
        if (this.templatePlantation != null) {
            nbttaglistStructure = new by();
            nbttagcompoundStructure = new bq();
            this.templatePlantation.writeToNBT(nbttagcompoundStructure);
            nbttaglistStructure.a((cd)nbttagcompoundStructure);
            nbttagcompound.a("TemplatePlantation", (cd)nbttaglistStructure);
        }
    }

    protected boolean isSoilSlot(int i) {
        return i < 4;
    }

    protected boolean isGermlingSlot(int i) {
        return i < 8;
    }

    protected boolean isDisposalSlot(int i) {
        return i >= 8;
    }

    protected int getSoilStack() {
        for (int i = 0; i < this.inventory.k_(); ++i) {
            if (!this.isSoilSlot(i) || this.inventory.a(i) == null || !this.inventory.a(i).a(this.validSoil)) continue;
            return i;
        }
        return -1;
    }

    protected int getGermlingStack() {
        for (int i = 0; i < this.inventory.k_(); ++i) {
            if (!this.isGermlingStack(i)) continue;
            return i;
        }
        return -1;
    }

    protected boolean isGermlingStack(int i) {
        if (!this.isGermlingSlot(i)) {
            return false;
        }
        if (this.inventory.a(i) == null) {
            return false;
        }
        return this.hasGermlingBySeed(this.inventory.a(i));
    }

    protected int getDisposalStack() {
        for (int i = 0; i < this.inventory.k_(); ++i) {
            if (!this.isDisposalSlot(i) || this.inventory.a(i) == null || !this.inventory.a(i).a(this.validDisposal)) continue;
            return i;
        }
        return -1;
    }

    protected int getFreeSoilSlot() {
        for (int i = 0; i < 4; ++i) {
            if (this.inventory.a(i) == null) {
                return i;
            }
            if (!this.inventory.a(i).a(this.validSoil) || this.inventory.a((int)i).a >= this.inventory.a(i).d()) continue;
            return i;
        }
        return -1;
    }

    protected int getFreeGermlingSlot(ur germling) {
        for (int i = 4; i < 8; ++i) {
            if (this.inventory.a(i) == null) {
                return i;
            }
            if (!this.inventory.a(i).a(germling) || this.inventory.a((int)i).a >= this.inventory.a(i).d()) continue;
            return i;
        }
        return -1;
    }

    protected int getFreeDisposalSlot() {
        for (int i = 8; i < this.inventory.k_(); ++i) {
            if (this.inventory.a(i) == null) {
                return i;
            }
            if (!this.inventory.a(i).a(this.validDisposal) || this.inventory.a((int)i).a >= this.inventory.a(i).d()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void updateServerSide() {
        if (this.tile.k.G() % 20L * 10L != 0L) {
            return;
        }
        if (this.requiresSoil && this.getSoilStack() < 0) {
            this.setErrorState(EnumErrorCode.NORESOURCE);
        } else if (this.requiresGermling && this.getGermlingStack() < 0) {
            this.setErrorState(EnumErrorCode.NORESOURCE);
        } else if (this.getFreeDisposalSlot() < 0) {
            this.setErrorState(EnumErrorCode.NODISPOSAL);
        } else {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public boolean doWork() {
        if (!Proxies.common.isSimulating(this.tile.k)) {
            return false;
        }
        if (this.templateArboretum == null) {
            this.templateArboretum = new StructureConstruction(this.site, this.tile.Coords(), this.siteOffset);
        }
        if (this.soil != null && this.templateSoil == null) {
            this.templateSoil = new StructureConstruction(this.soil, this.tile.Coords(), this.soilOffset);
            this.templateWater = new StructureConstruction(this.soil, this.tile.Coords(), this.soilOffset);
        }
        if (this.plantation != null && this.templatePlantation == null) {
            this.templatePlantation = new StructureConstruction(this.plantation, this.tile.Coords(), this.plantationOffset);
        }
        if (!this.isCleared) {
            this.clearArea();
            return true;
        }
        if (this.maintainWater()) {
            // empty if block
        }
        if (this.maintainSoil() || this.maintainVegetation()) {
            // empty if block
        }
        this.dumpStash();
        return true;
    }

    private void clearArea() {
        if (this.templateArboretum.isFinished) {
            this.isCleared = true;
            this.templateArboretum.reset();
            return;
        }
        int curblockid = 0;
        while (curblockid == 0 && !this.templateArboretum.isFinished) {
            Vect curPos = new Vect(this.templateArboretum.getCurrentX(), this.templateArboretum.getCurrentY(), this.templateArboretum.getCurrentZ());
            curblockid = this.tile.k.a(curPos.x, curPos.y, curPos.z);
            if (curblockid != 0 && !GlobalManager.holyBlockIds.contains(curblockid) && this.templateArboretum.getCurrentBlockId() > -1) {
                ArrayList items = BlockUtil.getBlockItemStack(this.tile.k, curPos);
                this.tile.k.e(curPos.x, curPos.y, curPos.z, 0);
                if (items != null) {
                    for (int i = 0; i < items.size(); ++i) {
                        if (items.get(i) == null || ((ur)items.get(i)).b() == null || ((ur)items.get((int)i)).a <= 0) continue;
                        px entity = new px(this.tile.k, (double)curPos.x, (double)curPos.y, (double)curPos.z, (ur)items.get(i));
                        this.tile.k.d((lq)entity);
                    }
                }
            }
            this.templateArboretum.advanceStep();
        }
    }

    private boolean maintainSoil() {
        if (this.templateSoil.isFinished) {
            this.templateSoil.reset();
        }
        int processedBlocks = 0;
        while (!this.templateSoil.isFinished && processedBlocks < Config.planterThrottle) {
            ++processedBlocks;
            if (this.templateSoil.getCurrentBlockId() == this.validGround.c) {
                Vect pos = this.templateSoil.getCurrentPos();
                int blockid = this.tile.k.a(pos.x, pos.y, pos.z);
                int aboveid = this.tile.k.a(pos.x, pos.y + 1, pos.z);
                if (!(amq.p[blockid] != null && amq.p[blockid].m(this.tile.k, pos.x, pos.y, pos.z) < 0.0f || blockid == this.validGround.c || aboveid != 0 && aboveid != amq.aV.cm)) {
                    if (this.validWaste != null) {
                        if (blockid == this.validWaste.c) {
                            this.collectSand(pos);
                        }
                        if (this.validWaste.c == amq.y.cm && blockid == amq.x.cm) {
                            this.collectSand(pos);
                        }
                    }
                    return this.fillBlock(pos);
                }
            }
            this.templateSoil.advanceStep();
        }
        this.isUnbroken = true;
        return false;
    }

    private boolean maintainWater() {
        if (this.templateWater.isFinished) {
            this.templateWater.reset();
        }
        while (!this.templateWater.isFinished) {
            if (this.templateWater.getCurrentBlockId() == amq.E.cm) {
                Vect pos = this.templateWater.getCurrentPos();
                boolean skip = false;
                int blockid = this.tile.k.a(pos.x, pos.y, pos.z);
                if (blockid != amq.E.cm) {
                    int[] neighbourids = new int[]{this.tile.k.a(pos.x - 1, pos.y, pos.z), this.tile.k.a(pos.x + 1, pos.y, pos.z), this.tile.k.a(pos.x, pos.y, pos.z - 1), this.tile.k.a(pos.x, pos.y, pos.z + 1)};
                    for (int i = 0; i < neighbourids.length; ++i) {
                        if (neighbourids[i] == this.validGround.c || neighbourids[i] == this.validWaste.c) continue;
                        skip = true;
                        break;
                    }
                    if (!skip) {
                        return this.waterBlock(this.templateWater.getCurrentPos());
                    }
                }
            }
            this.templateWater.advanceStep();
        }
        return false;
    }

    private void collectSand(Vect blockPos) {
        this.tile.k.e(blockPos.x, blockPos.y, blockPos.z, 0);
        int slot = this.getFreeDisposalSlot();
        if (slot >= 0) {
            if (this.inventory.a(slot) == null) {
                this.inventory.a(slot, this.validDisposal.l());
            } else {
                ++this.inventory.a((int)slot).a;
            }
            return;
        }
    }

    protected boolean maintainVegetation() {
        if (this.templatePlantation == null) {
            return false;
        }
        if (this.templatePlantation.isFinished) {
            this.templatePlantation.reset();
        }
        for (int processedBlocks = 0; !this.templatePlantation.isFinished && processedBlocks < Config.planterThrottle; ++processedBlocks) {
            int z2;
            int y2;
            int x2;
            if (this.templatePlantation.getCurrentBlockId() == amq.B.cm && this.plantSapling(x2 = this.templatePlantation.getCurrentX(), y2 = this.templatePlantation.getCurrentY(), z2 = this.templatePlantation.getCurrentZ())) {
                this.templatePlantation.advanceStep();
                return true;
            }
            this.templatePlantation.advanceStep();
        }
        return false;
    }

    private boolean canFill() {
        return this.getSoilStack() >= 0;
    }

    private void decrSoilStack(int n) {
        int i = this.getSoilStack();
        if (i < 0) {
            return;
        }
        this.inventory.a(i, n);
    }

    protected void decrSaplingStack(int i, int n) {
        if (i < 0) {
            return;
        }
        this.inventory.a(i, n);
    }

    private boolean waterBlock(Vect pos) {
        this.tile.k.e(pos.x, pos.y, pos.z, amq.E.cm);
        return true;
    }

    private boolean fillBlock(Vect pos) {
        if (!this.canFill()) {
            return false;
        }
        this.tile.k.d(pos.x, pos.y, pos.z, this.validGround.c, this.validGround.j());
        int blockid = this.tile.k.a(pos.x, pos.y, pos.z);
        if (blockid == this.validGround.c) {
            this.decrSoilStack(1);
        }
        return true;
    }

    protected boolean plantSapling(int x2, int y2, int z2) {
        for (int stack = 0; stack < this.inventory.k_(); ++stack) {
            if (!this.isGermlingStack(stack)) continue;
            if (stack <= 0) {
                return false;
            }
            ICropProvider provider = this.getCropProvider(this.inventory.a(stack));
            if (provider == null || !provider.doPlant(this.inventory.a(stack), this.tile.k, x2, y2, z2)) continue;
            this.decrSaplingStack(stack, 1);
            return true;
        }
        return false;
    }

    private void dumpStash() {
        ForgeDirection[] pipes = BlockUtil.getPipeDirections(this.tile.k, this.tile.Coords(), ForgeDirection.UNKNOWN);
        if (pipes.length > 0) {
            this.dumpToPipe(pipes);
        } else {
            la[] inventories = BlockUtil.getAdjacentInventories(this.tile.k, this.tile.Coords(), ForgeDirection.UNKNOWN);
            this.dumpToInventory(inventories);
        }
    }

    private void dumpToPipe(ForgeDirection[] pipes) {
        for (int i = 8; i < this.inventory.k_(); ++i) {
            if (this.inventory.a(i) == null || this.inventory.a((int)i).a <= 0) continue;
            ForgeDirection[] filtered = !Config.planterSideSensitive ? pipes : BlockUtil.filterPipeDirections(pipes, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.UP});
            while (this.inventory.a((int)i).a > 0 && filtered.length > 0) {
                BlockUtil.putFromStackIntoPipe(this.tile, filtered, this.inventory.a(i));
            }
            if (this.inventory.a((int)i).a > 0) continue;
            this.inventory.a(i, null);
        }
    }

    private void dumpToInventory(la[] inventories) {
        for (int i = 8; i < this.inventory.k_(); ++i) {
            if (this.inventory.a(i) == null || this.inventory.a((int)i).a <= 0) continue;
            block1: for (int j = 0; j < inventories.length; ++j) {
                if (this.inventory.a(i) == null || inventories[j] instanceof TilePlanter) continue;
                for (int k = 0; k < inventories[j].k_(); ++k) {
                    int available;
                    ur stack = inventories[j].a(k);
                    if (stack == null) {
                        inventories[j].a(k, this.inventory.a(i));
                        this.inventory.a(i, null);
                        continue block1;
                    }
                    if (stack.c != this.inventory.a((int)i).c || (available = inventories[j].c() - stack.a) <= 0) continue;
                    if (available >= this.inventory.a((int)i).a) {
                        stack.a += this.inventory.a((int)i).a;
                        this.inventory.a(i, null);
                        continue block1;
                    }
                    stack.a = inventories[j].c();
                    this.inventory.a((int)i).a -= available;
                }
            }
        }
    }

    @Override
    public boolean isWorking() {
        return true;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        int max = 0;
        int avail = 0;
        for (int i = 4; i < 8; ++i) {
            max += 64;
            if (this.inventory.a(i) == null) continue;
            avail += this.inventory.a((int)i).a;
        }
        return (float)avail / (float)max > percentage;
    }

    @Override
    public boolean hasFuelMin(float percentage) {
        int max = 0;
        int avail = 0;
        for (int i = 0; i < 4; ++i) {
            max += 64;
            if (this.inventory.a(i) == null) continue;
            avail += this.inventory.a((int)i).a;
        }
        return (float)avail / (float)max > percentage;
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        if (stack.a(this.validSoil)) {
            return this.inventory.addStack(stack, 0, 4, false, doAdd);
        }
        if (this.hasGermlingBySeed(stack)) {
            return this.inventory.addStack(stack, 4, 4, false, doAdd);
        }
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        for (int i = 8; i < this.inventory.k_(); ++i) {
            if (this.inventory.a(i) == null || !this.inventory.a(i).a(this.validDisposal)) continue;
            ur product = this.validDisposal.l();
            if (doRemove) {
                this.a(i, 1);
            }
            return new ur[]{product};
        }
        return new ur[0];
    }

    @Override
    public int k_() {
        return this.inventory.k_();
    }

    @Override
    public ur a(int i) {
        return this.inventory.a(i);
    }

    @Override
    public void a(int i, ur itemstack) {
        this.inventory.a(i, itemstack);
    }

    @Override
    public ur a(int i, int j) {
        return this.inventory.a(i, j);
    }

    @Override
    public ur a_(int slot) {
        return this.inventory.a_(slot);
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0) {
            return 0;
        }
        if (side == 1) {
            return 4;
        }
        return 8;
    }

    @Override
    public int getSizeInventorySide(int side) {
        return 4;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
    }

    @Override
    public void sendGUINetworkData(rq container, rw iCrafting) {
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.lowSoil25);
        res.add(ForestryTrigger.lowSoil10);
        res.add(ForestryTrigger.lowGermlings25);
        res.add(ForestryTrigger.lowGermlings10);
        return res;
    }
}

