/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation.harvesters;

import forestry.api.cultivation.ICropEntity;
import forestry.api.cultivation.ICropProvider;
import forestry.core.config.Config;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.TileMachine;
import forestry.core.proxy.Proxies;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import forestry.core.utils.Vect;
import forestry.cultivation.gadgets.TilePlanter;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;

public abstract class Harvester
extends Machine {
    private ArrayList validWindfallIds = new ArrayList();
    private ArrayList validWindfall = new ArrayList();
    protected ArrayList cropProviders = new ArrayList();
    protected boolean isSideSensitive = true;
    protected ur[] harvestStacks = new ur[8];
    protected Vect area = new Vect(21, 13, 21);
    protected Vect posOffset = new Vect(-10, -2, -10);
    protected Vect posCurrent = new Vect(0, 0, 0);
    protected Vect posNext = null;
    protected boolean isFinished = false;
    private short productSlot1 = 0;
    private short windfallSlot1 = (short)4;

    public void putWindfall(ur windfall) {
        this.validWindfallIds.add(windfall.c);
        this.validWindfall.add(windfall);
    }

    public boolean isCropAt(int x2, int y2, int z2) {
        for (ICropProvider provider : this.cropProviders) {
            if (!provider.isCrop(this.tile.k, x2, y2, z2)) continue;
            return true;
        }
        return false;
    }

    private ICropProvider getCropProvider(int x2, int y2, int z2) {
        for (ICropProvider provider : this.cropProviders) {
            if (!provider.isCrop(this.tile.k, x2, y2, z2)) continue;
            return provider;
        }
        return null;
    }

    public boolean hasWindfallById(int id) {
        return this.validWindfallIds.contains(id);
    }

    public ur getWindfall(ur windfall) {
        for (ur stack : this.validWindfall) {
            if (!stack.a(windfall)) continue;
            return stack;
        }
        return null;
    }

    public Harvester(TileMachine machine) {
        super(machine);
    }

    public Harvester(TileMachine machine, ICropProvider provider) {
        super(machine);
        this.cropProviders.add(provider);
        ur[] windfall = provider.getWindfall();
        if (windfall != null && windfall.length > 0) {
            for (ur itemstack : windfall) {
                this.putWindfall(itemstack);
            }
        }
    }

    public Harvester(TileMachine machine, ArrayList providers) {
        super(machine);
        for (ICropProvider provider : providers) {
            this.cropProviders.add(provider);
            ur[] windfall = provider.getWindfall();
            if (windfall == null || windfall.length <= 0) continue;
            for (ur itemstack : windfall) {
                this.putWindfall(itemstack);
            }
        }
    }

    @Override
    public void openGui(qx player, la tile) {
    }

    @Override
    public void updateServerSide() {
    }

    protected int getFreeProductSlot(ur product) {
        for (int i = this.productSlot1; i < this.windfallSlot1; ++i) {
            if (this.harvestStacks[i] == null) {
                return i;
            }
            if (!this.harvestStacks[i].a(product) || this.harvestStacks[i].a >= this.harvestStacks[i].d()) continue;
            return i;
        }
        return -1;
    }

    private int getFreeWindfallSlot(ur windfall) {
        for (int i = this.windfallSlot1; i < this.harvestStacks.length; ++i) {
            if (this.harvestStacks[i] == null) {
                return i;
            }
            if (!this.harvestStacks[i].a(windfall) || this.harvestStacks[i].a >= this.harvestStacks[i].d()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean doWork() {
        if (!Proxies.common.isSimulating(this.tile.k)) {
            return false;
        }
        if (this.posNext != null) {
            Vect killMe = this.posNext;
            this.posNext = null;
            ICropProvider provider = this.getCropProvider(killMe.x, killMe.y, killMe.z);
            if (provider == null) {
                return false;
            }
            ICropEntity crop = provider.getCrop(this.tile.k, killMe.x, killMe.y, killMe.z);
            if (crop != null && crop.isHarvestable()) {
                this.hewTree(crop);
            }
            return true;
        }
        int processedBlocks = 0;
        while (!this.isFinished && processedBlocks < Config.harvesterThrottle) {
            ICropEntity crop;
            ++processedBlocks;
            this.advanceAxe();
            Vect posBlock = this.posCurrent.add(this.tile.Coords());
            posBlock = posBlock.add(this.posOffset);
            this.tile.k.a(posBlock.x, posBlock.y, posBlock.z);
            ICropProvider provider = this.getCropProvider(posBlock.x, posBlock.y, posBlock.z);
            if (provider == null || (crop = provider.getCrop(this.tile.k, posBlock.x, posBlock.y, posBlock.z)) == null || !crop.isHarvestable()) continue;
            this.hewTree(crop);
            break;
        }
        this.collectWindfall();
        this.dumpStash();
        if (this.isFinished) {
            this.resetAxe();
        }
        return true;
    }

    protected void advanceAxe() {
        if (this.posCurrent.z < this.area.z - 1) {
            ++this.posCurrent.z;
        } else {
            this.posCurrent.z = 0;
            if (this.posCurrent.x < this.area.x - 1) {
                ++this.posCurrent.x;
            } else {
                this.posCurrent.x = 0;
                if (this.posCurrent.y < this.area.y - 1) {
                    ++this.posCurrent.y;
                } else {
                    this.isFinished = true;
                }
            }
        }
    }

    protected void hewTree(ICropEntity entity) {
        ArrayList harvest = entity.doHarvest();
        this.storeProduct(harvest);
        int[] next = entity.getNextPosition();
        if (next == null || next.length <= 0) {
            return;
        }
        this.posNext = new Vect(next[0], next[1], next[2]);
    }

    protected void storeProduct(ArrayList harvest) {
        for (ur stack : harvest) {
            int slot = this.getFreeProductSlot(stack);
            if (slot < 0) {
                return;
            }
            if (this.harvestStacks[slot] == null) {
                this.harvestStacks[slot] = stack;
                continue;
            }
            if (this.harvestStacks[slot].a > this.harvestStacks[slot].d() - stack.a || !this.harvestStacks[slot].a(stack)) continue;
            this.harvestStacks[slot].a += stack.a;
        }
    }

    protected void resetAxe() {
        this.isFinished = false;
        this.posCurrent = new Vect(0, 0, 0);
    }

    protected void collectWindfall() {
        Vect min = new Vect(this.tile.l + this.posOffset.x, this.tile.m + this.posOffset.y, this.tile.n + this.posOffset.z);
        Vect max = new Vect(this.tile.l + this.posOffset.x + this.area.x, this.tile.m + this.posOffset.y + this.area.y, this.tile.n + this.posOffset.z + this.area.z);
        aoe harvestBox = aoe.a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
        List list = this.tile.k.a(lq.class, harvestBox);
        for (int i = 0; i < list.size(); ++i) {
            ur windfall;
            px item;
            ur contained;
            lq entity = (lq)list.get(i);
            if (!(entity instanceof px) || (contained = (item = (px)entity).d()) == null || !this.hasWindfallById(contained.c) || (windfall = this.getWindfall(contained)) == null || windfall.j() != contained.j() || !this.storeWindfall(contained)) continue;
            item.x();
        }
    }

    private boolean storeWindfall(ur item) {
        int slot = this.getFreeWindfallSlot(item);
        if (slot < 0) {
            return false;
        }
        if (this.harvestStacks[slot] == null) {
            this.harvestStacks[slot] = item.l();
        } else if (this.harvestStacks[slot].a < this.c() && this.harvestStacks[slot].a(item)) {
            ++this.harvestStacks[slot].a;
        }
        return true;
    }

    protected void dumpStash() {
        ForgeDirection[] pipes = BlockUtil.getPipeDirections(this.tile.k, this.tile.Coords(), ForgeDirection.UNKNOWN);
        if (pipes.length > 0) {
            this.dumpToPipe(pipes);
        } else {
            la[] inventories = BlockUtil.getAdjacentInventories(this.tile.k, this.tile.Coords(), ForgeDirection.UNKNOWN);
            this.dumpToInventory(inventories);
        }
    }

    private void dumpToPipe(ForgeDirection[] pipes) {
        for (int i = 0; i < this.harvestStacks.length; ++i) {
            if (this.harvestStacks[i] == null || this.harvestStacks[i].a <= 0) continue;
            ForgeDirection[] filtered = !this.isSideSensitive || !Config.harvesterSideSensitive ? pipes : (this.hasWindfallById(this.harvestStacks[i].c) ? BlockUtil.filterPipeDirections(pipes, new ForgeDirection[]{ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.SOUTH}) : BlockUtil.filterPipeDirections(pipes, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.UP}));
            while (this.harvestStacks[i].a > 0 && filtered.length > 0) {
                BlockUtil.putFromStackIntoPipe(this.tile, filtered, this.harvestStacks[i]);
            }
            if (this.harvestStacks[i].a > 0) continue;
            this.harvestStacks[i] = null;
        }
    }

    private void dumpToInventory(la[] inventories) {
        for (int i = 0; i < this.harvestStacks.length; ++i) {
            if (this.harvestStacks[i] == null || this.harvestStacks[i].a <= 0) continue;
            for (int j = 0; j < inventories.length; ++j) {
                if (this.harvestStacks[i] == null || inventories[j] instanceof TilePlanter) continue;
                la inventory = Utils.getChest(inventories[j]);
                StackUtils.stowInInventory(this.harvestStacks[i], inventory, true);
                if (this.harvestStacks[i].a > 0) continue;
                this.harvestStacks[i] = null;
            }
        }
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        by nbttaglist = nbttagcompound.m("Items");
        this.harvestStacks = new ur[this.k_()];
        for (int i = 0; i < nbttaglist.c(); ++i) {
            bq nbttagcompound1 = (bq)nbttaglist.b(i);
            byte byte0 = nbttagcompound1.c("Slot");
            if (byte0 < 0 || byte0 >= this.harvestStacks.length) continue;
            this.harvestStacks[byte0] = ur.a((bq)nbttagcompound1);
        }
        this.isFinished = nbttagcompound.n("IsFinished");
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        by nbttaglist = new by();
        for (int i = 0; i < this.harvestStacks.length; ++i) {
            if (this.harvestStacks[i] == null) continue;
            bq nbttagcompound1 = new bq();
            nbttagcompound1.a("Slot", (byte)i);
            this.harvestStacks[i].b(nbttagcompound1);
            nbttaglist.a((cd)nbttagcompound1);
        }
        nbttagcompound.a("Items", (cd)nbttaglist);
        nbttagcompound.a("IsFinished", this.isFinished);
    }

    @Override
    public ur a(int i) {
        return this.harvestStacks[i];
    }

    @Override
    public int k_() {
        return this.harvestStacks.length;
    }

    @Override
    public ur a(int i, int j) {
        if (this.harvestStacks[i] == null) {
            return null;
        }
        if (this.harvestStacks[i].a <= j) {
            ur product = this.harvestStacks[i];
            this.harvestStacks[i] = null;
            return product;
        }
        ur product = this.harvestStacks[i].a(j);
        if (this.harvestStacks[i].a == 0) {
            this.harvestStacks[i] = null;
        }
        return product;
    }

    @Override
    public void a(int i, ur itemstack) {
        this.harvestStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.c()) {
            itemstack.a = this.c();
        }
    }

    @Override
    public ur a_(int slot) {
        if (this.harvestStacks[slot] == null) {
            return null;
        }
        ur toReturn = this.harvestStacks[slot];
        this.harvestStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0 || side == 1) {
            return 4;
        }
        return 0;
    }

    @Override
    public int getSizeInventorySide(int side) {
        return 4;
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        for (int i = 0; i < this.harvestStacks.length; ++i) {
            if (this.harvestStacks[i] == null) continue;
            ur product = null;
            if (this.hasWindfallById(this.harvestStacks[i].b().cj)) {
                if (Config.harvesterSideSensitive && this.isSideSensitive && from != ForgeDirection.DOWN && from != ForgeDirection.UP) continue;
                product = this.getWindfall(this.harvestStacks[i]);
            } else {
                if (Config.harvesterSideSensitive && this.isSideSensitive && (from == ForgeDirection.DOWN || from == ForgeDirection.UP)) continue;
                product = new ur(this.harvestStacks[i].b().cj, 1, 0);
            }
            if (doRemove && product != null) {
                this.a(i, 1);
            }
            return new ur[]{product};
        }
        return new ur[0];
    }

    @Override
    public boolean isWorking() {
        return true;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
    }

    @Override
    public void sendGUINetworkData(rq container, rw iCrafting) {
    }
}

