/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation.gadgets;

import forestry.core.EnumErrorCode;
import forestry.core.gadgets.Mill;
import forestry.core.gadgets.TileMill;
import forestry.core.proxy.Proxies;
import forestry.core.utils.TileInventoryAdapter;
import forestry.core.utils.Vect;
import forestry.cultivation.Overgrowth;
import java.util.ArrayList;
import net.minecraftforge.common.ForgeDirection;

public abstract class MillGrower
extends Mill {
    public final ur catalyst;
    private ArrayList validCropIds = new ArrayList();
    private ArrayList validOvergrowth = new ArrayList();
    private TileInventoryAdapter inventory;
    private Vect area = new Vect(21, 3, 21);
    private Vect posOffset = new Vect(-10, -1, -10);
    private Vect posCurrent = new Vect(0, 0, 0);
    private boolean isFinished = false;

    public MillGrower(TileMill machine, ur catalyst) {
        super(machine);
        this.tileMill = machine;
        this.catalyst = catalyst;
        this.inventory = new TileInventoryAdapter(machine, 1, "Items");
    }

    protected void putOvergrowth(Overgrowth overgrowth) {
        this.validCropIds.add(overgrowth.crop.c);
        this.validOvergrowth.add(overgrowth);
    }

    public boolean hasOvergrowthByCropId(int cropid) {
        return this.validCropIds.contains(cropid);
    }

    public Overgrowth getOvergrowthByCrop(ur crop) {
        for (Overgrowth growth : this.validOvergrowth) {
            if (!growth.hasCrop(crop)) continue;
            return growth;
        }
        return null;
    }

    public abstract void growCrop(yc var1, int var2, Vect var3);

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.inventory.readFromNBT(nbttagcompound);
        this.isFinished = nbttagcompound.n("IsFinished");
        this.charge = nbttagcompound.e("Charge");
        this.progress = nbttagcompound.g("Progress");
        this.stage = nbttagcompound.e("Stage");
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.inventory.writeToNBT(nbttagcompound);
        nbttagcompound.a("IsFinished", this.isFinished);
        nbttagcompound.a("Charge", this.charge);
        nbttagcompound.a("Progress", this.progress);
        nbttagcompound.a("Stage", this.stage);
    }

    private int getFreeCatalystSlot() {
        for (int i = 0; i < 1; ++i) {
            if (this.inventory.a(i) == null) {
                return i;
            }
            if (!this.inventory.a(i).a(this.catalyst) || this.inventory.a((int)i).a >= this.inventory.a(i).d()) continue;
            return i;
        }
        return -1;
    }

    public void resetProgress() {
        this.isFinished = false;
        this.posCurrent = new Vect(0, 0, 0);
    }

    private void advanceProgress() {
        if (this.posCurrent.z < this.area.z - 1) {
            ++this.posCurrent.z;
        } else {
            this.posCurrent.z = 0;
            if (this.posCurrent.x < this.area.x - 1) {
                ++this.posCurrent.x;
            } else {
                this.posCurrent.x = 0;
                if (this.posCurrent.y < this.area.y - 1) {
                    ++this.posCurrent.y;
                } else {
                    this.isFinished = true;
                }
            }
        }
    }

    @Override
    public void activate() {
        float f = (float)this.tile.l + 0.5f;
        float f1 = (float)this.tile.m + 0.0f + this.tile.k.t.nextFloat() * 6.0f / 16.0f;
        float f2 = (float)this.tile.n + 0.5f;
        float f3 = 0.52f;
        float f4 = this.tile.k.t.nextFloat() * 0.6f - 0.3f;
        Proxies.common.addEntityBiodustFX(this.tile.k, f - f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
        Proxies.common.addEntityBiodustFX(this.tile.k, f + f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
        Proxies.common.addEntityBiodustFX(this.tile.k, f + f4, f1, f2 - f3, 0.0f, 0.0f, 0.0f);
        Proxies.common.addEntityBiodustFX(this.tile.k, f + f4, f1, f2 + f3, 0.0f, 0.0f, 0.0f);
        if (Proxies.common.isSimulating(this.tile.k)) {
            this.catalyze();
            this.charge = 0;
            this.tileMill.sendNetworkUpdate();
        }
    }

    public void catalyze() {
        while (!this.isFinished && this.canCatalyze()) {
            this.advanceProgress();
            Vect posBlock = this.posCurrent.add(this.tile.Coords());
            posBlock = posBlock.add(this.posOffset);
            int blockid = this.tile.k.a(posBlock.x, posBlock.y, posBlock.z);
            if (!this.hasOvergrowthByCropId(blockid) || !this.applyCatalyst(posBlock)) continue;
            this.a(0, 1);
            break;
        }
        if (this.isFinished) {
            this.resetProgress();
        }
    }

    @Override
    public boolean doWork() {
        if (!Proxies.common.isSimulating(this.tile.k)) {
            return false;
        }
        if (this.charge != 0) {
            return false;
        }
        if (this.canCatalyze()) {
            this.setErrorState(EnumErrorCode.OK);
            this.charge = 1;
        } else {
            this.setErrorState(EnumErrorCode.NORESOURCE);
        }
        return true;
    }

    @Override
    public boolean isWorking() {
        return this.charge != 0 || this.canCatalyze();
    }

    private boolean canCatalyze() {
        if (this.inventory.a(0) == null) {
            return false;
        }
        if (!this.inventory.a(0).a(this.catalyst)) {
            return false;
        }
        return this.inventory.a((int)0).a > 0;
    }

    private boolean applyCatalyst(Vect posBlock) {
        int cropMeta;
        int cropId = this.tile.k.a(posBlock.x, posBlock.y, posBlock.z);
        Overgrowth growth = this.getOvergrowthByCrop(new ur(cropId, 1, cropMeta = this.tile.k.h(posBlock.x, posBlock.y, posBlock.z)));
        if (growth == null) {
            return false;
        }
        this.growCrop(this.tile.k, cropId, posBlock);
        int blockid = this.tile.k.a(posBlock.x, posBlock.y, posBlock.z);
        int meta = this.tile.k.h(posBlock.x, posBlock.y, posBlock.z);
        return growth.hasRipe(new ur(blockid, 1, meta));
    }

    @Override
    public int k_() {
        return this.inventory.k_();
    }

    @Override
    public ur a(int i) {
        return this.inventory.a(i);
    }

    @Override
    public void a(int i, ur itemstack) {
        this.inventory.a(i, itemstack);
    }

    @Override
    public ur a(int i, int j) {
        return this.inventory.a(i, j);
    }

    @Override
    public ur a_(int slot) {
        return this.inventory.a_(slot);
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        if (stack.a(this.catalyst)) {
            int slot = this.getFreeCatalystSlot();
            if (slot < 0) {
                return 0;
            }
            return this.inventory.addStack(stack, false, doAdd);
        }
        return 0;
    }
}

