/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.recipes.RecipeManagers;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.interfaces.IDescriptiveRecipe;
import forestry.core.proxy.Proxies;
import net.minecraftforge.liquids.LiquidStack;

public class RecipeUtil {
    public static void injectLeveledRecipe(ur resource, int fermentationValue, ur outputItem) {
        if (RecipeManagers.fermenterManager == null) {
            return;
        }
        if (!Config.invalidFingerprint) {
            RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.0f, new LiquidStack(outputItem.c, 1, outputItem.j()), new LiquidStack(amq.E, 1));
            if (ForestryItem.liquidJuice != null) {
                RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.5f, new LiquidStack(outputItem.c, 1, outputItem.j()), new LiquidStack(ForestryItem.liquidJuice, 1));
            }
            if (ForestryItem.liquidHoney != null) {
                RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.5f, new LiquidStack(outputItem.c, 1, outputItem.j()), new LiquidStack(ForestryItem.liquidHoney, 1));
            }
        } else {
            RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 0.5f, new LiquidStack(outputItem.c, 1, outputItem.j()), new LiquidStack(amq.G, 1));
        }
    }

    public static Object[] getCraftingRecipeAsArray(Object rec) {
        try {
            if (rec instanceof IDescriptiveRecipe) {
                IDescriptiveRecipe recipe = (IDescriptiveRecipe)rec;
                return RecipeUtil.getShapedRecipeAsArray(recipe.getWidth(), recipe.getHeight(), recipe.getIngredients(), recipe.b());
            }
        }
        catch (Exception ex) {
            Proxies.log.warning("Exception while trying to parse an ItemStack[10] from an IRecipe:");
            Proxies.log.warning(ex.getMessage());
        }
        return null;
    }

    private static Object[] getShapedRecipeAsArray(int width, int height, Object[] ingredients, ur output) {
        Object[] result = new Object[10];
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                result[y2 * 3 + x2] = ingredients[y2 * width + x2];
            }
        }
        result[9] = output;
        return result;
    }
}

