/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.recipes.RecipeManagers;
import forestry.core.config.ForestryItem;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;

public class LiquidHelper {
    public static boolean isEmptyLiquidData() {
        return LiquidContainerRegistry.getRegisteredLiquidContainerData().length <= 0;
    }

    public static boolean isEmptyContainer(ur empty) {
        return LiquidContainerRegistry.isEmptyContainer((ur)empty);
    }

    public static LiquidContainerData getEmptyContainer(ur empty, LiquidStack liquid) {
        for (LiquidContainerData cont : LiquidContainerRegistry.getRegisteredLiquidContainerData()) {
            if (!cont.stillLiquid.isLiquidEqual(liquid) || !cont.container.a(empty)) continue;
            return cont;
        }
        return null;
    }

    public static LiquidContainerData getLiquidContainer(ur container) {
        for (LiquidContainerData cont : LiquidContainerRegistry.getRegisteredLiquidContainerData()) {
            if (!cont.filled.a(container)) continue;
            return cont;
        }
        return null;
    }

    public static LiquidContainerData createLiquidData(String ident, LiquidStack stillLiquid, ur filled, ur container) {
        LiquidStack still = LiquidDictionary.getOrCreateLiquid((String)ident, (LiquidStack)stillLiquid);
        return new LiquidContainerData(still, filled, container);
    }

    public static void injectLiquidContainer(LiquidContainerData container) {
        LiquidHelper.injectLiquidContainer(container, null, 0);
    }

    public static void injectWaxContainer(LiquidContainerData container) {
        LiquidHelper.injectLiquidContainer(container, new ur(ForestryItem.beeswax), 10);
    }

    public static void injectRefractoryContainer(LiquidContainerData container) {
        LiquidHelper.injectLiquidContainer(container, new ur(ForestryItem.refractoryWax), 10);
    }

    public static void injectTinContainer(LiquidContainerData container) {
        LiquidHelper.injectLiquidContainer(container, ForestryItem.ingotTin, 5);
    }

    public static void injectLiquidContainer(LiquidContainerData container, ur remnant, int chance) {
        LiquidContainerRegistry.registerLiquid((LiquidContainerData)container);
        if (RecipeManagers.squeezerManager != null && !container.container.b().s()) {
            if (remnant != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ur[]{container.filled}, container.stillLiquid, remnant, chance);
            } else {
                RecipeManagers.squeezerManager.addRecipe(10, new ur[]{container.filled}, container.stillLiquid);
            }
        }
        if (RecipeManagers.bottlerManager != null) {
            RecipeManagers.bottlerManager.addRecipe(5, container.stillLiquid, container.container, container.filled);
        }
    }
}

