/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.core.network.ForestryPacket;
import forestry.core.proxy.Proxies;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PacketFXSignal
extends ForestryPacket {
    private VisualFXType visualFX;
    private SoundFXType soundFX;
    private int xCoord;
    private int yCoord;
    private int zCoord;
    private int blockid;
    private int meta;

    public PacketFXSignal() {
    }

    public PacketFXSignal(VisualFXType type, int xCoord, int yCoord, int zCoord, int blockid, int meta) {
        this(type, SoundFXType.NONE, xCoord, yCoord, zCoord, blockid, meta);
    }

    public PacketFXSignal(SoundFXType type, int xCoord, int yCoord, int zCoord, int blockid, int meta) {
        this(VisualFXType.NONE, type, xCoord, yCoord, zCoord, blockid, meta);
    }

    public PacketFXSignal(VisualFXType visualFX, SoundFXType soundFX, int xCoord, int yCoord, int zCoord, int blockid, int meta) {
        super(4);
        this.visualFX = visualFX;
        this.soundFX = soundFX;
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.blockid = blockid;
        this.meta = meta;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeShort(this.visualFX.ordinal());
        data.writeShort(this.soundFX.ordinal());
        data.writeInt(this.xCoord);
        data.writeInt(this.yCoord);
        data.writeInt(this.zCoord);
        data.writeInt(this.blockid);
        data.writeInt(this.meta);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        this.visualFX = VisualFXType.values()[data.readShort()];
        this.soundFX = SoundFXType.values()[data.readShort()];
        this.xCoord = data.readInt();
        this.yCoord = data.readInt();
        this.zCoord = data.readInt();
        this.blockid = data.readInt();
        this.meta = data.readInt();
    }

    public void executeFX() {
        if (this.visualFX != VisualFXType.NONE) {
            Proxies.common.addBlockDestroyEffects(Proxies.common.getRenderWorld(), this.xCoord, this.yCoord, this.zCoord, this.blockid, this.meta);
        }
        if (this.soundFX != SoundFXType.NONE) {
            if (this.soundFX == SoundFXType.BLOCK_DESTROY) {
                Proxies.common.playBlockBreakSoundFX(Proxies.common.getRenderWorld(), this.xCoord, this.yCoord, this.zCoord, amq.p[this.blockid]);
            } else if (this.soundFX == SoundFXType.BLOCK_PLACE) {
                Proxies.common.playBlockPlaceSoundFX(Proxies.common.getRenderWorld(), this.xCoord, this.yCoord, this.zCoord, amq.p[this.blockid]);
            } else {
                yc yc2 = Proxies.common.getRenderWorld();
                String string = this.soundFX.soundFile;
                ((Object)((Object)this.soundFX)).getClass();
                ((Object)((Object)this.soundFX)).getClass();
                Proxies.common.playSoundFX(yc2, this.xCoord, this.yCoord, this.zCoord, string, 1.0f, 1.0f);
            }
        }
    }

    public static enum SoundFXType {
        NONE(""),
        BLOCK_DESTROY(""),
        BLOCK_PLACE(""),
        LEAF("step.grass"),
        LOG("dig.wood"),
        DIRT("dig.gravel");

        public final String soundFile;
        public final float volume = 1.0f;
        public final float pitch = 1.0f;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private SoundFXType() {
            void soundFile;
            this.soundFile = soundFile;
        }
    }

    public static enum VisualFXType {
        NONE,
        BLOCK_DESTROY,
        SAPLING_PLACE;

    }
}

